/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import evilcraft.core.config.configurable.ConfigurableItem;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.config.extendedconfig.ItemConfig;
import evilcraft.core.helper.ItemHelpers;
import evilcraft.modcompat.baubles.BaublesModCompat;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;

@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles", striprefs=true)
public class EffortlessRing
extends ConfigurableItem
implements IBauble {
    private static final int TICK_MODULUS = 1;
    private static final String PLAYER_NBT_KEY = "evilcraft:lastStepSize";
    private static final float SPEED_BONUS = 0.05f;
    private static final float STEP_SIZE = 1.0f;
    private static final float JUMP_DISTANCE_FACTOR = 0.05f;
    private static final float JUMP_HEIGHT_FACTOR = 0.3f;
    private static final float FALLDISTANCE_REDUCTION = 2.0f;
    private static EffortlessRing _instance = null;

    public static void initInstance(ExtendedConfig<ItemConfig> eConfig) {
        if (_instance == null) {
            _instance = new EffortlessRing(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static EffortlessRing getInstance() {
        return _instance;
    }

    private EffortlessRing(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig);
        this.func_77625_d(1);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        return EnumRarity.uncommon;
    }

    public void adjustParameters(ItemStack itemStack, EntityPlayer player) {
        if (player.field_70701_bs > 0.0f && player.field_70122_E) {
            player.func_70060_a(0.0f, 1.0f, player.func_70090_H() ? 0.016666668f : 0.05f);
        }
        if (!player.getEntityData().func_74764_b(PLAYER_NBT_KEY)) {
            player.getEntityData().func_74776_a(PLAYER_NBT_KEY, player.field_70138_W);
        }
        float f = player.field_70138_W = player.func_70093_af() ? 0.5f : 1.0f;
        if (!player.field_70122_E) {
            player.field_70747_aH = 0.05f;
        }
    }

    @SubscribeEvent
    public void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        EntityPlayer player;
        if (event.entityLiving instanceof EntityPlayer && ItemHelpers.hasPlayerItem(player = (EntityPlayer)event.entityLiving, this)) {
            player.field_70181_x += (double)0.3f;
        }
    }

    @SubscribeEvent
    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player;
        if (event.entityLiving instanceof EntityPlayer && (player = (EntityPlayer)event.entityLiving).getEntityData().func_74764_b(PLAYER_NBT_KEY) && !ItemHelpers.hasPlayerItem(player, this)) {
            player.field_70138_W = player.getEntityData().func_74760_g(PLAYER_NBT_KEY);
            player.getEntityData().func_82580_o(PLAYER_NBT_KEY);
        }
    }

    @SubscribeEvent
    public void onPlayerFall(LivingFallEvent event) {
        EntityPlayer player;
        if (event.entityLiving instanceof EntityPlayer && ItemHelpers.hasPlayerItem(player = (EntityPlayer)event.entityLiving, this)) {
            event.distance -= 2.0f;
        }
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (entity instanceof EntityPlayer) {
            this.adjustParameters(itemStack, (EntityPlayer)entity);
        }
        super.func_77663_a(itemStack, world, entity, par4, par5);
    }

    @Optional.Method(modid="Baubles")
    public boolean canEquip(ItemStack itemStack, EntityLivingBase entity) {
        return BaublesModCompat.canUse();
    }

    @Optional.Method(modid="Baubles")
    public boolean canUnequip(ItemStack itemStack, EntityLivingBase entity) {
        return true;
    }

    @Optional.Method(modid="Baubles")
    public BaubleType getBaubleType(ItemStack itemStack) {
        return BaubleType.RING;
    }

    @Optional.Method(modid="Baubles")
    public void onEquipped(ItemStack itemStack, EntityLivingBase entity) {
    }

    @Optional.Method(modid="Baubles")
    public void onUnequipped(ItemStack itemStack, EntityLivingBase entity) {
    }

    @Optional.Method(modid="Baubles")
    public void onWornTick(ItemStack itemStack, EntityLivingBase entity) {
        if (BaublesModCompat.canUse()) {
            this.func_77663_a(itemStack, entity.field_70170_p, (Entity)entity, 0, false);
        }
    }
}

