/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.Achievements;
import evilcraft.ExtendedDamageSource;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.config.extendedconfig.ItemConfig;
import evilcraft.entity.monster.VengeanceSpirit;
import evilcraft.item.Mace;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class MaceOfDistortion
extends Mace {
    private static MaceOfDistortion _instance = null;
    public static final int AOE_TICK_UPDATE = 20;
    private static final int MAXIMUM_CHARGE = 100;
    private static final float MELEE_DAMAGE = 7.0f;
    private static final float RADIAL_DAMAGE = 3.0f;
    private static final int CONTAINER_SIZE = 4000;
    private static final int HIT_USAGE = 5;
    private static final int POWER_LEVELS = 5;

    public static void initInstance(ExtendedConfig<ItemConfig> eConfig) {
        if (_instance == null) {
            _instance = new MaceOfDistortion(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static MaceOfDistortion getInstance() {
        return _instance;
    }

    private MaceOfDistortion(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig, 4000, 5, 100, 5, 7.0f);
    }

    protected void distortEntities(World world, EntityPlayer player, int itemUsedCount, int power) {
        double x = player.field_70165_t;
        double y = player.field_70163_u;
        double z = player.field_70161_v;
        double area = this.getArea(itemUsedCount);
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)x, (double)y, (double)z).func_72314_b(area, area, area);
        List entities = world.func_94576_a((Entity)player, box, new IEntitySelector(){

            public boolean func_82704_a(Entity entity) {
                return true;
            }
        });
        boolean onePlayer = false;
        for (Entity entity : entities) {
            if (entity instanceof EntityPlayer) {
                onePlayer = true;
            }
            this.distortEntity(world, player, entity, x, y, z, itemUsedCount, power);
        }
        if (entities.size() >= 10) {
            player.func_71064_a((StatBase)Achievements.DISTORTER, 1);
            if (onePlayer) {
                player.func_71064_a((StatBase)Achievements.PLAYER_DISTORTER, 1);
            }
        }
    }

    public void distortEntity(World world, EntityPlayer player, Entity entity, double x, double y, double z, int itemUsedCount, int power) {
        double dz;
        double inverseStrength = entity.func_70011_f(x, y, z) / (double)(itemUsedCount + 1);
        double knock = (double)(power + itemUsedCount / 200) + 1.0;
        double dx = entity.field_70165_t - x;
        double dy = entity.field_70163_u + (double)entity.func_70047_e() - y;
        double d = MathHelper.func_76133_a((double)(dx * dx + dy * dy + (dz = entity.field_70161_v - z) * dz));
        if (d != 0.0) {
            dx /= d;
            dy /= d;
            dz /= d;
            double strength = (1.0 - inverseStrength) * knock;
            if (entity instanceof EntityLivingBase) {
                ExtendedDamageSource damageSource = player == null ? ExtendedDamageSource.distorted : DamageSource.func_76365_a((EntityPlayer)player);
                entity.func_70097_a((DamageSource)damageSource, 3.0f * (float)power);
                if (world.field_72995_K) {
                    MaceOfDistortion.showEntityDistored(world, player, entity, power);
                }
            }
            if (entity instanceof VengeanceSpirit) {
                ((VengeanceSpirit)entity).setIsSwarm(true);
            }
            if (player != null && entity instanceof EntityPlayer) {
                player.func_71064_a((StatBase)Achievements.PLAYER_DISTORTER, 1);
            }
            entity.field_70159_w += dx * (strength /= 2.0);
            entity.field_70181_x += dy * strength;
            entity.field_70179_y += dz * strength;
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected static void showEntityDistored(World world, EntityPlayer player, Entity entity, int power) {
        world.func_72956_a(entity, "random.explode", (float)(power + 1) / 5.0f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        if (player != null) {
            world.func_72956_a((Entity)player, "random.explode", (float)(power + 1) / 5.0f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        }
        world.func_72869_a("largeexplode", entity.field_70165_t, entity.field_70163_u + (double)field_77697_d.nextFloat(), entity.field_70161_v, 1.0, 0.0, 0.0);
    }

    @Override
    protected void use(World world, EntityPlayer player, int itemUsedCount, int power) {
        this.distortEntities(world, player, itemUsedCount, power);
    }
}

