/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.item;

import com.google.common.collect.Maps;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.core.config.configurable.ConfigurableItem;
import evilcraft.core.config.extendedconfig.BlockConfig;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.config.extendedconfig.ItemConfig;
import evilcraft.core.helper.L10NHelpers;
import evilcraft.core.helper.RenderHelpers;
import evilcraft.core.tileentity.WorkingTileEntity;
import evilcraft.core.tileentity.upgrade.Upgrades;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import org.lwjgl.input.Keyboard;

public class Promise
extends ConfigurableItem {
    private static Promise _instance = null;
    public static final Upgrades.Upgrade[] UPGRADES = new Upgrades.Upgrade[]{WorkingTileEntity.UPGRADE_TIER1, WorkingTileEntity.UPGRADE_TIER2, WorkingTileEntity.UPGRADE_TIER3, WorkingTileEntity.UPGRADE_SPEED, WorkingTileEntity.UPGRADE_EFFICIENCY};
    public static final Map<Upgrades.Upgrade, Integer> MAIN_COLORS = Maps.newHashMap();
    public static final Map<Upgrades.Upgrade, Integer> SECONDARY_COLORS = Maps.newHashMap();
    private IIcon overlay;

    public static void initInstance(ExtendedConfig<ItemConfig> eConfig) {
        if (_instance == null) {
            _instance = new Promise(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static Promise getInstance() {
        return _instance;
    }

    private Promise(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig);
        this.func_77625_d(4);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public int getItemStackLimit(ItemStack itemStack) {
        if (itemStack.func_77960_j() <= 2) {
            return 1;
        }
        return super.getItemStackLimit(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack itemStack, int pass) {
        return pass == 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack itemStack, int renderPass) {
        Upgrades.Upgrade upgrade = this.getUpgrade(itemStack);
        return renderPass == 0 ? SECONDARY_COLORS.get(upgrade).intValue() : MAIN_COLORS.get(upgrade).intValue();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        if (Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42)) {
            list.add(EnumChatFormatting.DARK_GREEN + L10NHelpers.localize(super.func_77667_c(itemStack) + ".useIn"));
            for (BlockConfig upgradable : this.getUpgrade(itemStack).getUpgradables()) {
                list.add(EnumChatFormatting.ITALIC + L10NHelpers.localize("tile." + upgradable.getUnlocalizedName() + ".name"));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        super.func_94581_a(iconRegister);
        this.overlay = iconRegister.func_94245_a(this.func_111208_A() + "_overlay");
    }

    public IIcon func_77618_c(int meta, int renderpass) {
        return renderpass == 0 ? this.overlay : super.func_77618_c(meta, renderpass);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < UPGRADES.length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public String func_77667_c(ItemStack itemStack) {
        return super.func_77667_c(itemStack) + "." + this.getUpgrade(itemStack).getId();
    }

    public Upgrades.Upgrade getUpgrade(ItemStack itemStack) {
        return UPGRADES[Math.min(UPGRADES.length - 1, itemStack.func_77960_j())];
    }

    public boolean isTierUpgrade(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77960_j() <= 2;
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        return itemStack.func_77960_j() < 3 ? EnumRarity.rare : EnumRarity.uncommon;
    }

    static {
        MAIN_COLORS.put(WorkingTileEntity.UPGRADE_TIER1, RenderHelpers.RGBToInt(220, 220, 220));
        SECONDARY_COLORS.put(WorkingTileEntity.UPGRADE_TIER1, RenderHelpers.RGBToInt(255, 255, 255));
        MAIN_COLORS.put(WorkingTileEntity.UPGRADE_TIER2, RenderHelpers.RGBToInt(234, 238, 87));
        SECONDARY_COLORS.put(WorkingTileEntity.UPGRADE_TIER2, RenderHelpers.RGBToInt(230, 230, 160));
        MAIN_COLORS.put(WorkingTileEntity.UPGRADE_TIER3, RenderHelpers.RGBToInt(51, 235, 203));
        SECONDARY_COLORS.put(WorkingTileEntity.UPGRADE_TIER3, RenderHelpers.RGBToInt(150, 250, 200));
        MAIN_COLORS.put(WorkingTileEntity.UPGRADE_SPEED, RenderHelpers.RGBToInt(200, 90, 80));
        SECONDARY_COLORS.put(WorkingTileEntity.UPGRADE_SPEED, RenderHelpers.RGBToInt(240, 120, 110));
        MAIN_COLORS.put(WorkingTileEntity.UPGRADE_EFFICIENCY, RenderHelpers.RGBToInt(80, 70, 200));
        SECONDARY_COLORS.put(WorkingTileEntity.UPGRADE_EFFICIENCY, RenderHelpers.RGBToInt(120, 120, 210));
    }
}

