/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.core.config.configurable.ConfigurableItem;
import evilcraft.core.config.extendedconfig.ExtendedConfig;
import evilcraft.core.config.extendedconfig.ItemConfig;
import evilcraft.core.helper.L10NHelpers;
import java.util.List;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class ResurgenceEgg
extends ConfigurableItem {
    private static final String NBTKEY_ENTITY = "innerEntity";
    private static ResurgenceEgg _instance = null;

    public static void initInstance(ExtendedConfig<ItemConfig> eConfig) {
        if (_instance == null) {
            _instance = new ResurgenceEgg(eConfig);
        } else {
            eConfig.showDoubleInitError();
        }
    }

    public static ResurgenceEgg getInstance() {
        return _instance;
    }

    private ResurgenceEgg(ExtendedConfig<ItemConfig> eConfig) {
        super(eConfig);
        this.func_77625_d(1);
    }

    public boolean hasEffect(ItemStack itemStack, int pass) {
        return !this.isEmpty(itemStack);
    }

    public String getEntityString(ItemStack itemStack) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag != null) {
            return tag.func_74779_i(NBTKEY_ENTITY);
        }
        return null;
    }

    public boolean isEmpty(ItemStack itemStack) {
        return this.getEntityString(itemStack) == null;
    }

    public void setEntity(ItemStack itemStack, String entityString) {
        NBTTagCompound tag = itemStack.func_77942_o() ? itemStack.func_77978_p() : new NBTTagCompound();
        tag.func_74778_a(NBTKEY_ENTITY, entityString);
        itemStack.func_77982_d(tag);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, entityPlayer, list, par4);
        String content = EnumChatFormatting.ITALIC + L10NHelpers.localize("general.info.empty");
        String id = this.getEntityString(itemStack);
        if (id != null) {
            content = L10NHelpers.getLocalizedEntityName(id);
        }
        list.add(EnumChatFormatting.BOLD + L10NHelpers.localize(this.func_77658_a() + ".info.content", EnumChatFormatting.RESET + content));
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return itemStack;
        }
        MovingObjectPosition movingobjectposition = this.func_77621_a(world, player, true);
        if (movingobjectposition == null) {
            return itemStack;
        }
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            Entity entity;
            int x = movingobjectposition.field_72311_b;
            int y = movingobjectposition.field_72312_c;
            int z = movingobjectposition.field_72309_d;
            if (!world.func_72962_a(player, x, y, z) || !player.func_82247_a(x, y, z, movingobjectposition.field_72310_e, itemStack)) {
                return itemStack;
            }
            if (world.func_147439_a(x, y, z) instanceof BlockLiquid && (entity = ResurgenceEgg.spawnCreature(world, this.getEntityString(itemStack), x, y, z)) != null) {
                if (entity instanceof EntityLivingBase && itemStack.func_82837_s()) {
                    ((EntityLiving)entity).func_94058_c(itemStack.func_82833_r());
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    --itemStack.field_77994_a;
                }
            }
        }
        return itemStack;
    }

    public static Entity spawnCreature(World world, String entityString, double x, double y, double z) {
        Entity entity = EntityList.func_75620_a((String)entityString, (World)world);
        if (entity != null && entity instanceof EntityLivingBase) {
            EntityLiving entityliving = (EntityLiving)entity;
            entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            entityliving.field_70759_as = entityliving.field_70177_z;
            entityliving.field_70761_aq = entityliving.field_70177_z;
            entityliving.func_110161_a((IEntityLivingData)null);
            world.func_72838_d(entity);
            entityliving.func_70642_aH();
        }
        return entity;
    }
}

