/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.modcompat;

import com.google.common.collect.Sets;
import cpw.mods.fml.common.Loader;
import evilcraft.EvilCraft;
import evilcraft.GeneralConfig;
import evilcraft.IInitListener;
import evilcraft.core.config.ConfigHandler;
import evilcraft.modcompat.IModCompat;
import evilcraft.modcompat.baubles.BaublesModCompat;
import evilcraft.modcompat.bloodmagic.BloodMagicModCompat;
import evilcraft.modcompat.ee3.EE3ModCompat;
import evilcraft.modcompat.fmp.ForgeMultipartModCompat;
import evilcraft.modcompat.forestry.ForestryModCompat;
import evilcraft.modcompat.ic2.IC2ModCompat;
import evilcraft.modcompat.nei.NEIModCompat;
import evilcraft.modcompat.tconstruct.TConstructModCompat;
import evilcraft.modcompat.thaumcraft.ThaumcraftModCompat;
import evilcraft.modcompat.thermalexpansion.ThermalExpansionModCompat;
import evilcraft.modcompat.versionchecker.VersionCheckerModCompat;
import evilcraft.modcompat.waila.WailaModCompat;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Level;

public class ModCompatLoader
implements IInitListener {
    public static List<IModCompat> MODCOMPATS = new LinkedList<IModCompat>();
    protected static Set<String> CRASHED_MODCOMPATS;

    @Override
    public void onInit(IInitListener.Step step) {
        for (IModCompat modCompat : MODCOMPATS) {
            if (!ModCompatLoader.shouldLoadModCompat(modCompat)) continue;
            try {
                modCompat.onInit(step);
            }
            catch (RuntimeException e) {
                EvilCraft.log("The EvilCraft mod compatibility for " + modCompat.getModID() + " has crashed! Report this crash log to the mod author or try updating the conflicting mods.", Level.ERROR);
                if (GeneralConfig.crashOnModCompatCrash) {
                    throw e;
                }
                e.printStackTrace();
                CRASHED_MODCOMPATS.add(modCompat.getModID());
            }
        }
    }

    public static final boolean shouldLoadModCompat(IModCompat modCompat) {
        return ModCompatLoader.isModLoaded(modCompat) && ModCompatLoader.isModEnabled(modCompat) && ModCompatLoader.isModNotCrashed(modCompat);
    }

    private static boolean isModLoaded(IModCompat modCompat) {
        return Loader.isModLoaded((String)modCompat.getModID());
    }

    private static boolean isModEnabled(IModCompat modCompat) {
        Configuration config = ConfigHandler.getInstance().getConfig();
        Property property = config.get("mod compat", modCompat.getModID(), modCompat.isEnabled());
        property.setRequiresMcRestart(true);
        property.comment = modCompat.getComment();
        boolean enabled = property.getBoolean(true);
        if (config.hasChanged()) {
            config.save();
        }
        return enabled;
    }

    private static boolean isModNotCrashed(IModCompat modCompat) {
        return !CRASHED_MODCOMPATS.contains(modCompat.getModID());
    }

    static {
        MODCOMPATS.add(new ForestryModCompat());
        MODCOMPATS.add(new ThermalExpansionModCompat());
        MODCOMPATS.add(new TConstructModCompat());
        MODCOMPATS.add(new WailaModCompat());
        MODCOMPATS.add(new ForgeMultipartModCompat());
        MODCOMPATS.add(new BaublesModCompat());
        MODCOMPATS.add(new NEIModCompat());
        MODCOMPATS.add(new VersionCheckerModCompat());
        MODCOMPATS.add(new BloodMagicModCompat());
        MODCOMPATS.add(new ThaumcraftModCompat());
        MODCOMPATS.add(new EE3ModCompat());
        MODCOMPATS.add(new IC2ModCompat());
        CRASHED_MODCOMPATS = Sets.newHashSet();
    }
}

