/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.modcompat.ee3;

import com.google.common.collect.Lists;
import com.pahimar.ee3.api.exchange.EnergyValueRegistryProxy;
import com.pahimar.ee3.api.exchange.RecipeRegistryProxy;
import evilcraft.Configs;
import evilcraft.api.recipes.custom.IRecipe;
import evilcraft.api.recipes.custom.IRecipeInput;
import evilcraft.api.recipes.custom.IRecipeProperties;
import evilcraft.block.BloodInfuser;
import evilcraft.block.BloodInfuserConfig;
import evilcraft.block.DarkOreConfig;
import evilcraft.block.EnvironmentalAccumulator;
import evilcraft.block.EnvironmentalAccumulatorConfig;
import evilcraft.block.EternalWaterBlockConfig;
import evilcraft.block.HardenedBloodConfig;
import evilcraft.block.ObscuredGlassConfig;
import evilcraft.block.UndeadLeavesConfig;
import evilcraft.core.config.extendedconfig.BlockConfig;
import evilcraft.core.config.extendedconfig.ItemConfig;
import evilcraft.core.recipe.custom.EnvironmentalAccumulatorRecipeComponent;
import evilcraft.core.recipe.custom.ItemFluidStackAndTierRecipeComponent;
import evilcraft.core.recipe.custom.ItemStackRecipeComponent;
import evilcraft.fluid.Blood;
import evilcraft.fluid.Poison;
import evilcraft.item.BloodOrbConfig;
import evilcraft.item.BucketEternalWaterConfig;
import evilcraft.item.DarkGemConfig;
import evilcraft.item.DarkGemCrushedConfig;
import evilcraft.item.DarkStickConfig;
import evilcraft.item.EnderTearConfig;
import evilcraft.item.EnvironmentalAccumulationCoreConfig;
import evilcraft.item.GarmonboziaConfig;
import evilcraft.item.HardenedBloodShardConfig;
import evilcraft.item.OriginsOfDarknessConfig;
import evilcraft.item.PoisonSacConfig;
import evilcraft.item.WeatherContainerConfig;
import evilcraft.item.WerewolfFleshConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;

public class EE3 {
    public static void registerItems() {
        EE3.registerObjectSafe(DarkGemConfig._instance, 4096.0f);
        EE3.registerObjectSafe(DarkOreConfig._instance, 5120.0f);
        EE3.registerObjectSafe(DarkGemCrushedConfig._instance, 1024.0f);
        EE3.registerObjectSafe(HardenedBloodConfig._instance, 1280.0f);
        EE3.registerObjectSafe(HardenedBloodShardConfig._instance, 75.0f);
        EE3.registerObjectSafe(PoisonSacConfig._instance, 200.0f);
        EE3.registerObjectSafe(WerewolfFleshConfig._instance, Short.MAX_VALUE, 48.0f);
        EE3.registerObjectSafe(EnderTearConfig._instance, 4096.0f);
        EE3.registerObjectSafe(UndeadLeavesConfig._instance, 1.0f);
        EE3.registerObjectSafe(DarkStickConfig._instance, 1028.0f);
        EE3.registerObjectSafe(ObscuredGlassConfig._instance, 513.0f);
        EE3.registerObjectSafe(BloodOrbConfig._instance, 260.0f);
        EE3.registerObjectSafe(BucketEternalWaterConfig._instance, 4204.25f);
        EE3.registerObjectSafe(EternalWaterBlockConfig._instance, 10348.906f);
        EE3.registerObjectSafe(WeatherContainerConfig._instance, 3, 7500.0f);
        EE3.registerObjectSafe(WeatherContainerConfig._instance, 2, 4529.0f);
        EE3.registerObjectSafe(GarmonboziaConfig._instance, 50000.0f);
        EE3.registerObjectSafe(EnvironmentalAccumulationCoreConfig._instance, 10000.0f);
        EE3.registerObjectSafe(OriginsOfDarknessConfig._instance, 2000.0f);
        EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)Blood.getInstance(), (float)72.0f);
        EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)Poison.getInstance(), (float)64.0f);
    }

    public static void registerCrafting() {
        if (Configs.isEnabled(BloodInfuserConfig.class)) {
            for (IRecipe<IRecipeInput, IRecipeInput, IRecipeProperties> iRecipe : BloodInfuser.getInstance().getRecipeRegistry().allRecipes()) {
                ArrayList l = Lists.newArrayList(((ItemFluidStackAndTierRecipeComponent)iRecipe.getInput()).getItemStacks());
                l.add(((ItemFluidStackAndTierRecipeComponent)iRecipe.getInput()).getFluidStack());
                RecipeRegistryProxy.addRecipe((Object)((ItemStackRecipeComponent)iRecipe.getOutput()).getItemStack(), (List)l);
            }
        }
        if (Configs.isEnabled(EnvironmentalAccumulatorConfig.class)) {
            for (IRecipe<IRecipeInput, IRecipeInput, IRecipeProperties> iRecipe : EnvironmentalAccumulator.getInstance().getRecipeRegistry().allRecipes()) {
                RecipeRegistryProxy.addRecipe((Object)((EnvironmentalAccumulatorRecipeComponent)iRecipe.getOutput()).getItemStack(), Arrays.asList(((EnvironmentalAccumulatorRecipeComponent)iRecipe.getInput()).getItemStack()));
            }
        }
    }

    private static void registerObjectSafe(ItemConfig itemConfig, float energyValue) {
        EE3.registerObjectSafe(itemConfig, 0, energyValue);
    }

    private static void registerObjectSafe(BlockConfig itemConfig, float energyValue) {
        EE3.registerObjectSafe(itemConfig, 0, energyValue);
    }

    private static void registerObjectSafe(ItemConfig itemConfig, int meta, float energyValue) {
        if (itemConfig != null) {
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack(itemConfig.getItemInstance(), 1, meta), (float)energyValue);
        }
    }

    private static void registerObjectSafe(BlockConfig itemConfig, int meta, float energyValue) {
        if (itemConfig != null) {
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)new ItemStack(itemConfig.getBlockInstance(), 1, meta), (float)energyValue);
        }
    }
}

