/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.modcompat.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.ItemList;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.google.common.collect.Lists;
import evilcraft.api.recipes.custom.IRecipe;
import evilcraft.block.BloodInfuser;
import evilcraft.block.BloodInfuserConfig;
import evilcraft.client.gui.container.GuiBloodInfuser;
import evilcraft.core.fluid.BloodFluidConverter;
import evilcraft.core.recipe.custom.DurationXpRecipeProperties;
import evilcraft.core.recipe.custom.ItemFluidStackAndTierRecipeComponent;
import evilcraft.core.recipe.custom.ItemStackRecipeComponent;
import evilcraft.fluid.Blood;
import evilcraft.item.Promise;
import evilcraft.tileentity.TileBloodInfuser;
import evilcraft.tileentity.TileWorking;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.lwjgl.opengl.GL11;

public class NEIBloodInfuserManager
extends TemplateRecipeHandler {
    protected static int xOffset = -5;
    protected static int yOffset = -16;
    private final int width = 176;
    private final int height = 166;
    private final int tankWidth = 16;
    private final int tankHeight = 58;
    private final int tankTargetX = 43 + xOffset;
    private final int tankTargetY = 72 + yOffset;
    private final int tankX = 176;
    private final int tankY = 0;
    private final int progressTargetX = 102 + xOffset;
    private final int progressTargetY = 36 + yOffset;
    private final int progressX = 192;
    private final int progressY = 0;
    private final int progressWidth = 24;
    private final int progressHeight = 16;
    private static final int FLUID_CONTAINER_X = 8;
    private static final int FLUID_CONTAINER_Y = 36;
    private float zLevel = 200.0f;
    public static ArrayList<FluidPair> afluids;

    public NEIBloodInfuserManager() {
        LinkedList<TemplateRecipeHandler.RecipeTransferRect> guiTransferRects = new LinkedList<TemplateRecipeHandler.RecipeTransferRect>();
        guiTransferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(124, 26, 24, 16), this.getBIOverlayIdentifier(), new Object[0]));
        LinkedList<Class<? extends GuiContainer>> list = new LinkedList<Class<? extends GuiContainer>>();
        list.add(this.getGuiClass());
        TemplateRecipeHandler.RecipeTransferRectHandler.registerRectsToGuis(list, guiTransferRects);
    }

    public TemplateRecipeHandler newInstance() {
        if (afluids == null || afluids.isEmpty()) {
            NEIBloodInfuserManager.findFluids();
        }
        return super.newInstance();
    }

    private static void findFluids() {
        afluids = new ArrayList();
        for (FluidContainerRegistry.FluidContainerData fluidContainerData : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (!BloodFluidConverter.getInstance().canConvert(fluidContainerData.fluid.getFluid())) continue;
            afluids.add(new FluidPair(fluidContainerData.filledContainer.func_77946_l(), fluidContainerData.fluid));
        }
        for (ItemStack item : ItemList.items) {
            if (!(item.func_77973_b() instanceof IFluidContainerItem)) continue;
            IFluidContainerItem containerItem = (IFluidContainerItem)item.func_77973_b();
            try {
                FluidStack fluidStack = containerItem.getFluid(item);
                if (fluidStack == null || !BloodFluidConverter.getInstance().canConvert(fluidStack.getFluid())) continue;
                afluids.add(new FluidPair(item.func_77946_l(), fluidStack));
            }
            catch (Exception exception) {}
        }
    }

    public void loadTransferRects() {
        this.transferRects.clear();
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(97, 21, 24, 16), this.getBIOverlayIdentifier(), new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(38, -1, 16, 58), this.getFluidOverlayIdentifier(), new Object[]{new FluidStack((Fluid)Blood.getInstance(), 1000)}));
    }

    public List<Class<? extends GuiContainer>> getRecipeTransferRectGuis() {
        return null;
    }

    private String getBIOverlayIdentifier() {
        return BloodInfuserConfig._instance.getNamedId();
    }

    protected String getFluidOverlayIdentifier() {
        return "liquid";
    }

    public String getOverlayIdentifier() {
        return this.getBIOverlayIdentifier();
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiBloodInfuser.class;
    }

    public String getRecipeName() {
        return BloodInfuser.getInstance().func_149732_F();
    }

    private List<CachedBloodInfuserRecipe> getRecipes() {
        LinkedList<CachedBloodInfuserRecipe> recipes = new LinkedList<CachedBloodInfuserRecipe>();
        for (IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> recipe : BloodInfuser.getInstance().getRecipeRegistry().allRecipes()) {
            recipes.add(new CachedBloodInfuserRecipe(recipe));
        }
        return recipes;
    }

    public int recipiesPerPage() {
        return 2;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getBIOverlayIdentifier())) {
            for (CachedBloodInfuserRecipe recipe : this.getRecipes()) {
                this.arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        List<IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties>> recipes = BloodInfuser.getInstance().getRecipeRegistry().findRecipesByOutput(new ItemStackRecipeComponent(result));
        for (IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> recipe : recipes) {
            this.arecipes.add(new CachedBloodInfuserRecipe(recipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (TileBloodInfuser.ACCEPTED_FLUID != null) {
            try {
                IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> recipe = BloodInfuser.getInstance().getRecipeRegistry().findRecipeByInput(new ItemFluidStackAndTierRecipeComponent(ingredient, new FluidStack(TileBloodInfuser.ACCEPTED_FLUID, 10000), -1));
                if (recipe != null) {
                    this.arecipes.add(new CachedBloodInfuserRecipe(recipe));
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public String getGuiTexture() {
        return "evilcraft:" + BloodInfuser.getInstance().getGuiTexture("_nei");
    }

    protected CachedBloodInfuserRecipe getRecipe(int recipe) {
        return (CachedBloodInfuserRecipe)((Object)this.arecipes.get(recipe));
    }

    public void drawExtras(int recipe) {
        CachedBloodInfuserRecipe bloodInfuserRecipe = this.getRecipe(recipe);
        this.drawProgressBar(this.progressTargetX, this.progressTargetY, 192, 0, 24, 16, Math.max(2, bloodInfuserRecipe.duration / 10), 0);
    }

    protected boolean isFirstOnPage(int recipe) {
        return recipe % this.recipiesPerPage() == 0;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        if (this.isFirstOnPage(recipe)) {
            GuiDraw.drawTexturedModalRect((int)xOffset, (int)yOffset, (int)0, (int)0, (int)176, (int)166);
        } else {
            GuiDraw.drawTexturedModalRect((int)0, (int)-3, (int)(-xOffset), (int)(-yOffset - 3), (int)160, (int)60);
        }
    }

    public void drawForeground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        this.drawExtras(recipe);
        CachedBloodInfuserRecipe bloodInfuserRecipe = this.getRecipe(recipe);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int tankSize = ((CachedBloodInfuserRecipe)bloodInfuserRecipe).fluidStack.amount * 58 / this.getMaxTankSize(bloodInfuserRecipe);
        this.drawTank(this.tankTargetX, this.tankTargetY, TileBloodInfuser.ACCEPTED_FLUID.getID(), tankSize);
        GL11.glDisable((int)3042);
    }

    protected int getMaxTankSize(CachedBloodInfuserRecipe bloodInfuserRecipe) {
        return 10000 * TileWorking.getTankTierMultiplier(bloodInfuserRecipe.tier);
    }

    protected void drawTank(int xOffset, int yOffset, int fluidID, int level) {
        Minecraft mc = Minecraft.func_71410_x();
        FluidStack stack = new FluidStack(fluidID, 1);
        if (fluidID > 0) {
            IIcon icon = stack.getFluid().getIcon();
            if (icon == null) {
                icon = Blocks.field_150355_j.func_149691_a(0, 0);
            }
            int verticalOffset = 0;
            while (level > 0) {
                int textureHeight;
                if (level > 16) {
                    textureHeight = 16;
                    level -= 16;
                } else {
                    textureHeight = level;
                    level = 0;
                }
                mc.field_71446_o.func_110577_a(mc.field_71446_o.func_130087_a(0));
                this.drawTexturedModelRectFromIcon(xOffset, yOffset - textureHeight - verticalOffset, icon, 16, textureHeight);
                verticalOffset += 16;
            }
            GuiDraw.changeTexture((String)this.getGuiTexture());
            GuiDraw.drawTexturedModalRect((int)xOffset, (int)(yOffset - 58), (int)176, (int)0, (int)16, (int)58);
        }
    }

    private void drawTexturedModelRectFromIcon(int x, int y, IIcon icon, int width, int height) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + height), (double)this.zLevel, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)this.zLevel, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        tessellator.func_78374_a((double)(x + width), (double)(y + 0), (double)this.zLevel, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)this.zLevel, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        tessellator.func_78381_a();
    }

    public List<String> handleTooltip(GuiRecipe guiRecipe, List<String> currenttip, int recipe) {
        super.handleTooltip(guiRecipe, currenttip, recipe);
        CachedBloodInfuserRecipe bloodInfuserRecipe = this.getRecipe(recipe);
        FluidStack fluid = bloodInfuserRecipe.fluidStack;
        if (fluid != null) {
            Point mouse = GuiDraw.getMousePosition();
            Point offset = guiRecipe.getRecipePosition(recipe);
            Point mouseRelative = new Point(mouse.x - (guiRecipe.field_146294_l - 176) / 2 - offset.x, mouse.y - (guiRecipe.field_146295_m - 166) / 2 - offset.y);
            if (bloodInfuserRecipe.tank.contains(mouseRelative)) {
                currenttip.add(fluid.getLocalizedName());
                currenttip.add(fluid.amount + " / " + this.getMaxTankSize(bloodInfuserRecipe) + " mB");
            }
        }
        return currenttip;
    }

    public static class FluidPair {
        public PositionedStack stack;
        public FluidStack fluidStack;

        public FluidPair(ItemStack itemStack, FluidStack fluidStack) {
            this.stack = new PositionedStack((Object)itemStack, 8 + xOffset, 36 + yOffset, false);
            this.fluidStack = fluidStack;
        }
    }

    protected class CachedBloodInfuserRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private int hashcode;
        private List<PositionedStack> input;
        private PositionedStack output;
        private PositionedStack upgrade;
        private FluidStack fluidStack;
        private Rectangle tank;
        private int duration;
        private int tier;

        public CachedBloodInfuserRecipe(IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> recipe) {
            this(recipe.getInput().getItemStacks(), recipe.getOutput().getItemStack(), recipe.getInput().getFluidStack(), recipe.getProperties().getDuration(), recipe.getInput().getTier());
        }

        public CachedBloodInfuserRecipe(List<ItemStack> inputStacks, ItemStack outputStack, FluidStack fluidStack, int duration, int tier) {
            super((TemplateRecipeHandler)NEIBloodInfuserManager.this);
            this.upgrade = null;
            this.input = Lists.newArrayListWithCapacity((int)inputStacks.size());
            for (ItemStack itemStack : inputStacks) {
                this.input.add(new PositionedStack(inputStacks, 79 + xOffset, 36 + yOffset));
            }
            this.output = new PositionedStack((Object)outputStack, 133 + xOffset, 36 + yOffset);
            this.tier = tier;
            if (tier > 0) {
                this.upgrade = new PositionedStack((Object)new ItemStack((Item)Promise.getInstance(), 1, tier - 1), 3, 0);
            }
            this.fluidStack = fluidStack;
            if (this.fluidStack != null) {
                this.tank = new Rectangle(NEIBloodInfuserManager.this.tankTargetX, -1, 16, 58);
            }
            this.duration = duration;
            this.calculateHashcode();
        }

        private void calculateHashcode() {
            this.hashcode = this.input.hashCode() << 16 + this.output.item.func_77960_j();
            this.hashcode = 31 * this.hashcode + (this.input.hashCode() << 16 + this.output.item.hashCode());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CachedBloodInfuserRecipe)) {
                return false;
            }
            CachedBloodInfuserRecipe recipe2 = (CachedBloodInfuserRecipe)((Object)obj);
            if (this.input.size() != recipe2.input.size()) {
                return false;
            }
            for (int i = 0; i < this.input.size(); ++i) {
                if (NEIServerUtils.areStacksSameType((ItemStack)this.input.get((int)i).item, (ItemStack)recipe2.input.get((int)i).item)) continue;
                return false;
            }
            return this.output.item.func_77960_j() == recipe2.output.item.func_77960_j();
        }

        public int hashCode() {
            return this.hashcode;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public PositionedStack getIngredient() {
            return this.input.get(0);
        }

        public PositionedStack getOtherStack() {
            return NEIBloodInfuserManager.afluids.get((int)(NEIBloodInfuserManager.this.cycleticks / 24 % NEIBloodInfuserManager.afluids.size())).stack;
        }

        public List<PositionedStack> getIngredients() {
            List ingredients = this.getCycledIngredients(NEIBloodInfuserManager.this.cycleticks / 32, this.input);
            if (this.upgrade != null) {
                ingredients.add(this.upgrade);
            }
            return ingredients;
        }
    }
}

