/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.modcompat.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import evilcraft.api.recipes.custom.IRecipe;
import evilcraft.block.EnvironmentalAccumulator;
import evilcraft.block.EnvironmentalAccumulatorConfig;
import evilcraft.core.helper.ItemHelpers;
import evilcraft.core.recipe.custom.EnvironmentalAccumulatorRecipeComponent;
import evilcraft.core.recipe.custom.EnvironmentalAccumulatorRecipeProperties;
import evilcraft.core.weather.WeatherType;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class NEIEnvironmentalAccumulatorManager
extends TemplateRecipeHandler {
    private static final String WEATHER_ICONS = "evilcraft:textures/gui/weathers.png";
    private static final Map<WeatherType, Integer> X_ICON_OFFSETS = new HashMap<WeatherType, Integer>();
    private final int progressTargetX = 77;
    private final int progressTargetY = 0;
    private final int progressX = 166;
    private final int progressY = 0;
    private final int progressWidth = 11;
    private final int progressHeight = 60;

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(77, 0, 11, 60), this.getOverlayIdentifier(), new Object[0]));
    }

    public String getOverlayIdentifier() {
        return EnvironmentalAccumulatorConfig._instance.getNamedId();
    }

    public String getRecipeName() {
        return EnvironmentalAccumulator.getInstance().func_149732_F();
    }

    public String getGuiTexture() {
        return "evilcraft:" + EnvironmentalAccumulator.getInstance().getGuiTexture("_nei");
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)166, (int)165);
    }

    private List<CachedEnvironmentalAccumulatorRecipe> getRecipes() {
        LinkedList<CachedEnvironmentalAccumulatorRecipe> recipes = new LinkedList<CachedEnvironmentalAccumulatorRecipe>();
        for (IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties> recipe : EnvironmentalAccumulator.getInstance().getRecipeRegistry().allRecipes()) {
            EnvironmentalAccumulatorRecipeComponent input = recipe.getInput();
            EnvironmentalAccumulatorRecipeComponent output = recipe.getOutput();
            EnvironmentalAccumulatorRecipeProperties props = recipe.getProperties();
            recipes.add(new CachedEnvironmentalAccumulatorRecipe(input, output, props));
        }
        return recipes;
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            for (CachedEnvironmentalAccumulatorRecipe recipe : this.getRecipes()) {
                this.arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties> recipe = EnvironmentalAccumulator.getInstance().getRecipeRegistry().findRecipeByOutput(new EnvironmentalAccumulatorRecipeComponent(result, WeatherType.ANY));
        if (recipe != null) {
            this.arecipes.add(new CachedEnvironmentalAccumulatorRecipe(recipe.getInput(), recipe.getOutput(), recipe.getProperties()));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties> recipe : EnvironmentalAccumulator.getInstance().getRecipeRegistry().findRecipesByInput(new EnvironmentalAccumulatorRecipeComponent(ingredient, WeatherType.ANY))) {
            this.arecipes.add(new CachedEnvironmentalAccumulatorRecipe(recipe.getInput(), recipe.getOutput(), recipe.getProperties()));
        }
    }

    private CachedEnvironmentalAccumulatorRecipe getRecipe(int recipe) {
        return (CachedEnvironmentalAccumulatorRecipe)((Object)this.arecipes.get(recipe));
    }

    public void drawExtras(int recipe) {
        Integer outputX;
        CachedEnvironmentalAccumulatorRecipe cachedRecipe = this.getRecipe(recipe);
        this.drawProgressBar(77, 0, 166, 0, 11, 60, Math.max(2, cachedRecipe.duration / 10), 3);
        Integer inputX = X_ICON_OFFSETS.get(cachedRecipe.inputWeather);
        if (inputX != null) {
            GuiDraw.changeTexture((String)WEATHER_ICONS);
            GuiDraw.drawTexturedModalRect((int)36, (int)28, (int)inputX, (int)0, (int)16, (int)16);
        }
        if ((outputX = X_ICON_OFFSETS.get(cachedRecipe.outputWeather)) != null) {
            GuiDraw.changeTexture((String)WEATHER_ICONS);
            GuiDraw.drawTexturedModalRect((int)114, (int)28, (int)outputX, (int)0, (int)16, (int)16);
        }
    }

    static {
        X_ICON_OFFSETS.put(WeatherType.CLEAR, 0);
        X_ICON_OFFSETS.put(WeatherType.RAIN, 16);
        X_ICON_OFFSETS.put(WeatherType.LIGHTNING, 32);
    }

    private class CachedEnvironmentalAccumulatorRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private PositionedStack inputStack;
        private WeatherType inputWeather;
        private PositionedStack outputStack;
        private WeatherType outputWeather;
        private int duration;

        public CachedEnvironmentalAccumulatorRecipe(EnvironmentalAccumulatorRecipeComponent input, EnvironmentalAccumulatorRecipeComponent output, EnvironmentalAccumulatorRecipeProperties properties) {
            this(input.getItemStack(), input.getWeatherType(), output.getItemStack(), output.getWeatherType(), properties.getDuration());
        }

        public CachedEnvironmentalAccumulatorRecipe(ItemStack inputStack, WeatherType inputWeather, ItemStack outputStack, WeatherType outputWeather, int duration) {
            super((TemplateRecipeHandler)NEIEnvironmentalAccumulatorManager.this);
            this.inputStack = new PositionedStack((Object)inputStack, 36, 48);
            this.outputStack = new PositionedStack(ItemHelpers.getVariants(outputStack), 114, 48);
            this.inputWeather = inputWeather;
            this.outputWeather = outputWeather;
            this.duration = duration;
        }

        public PositionedStack getIngredient() {
            return this.inputStack;
        }

        public PositionedStack getResult() {
            this.outputStack.setPermutationToRender(NEIEnvironmentalAccumulatorManager.this.cycleticks / 32 % this.outputStack.items.length);
            return this.outputStack;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + ((Object)((Object)this.getOuterType())).hashCode();
            result = 31 * result + this.duration;
            result = 31 * result + (this.inputStack == null ? 0 : this.inputStack.hashCode());
            result = 31 * result + (this.inputWeather == null ? 0 : this.inputWeather.hashCode());
            result = 31 * result + (this.outputStack == null ? 0 : this.outputStack.hashCode());
            result = 31 * result + (this.outputWeather == null ? 0 : this.outputWeather.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            CachedEnvironmentalAccumulatorRecipe other = (CachedEnvironmentalAccumulatorRecipe)((Object)obj);
            if (!((Object)((Object)this.getOuterType())).equals((Object)other.getOuterType())) {
                return false;
            }
            if (this.duration != other.duration) {
                return false;
            }
            if (this.inputStack == null ? other.inputStack != null : !this.inputStack.equals(other.inputStack)) {
                return false;
            }
            if (this.inputWeather == null ? other.inputWeather != null : !this.inputWeather.equals(other.inputWeather)) {
                return false;
            }
            if (this.outputStack == null ? other.outputStack != null : !this.outputStack.equals(other.outputStack)) {
                return false;
            }
            return !(this.outputWeather == null ? other.outputWeather != null : !this.outputWeather.equals(other.outputWeather));
        }

        private NEIEnvironmentalAccumulatorManager getOuterType() {
            return NEIEnvironmentalAccumulatorManager.this;
        }
    }
}

