/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.modcompat.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import evilcraft.api.recipes.custom.IRecipe;
import evilcraft.block.EnvironmentalAccumulator;
import evilcraft.block.SanguinaryEnvironmentalAccumulator;
import evilcraft.block.SanguinaryEnvironmentalAccumulatorConfig;
import evilcraft.client.gui.container.GuiSanguinaryEnvironmentalAccumulator;
import evilcraft.core.helper.ItemHelpers;
import evilcraft.core.recipe.custom.EnvironmentalAccumulatorRecipeComponent;
import evilcraft.core.recipe.custom.EnvironmentalAccumulatorRecipeProperties;
import evilcraft.core.weather.WeatherType;
import evilcraft.tileentity.TileBloodInfuser;
import evilcraft.tileentity.TileSanguinaryEnvironmentalAccumulator;
import evilcraft.tileentity.tickaction.sanguinaryenvironmentalaccumulator.AccumulateItemTickAction;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class NEISanguinaryEnvironmentalAccumulatorManager
extends TemplateRecipeHandler {
    private static final String WEATHER_ICONS = "evilcraft:textures/gui/weathers.png";
    private static final Map<WeatherType, Integer> X_ICON_OFFSETS = new HashMap<WeatherType, Integer>();
    protected static int xOffset;
    protected static int yOffset;
    private final int width = 176;
    private final int height = 166;
    private final int tankWidth = 16;
    private final int tankHeight = 58;
    private final int tankTargetX = 8 + xOffset;
    private final int tankTargetY = 72 + yOffset;
    private final int tankX = 176;
    private final int tankY = 0;
    private final int progressTargetX = 77 + xOffset;
    private final int progressTargetY = 36 + yOffset;
    private final int progressX = 192;
    private final int progressY = 0;
    private final int progressWidth = 24;
    private final int progressHeight = 16;
    private float zLevel = 200.0f;

    public NEISanguinaryEnvironmentalAccumulatorManager() {
        LinkedList<TemplateRecipeHandler.RecipeTransferRect> guiTransferRects = new LinkedList<TemplateRecipeHandler.RecipeTransferRect>();
        guiTransferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(99, 26, 24, 16), this.getSEAOverlayIdentifier(), new Object[0]));
        LinkedList<Class<? extends GuiContainer>> list = new LinkedList<Class<? extends GuiContainer>>();
        list.add(this.getGuiClass());
        TemplateRecipeHandler.RecipeTransferRectHandler.registerRectsToGuis(list, guiTransferRects);
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiSanguinaryEnvironmentalAccumulator.class;
    }

    public void loadTransferRects() {
        this.transferRects.clear();
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(72, 21, 24, 16), this.getSEAOverlayIdentifier(), new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(this.tankTargetX - 5, -73, 16, 58), this.getFluidOverlayIdentifier(), new Object[0]));
    }

    private String getSEAOverlayIdentifier() {
        return SanguinaryEnvironmentalAccumulatorConfig._instance.getNamedId();
    }

    protected String getFluidOverlayIdentifier() {
        return "liquid";
    }

    public List<Class<? extends GuiContainer>> getRecipeTransferRectGuis() {
        return null;
    }

    public String getOverlayIdentifier() {
        return this.getSEAOverlayIdentifier();
    }

    public String getRecipeName() {
        return SanguinaryEnvironmentalAccumulator.getInstance().func_149732_F();
    }

    public String getGuiTexture() {
        return "evilcraft:" + SanguinaryEnvironmentalAccumulator.getInstance().getGuiTexture("_nei");
    }

    private List<CachedEnvironmentalAccumulatorRecipe> getRecipes() {
        LinkedList<CachedEnvironmentalAccumulatorRecipe> recipes = new LinkedList<CachedEnvironmentalAccumulatorRecipe>();
        for (IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties> recipe : EnvironmentalAccumulator.getInstance().getRecipeRegistry().allRecipes()) {
            EnvironmentalAccumulatorRecipeComponent input = recipe.getInput();
            EnvironmentalAccumulatorRecipeComponent output = recipe.getOutput();
            EnvironmentalAccumulatorRecipeProperties props = recipe.getProperties();
            recipes.add(new CachedEnvironmentalAccumulatorRecipe(input, output, props));
        }
        return recipes;
    }

    public int recipiesPerPage() {
        return 2;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            for (CachedEnvironmentalAccumulatorRecipe recipe : this.getRecipes()) {
                this.arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties> recipe = EnvironmentalAccumulator.getInstance().getRecipeRegistry().findRecipeByOutput(new EnvironmentalAccumulatorRecipeComponent(result, WeatherType.ANY));
        if (recipe != null) {
            this.arecipes.add(new CachedEnvironmentalAccumulatorRecipe(recipe.getInput(), recipe.getOutput(), recipe.getProperties()));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties> recipe : EnvironmentalAccumulator.getInstance().getRecipeRegistry().findRecipesByInput(new EnvironmentalAccumulatorRecipeComponent(ingredient, WeatherType.ANY))) {
            this.arecipes.add(new CachedEnvironmentalAccumulatorRecipe(recipe.getInput(), recipe.getOutput(), recipe.getProperties()));
        }
    }

    private CachedEnvironmentalAccumulatorRecipe getRecipe(int recipe) {
        return (CachedEnvironmentalAccumulatorRecipe)((Object)this.arecipes.get(recipe));
    }

    public void drawExtras(int recipe) {
        CachedEnvironmentalAccumulatorRecipe eaRecipe = this.getRecipe(recipe);
        this.drawProgressBar(this.progressTargetX, this.progressTargetY, 192, 0, 24, 16, Math.max(2, eaRecipe.duration / 10), 0);
        Integer inputX = X_ICON_OFFSETS.get(eaRecipe.inputWeather);
        if (inputX != null) {
            GuiDraw.changeTexture((String)WEATHER_ICONS);
            GuiDraw.drawTexturedModalRect((int)(54 + xOffset), (int)(56 + yOffset), (int)inputX, (int)0, (int)16, (int)16);
        }
    }

    protected boolean isFirstOnPage(int recipe) {
        return recipe % this.recipiesPerPage() == 0;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        if (this.isFirstOnPage(recipe)) {
            GuiDraw.drawTexturedModalRect((int)xOffset, (int)yOffset, (int)0, (int)0, (int)176, (int)166);
        } else {
            GuiDraw.drawTexturedModalRect((int)0, (int)-3, (int)(-xOffset), (int)(-yOffset - 3), (int)160, (int)60);
        }
    }

    public void drawForeground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        this.drawExtras(recipe);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int tankSize = 58;
        this.drawTank(this.tankTargetX, this.tankTargetY, TileBloodInfuser.ACCEPTED_FLUID.getID(), tankSize);
        GL11.glDisable((int)3042);
    }

    protected void drawTank(int xOffset, int yOffset, int fluidID, int level) {
        Minecraft mc = Minecraft.func_71410_x();
        FluidStack stack = new FluidStack(fluidID, 1);
        if (fluidID > 0) {
            IIcon icon = stack.getFluid().getIcon();
            if (icon == null) {
                icon = Blocks.field_150355_j.func_149691_a(0, 0);
            }
            int verticalOffset = 0;
            while (level > 0) {
                int textureHeight;
                if (level > 16) {
                    textureHeight = 16;
                    level -= 16;
                } else {
                    textureHeight = level;
                    level = 0;
                }
                mc.field_71446_o.func_110577_a(mc.field_71446_o.func_130087_a(0));
                this.drawTexturedModelRectFromIcon(xOffset, yOffset - textureHeight - verticalOffset, icon, 16, textureHeight);
                verticalOffset += 16;
            }
            GuiDraw.changeTexture((String)this.getGuiTexture());
            GuiDraw.drawTexturedModalRect((int)xOffset, (int)(yOffset - 58), (int)176, (int)0, (int)16, (int)58);
        }
    }

    private void drawTexturedModelRectFromIcon(int x, int y, IIcon icon, int width, int height) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + height), (double)this.zLevel, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)this.zLevel, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        tessellator.func_78374_a((double)(x + width), (double)(y + 0), (double)this.zLevel, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)this.zLevel, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        tessellator.func_78381_a();
    }

    public List<String> handleTooltip(GuiRecipe guiRecipe, List<String> currenttip, int recipe) {
        super.handleTooltip(guiRecipe, currenttip, recipe);
        CachedEnvironmentalAccumulatorRecipe bloodInfuserRecipe = this.getRecipe(recipe);
        FluidStack fluid = bloodInfuserRecipe.fluidStack;
        if (fluid != null) {
            Point mouse = GuiDraw.getMousePosition();
            Point offset = guiRecipe.getRecipePosition(recipe);
            Point mouseRelative = new Point(mouse.x - (guiRecipe.field_146294_l - 176) / 2 - offset.x, mouse.y - (guiRecipe.field_146295_m - 166) / 2 - offset.y);
            if (bloodInfuserRecipe.tank.contains(mouseRelative)) {
                currenttip.add(fluid.getLocalizedName());
                currenttip.add(fluid.amount + " mB");
            }
        }
        return currenttip;
    }

    static {
        X_ICON_OFFSETS.put(WeatherType.CLEAR, 0);
        X_ICON_OFFSETS.put(WeatherType.RAIN, 16);
        X_ICON_OFFSETS.put(WeatherType.LIGHTNING, 32);
        xOffset = -5;
        yOffset = -16;
    }

    private class CachedEnvironmentalAccumulatorRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private PositionedStack inputStack;
        private WeatherType inputWeather;
        private PositionedStack outputStack;
        private int duration;
        private FluidStack fluidStack;
        private Rectangle tank;

        public CachedEnvironmentalAccumulatorRecipe(EnvironmentalAccumulatorRecipeComponent input, EnvironmentalAccumulatorRecipeComponent output, EnvironmentalAccumulatorRecipeProperties properties) {
            this(input.getItemStack(), input.getWeatherType(), output.getItemStack(), properties.getDuration(), new FluidStack(TileSanguinaryEnvironmentalAccumulator.ACCEPTED_FLUID, AccumulateItemTickAction.getUsage(properties)));
        }

        public CachedEnvironmentalAccumulatorRecipe(ItemStack inputStack, WeatherType inputWeather, ItemStack outputStack, int duration, FluidStack fluidStack) {
            super((TemplateRecipeHandler)NEISanguinaryEnvironmentalAccumulatorManager.this);
            this.inputStack = new PositionedStack((Object)inputStack, 54 + xOffset, 36 + yOffset);
            this.outputStack = new PositionedStack(ItemHelpers.getVariants(outputStack), 108 + xOffset, 36 + yOffset);
            this.inputWeather = inputWeather;
            this.duration = duration;
            this.fluidStack = fluidStack;
            if (this.fluidStack != null) {
                this.tank = new Rectangle(NEISanguinaryEnvironmentalAccumulatorManager.this.tankTargetX, -1, 16, 58);
            }
        }

        public PositionedStack getIngredient() {
            return this.inputStack;
        }

        public PositionedStack getResult() {
            this.outputStack.setPermutationToRender(NEISanguinaryEnvironmentalAccumulatorManager.this.cycleticks / 32 % this.outputStack.items.length);
            return this.outputStack;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + ((Object)((Object)this.getOuterType())).hashCode();
            result = 31 * result + this.duration;
            result = 31 * result + (this.inputStack == null ? 0 : this.inputStack.hashCode());
            result = 31 * result + (this.inputWeather == null ? 0 : this.inputWeather.hashCode());
            result = 31 * result + (this.outputStack == null ? 0 : this.outputStack.hashCode());
            result = 31 * result + (this.fluidStack == null ? 0 : this.fluidStack.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            CachedEnvironmentalAccumulatorRecipe other = (CachedEnvironmentalAccumulatorRecipe)((Object)obj);
            if (!((Object)((Object)this.getOuterType())).equals((Object)other.getOuterType())) {
                return false;
            }
            if (this.duration != other.duration) {
                return false;
            }
            if (this.inputStack == null ? other.inputStack != null : !this.inputStack.equals(other.inputStack)) {
                return false;
            }
            if (this.inputWeather == null ? other.inputWeather != null : !this.inputWeather.equals(other.inputWeather)) {
                return false;
            }
            if (this.outputStack == null ? other.outputStack != null : !this.outputStack.equals(other.outputStack)) {
                return false;
            }
            return !(this.fluidStack == null ? other.fluidStack != null : !this.fluidStack.equals((Object)other.fluidStack));
        }

        private NEISanguinaryEnvironmentalAccumulatorManager getOuterType() {
            return NEISanguinaryEnvironmentalAccumulatorManager.this;
        }
    }
}

