/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.modcompat.thaumcraft;

import evilcraft.Configs;
import evilcraft.block.BloodStainedBlockConfig;
import evilcraft.block.BloodyCobblestoneConfig;
import evilcraft.block.DarkBloodBrickConfig;
import evilcraft.block.DarkOreConfig;
import evilcraft.block.EnvironmentalAccumulatorConfig;
import evilcraft.block.FluidBlockBloodConfig;
import evilcraft.block.FluidBlockPoisonConfig;
import evilcraft.block.GemStoneTorchConfig;
import evilcraft.block.HardenedBloodConfig;
import evilcraft.block.ObscuredGlassConfig;
import evilcraft.block.SpiritPortalConfig;
import evilcraft.block.UndeadLeavesConfig;
import evilcraft.block.UndeadLogConfig;
import evilcraft.block.UndeadPlankConfig;
import evilcraft.block.UndeadSaplingConfig;
import evilcraft.core.config.extendedconfig.BlockConfig;
import evilcraft.core.config.extendedconfig.ItemConfig;
import evilcraft.core.config.extendedconfig.MobConfig;
import evilcraft.entity.monster.NetherfishConfig;
import evilcraft.entity.monster.PoisonousLibelleConfig;
import evilcraft.entity.monster.WerewolfConfig;
import evilcraft.item.BloodOrbConfig;
import evilcraft.item.BloodPotashConfig;
import evilcraft.item.BloodWaxedCoalConfig;
import evilcraft.item.BlookConfig;
import evilcraft.item.BroomConfig;
import evilcraft.item.BucketBloodConfig;
import evilcraft.item.BucketPoisonConfig;
import evilcraft.item.BurningGemStoneConfig;
import evilcraft.item.CorruptedTearConfig;
import evilcraft.item.DarkGem;
import evilcraft.item.DarkGemConfig;
import evilcraft.item.DarkGemCrushedConfig;
import evilcraft.item.DarkPowerGemConfig;
import evilcraft.item.DarkSpikeConfig;
import evilcraft.item.EnderTearConfig;
import evilcraft.item.GarmonboziaConfig;
import evilcraft.item.HardenedBloodShardConfig;
import evilcraft.item.InvertedPotentiaConfig;
import evilcraft.item.OriginsOfDarknessConfig;
import evilcraft.item.PoisonSacConfig;
import evilcraft.item.PotentiaSphereConfig;
import evilcraft.item.PromiseAcceptorConfig;
import evilcraft.item.WeatherContainer;
import evilcraft.item.WeatherContainerConfig;
import evilcraft.item.WerewolfBoneConfig;
import evilcraft.item.WerewolfFleshConfig;
import evilcraft.item.WerewolfFurConfig;
import evilcraft.modcompat.thaumcraft.BloodWandCapConfig;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.WandCap;

public class Thaumcraft {
    public static void register() {
        Thaumcraft.registerAspects();
        if (Configs.isEnabled(BloodWandCapConfig.class)) {
            WandCap bloodWandCap = new WandCap("blood", 0.95f, new ItemStack(BloodWandCapConfig._instance.getItemInstance()), 3){

                public String getResearch() {
                    return "CAP_gold";
                }
            };
            bloodWandCap.setTexture(new ResourceLocation("evilcraft", "textures/models/wand_cap_blood.png"));
        }
        if (Configs.isEnabled(DarkGemConfig.class)) {
            ThaumcraftApi.addLootBagItem((ItemStack)new ItemStack((Item)DarkGem.getInstance()), (int)100, (int[])new int[]{0, 1, 2});
            ThaumcraftApi.addLootBagItem((ItemStack)new ItemStack((Item)DarkGem.getInstance(), 2), (int)80, (int[])new int[]{0, 1, 2});
            ThaumcraftApi.addLootBagItem((ItemStack)new ItemStack((Item)DarkGem.getInstance(), 5), (int)40, (int[])new int[]{0, 1, 2});
        }
        if (Configs.isEnabled(DarkGemCrushedConfig.class)) {
            ThaumcraftApi.addLootBagItem((ItemStack)new ItemStack(DarkGemCrushedConfig._instance.getItemInstance()), (int)80, (int[])new int[]{0, 1, 2});
            ThaumcraftApi.addLootBagItem((ItemStack)new ItemStack(DarkGemCrushedConfig._instance.getItemInstance(), 2), (int)60, (int[])new int[]{0, 1, 2});
            ThaumcraftApi.addLootBagItem((ItemStack)new ItemStack(DarkGemCrushedConfig._instance.getItemInstance(), 5), (int)20, (int[])new int[]{0, 1, 2});
        }
        if (Configs.isEnabled(GarmonboziaConfig.class)) {
            ThaumcraftApi.addLootBagItem((ItemStack)new ItemStack(GarmonboziaConfig._instance.getItemInstance()), (int)5, (int[])new int[]{1, 2});
            ThaumcraftApi.addLootBagItem((ItemStack)new ItemStack(GarmonboziaConfig._instance.getItemInstance(), 2), (int)3, (int[])new int[]{1, 2});
            ThaumcraftApi.addLootBagItem((ItemStack)new ItemStack(GarmonboziaConfig._instance.getItemInstance(), 3), (int)1, (int[])new int[]{1, 2});
        }
    }

    private static void registerAspects() {
        Thaumcraft.registerEntityTagSafe(NetherfishConfig._instance, new AspectList().add(Aspect.FIRE, 4).add(Aspect.BEAST, 1).add(Aspect.EARTH, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        Thaumcraft.registerEntityTagSafe(PoisonousLibelleConfig._instance, new AspectList().add(Aspect.POISON, 4).add(Aspect.BEAST, 1).add(Aspect.AIR, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        Thaumcraft.registerEntityTagSafe(WerewolfConfig._instance, new AspectList().add(Aspect.HUNGER, 4).add(Aspect.BEAST, 4), new ThaumcraftApi.EntityTagsNBT[0]);
        AspectList bloodLists = new AspectList().add(Aspect.ENERGY, 2).add(Aspect.LIFE, 4);
        Thaumcraft.registerObjectTagSafe(FluidBlockBloodConfig._instance, bloodLists.copy());
        Thaumcraft.registerObjectTagSafe(HardenedBloodConfig._instance, bloodLists.copy());
        Thaumcraft.registerObjectTagSafe(BucketBloodConfig._instance, bloodLists.copy().add(Aspect.METAL, 3));
        Thaumcraft.registerObjectTagSafe(HardenedBloodShardConfig._instance, new AspectList().add(Aspect.LIFE, 1));
        Thaumcraft.registerObjectTagSafe(BloodStainedBlockConfig._instance, bloodLists.copy());
        Thaumcraft.registerObjectTagSafe(BloodyCobblestoneConfig._instance, bloodLists.copy().add(Aspect.EARTH, 1).add(Aspect.ENTROPY, 1));
        ThaumcraftApi.registerObjectTag((String)"gemDark", (AspectList)new AspectList().add(Aspect.CRYSTAL, 2).add(Aspect.DARKNESS, 4));
        Thaumcraft.registerObjectTagSafe(DarkOreConfig._instance, new AspectList().add(Aspect.CRYSTAL, 2).add(Aspect.DARKNESS, 2).add(Aspect.EARTH, 1));
        Thaumcraft.registerObjectTagSafe(DarkGemCrushedConfig._instance, new AspectList().add(Aspect.SOUL, 2).add(Aspect.DARKNESS, 2).add(Aspect.EARTH, 1));
        Thaumcraft.registerObjectTagSafe(DarkPowerGemConfig._instance, new AspectList().add(Aspect.CRYSTAL, 2).add(Aspect.DARKNESS, 4).add(bloodLists.copy()).add(Aspect.MAGIC, 2));
        Thaumcraft.registerObjectTagSafe(FluidBlockPoisonConfig._instance, new AspectList().add(Aspect.POISON, 4));
        Thaumcraft.registerObjectTagSafe(BucketPoisonConfig._instance, new AspectList().add(Aspect.POISON, 4).add(Aspect.METAL, 3));
        Thaumcraft.registerObjectTagSafe(PoisonSacConfig._instance, new AspectList().add(Aspect.POISON, 4).add(Aspect.FLESH, 2));
        Thaumcraft.registerObjectTagSafe(UndeadSaplingConfig._instance, new AspectList().add(Aspect.TREE, 1).add(Aspect.PLANT, 2).add(Aspect.UNDEAD, 2));
        Thaumcraft.registerObjectTagSafe(UndeadPlankConfig._instance, new AspectList().add(Aspect.TREE, 1).add(Aspect.UNDEAD, 1));
        Thaumcraft.registerObjectTagSafe(UndeadLogConfig._instance, new AspectList().add(Aspect.TREE, 4).add(Aspect.UNDEAD, 4));
        Thaumcraft.registerObjectTagSafe(UndeadLeavesConfig._instance, new AspectList().add(Aspect.PLANT, 1).add(Aspect.UNDEAD, 1));
        Thaumcraft.registerObjectTagSafe(WerewolfBoneConfig._instance, new AspectList().add(Aspect.FLESH, 2).add(Aspect.DEATH, 2));
        Thaumcraft.registerObjectTagSafe(WerewolfFleshConfig._instance, new AspectList().add(Aspect.MAN, 8));
        Thaumcraft.registerObjectTagSafe(WerewolfFurConfig._instance, new AspectList().add(Aspect.BEAST, 8));
        AspectList weatherContainerList = new AspectList().add(Aspect.DARKNESS, 3).add(Aspect.CRYSTAL, 1);
        Thaumcraft.registerObjectTagSafe(WeatherContainerConfig._instance, new AspectList().add(weatherContainerList.copy()).add(Aspect.WEATHER, 4).add(Aspect.MAGIC, 2));
        Thaumcraft.registerObjectTagSafe(WeatherContainerConfig._instance, WeatherContainer.WeatherContainerTypes.CLEAR.ordinal(), new AspectList().add(weatherContainerList.copy()).add(Aspect.ORDER, 6));
        Thaumcraft.registerObjectTagSafe(WeatherContainerConfig._instance, WeatherContainer.WeatherContainerTypes.RAIN.ordinal(), new AspectList().add(weatherContainerList.copy()).add(Aspect.WATER, 6));
        Thaumcraft.registerObjectTagSafe(WeatherContainerConfig._instance, WeatherContainer.WeatherContainerTypes.LIGHTNING.ordinal(), new AspectList().add(weatherContainerList.copy()).add(Aspect.ENERGY, 6));
        Thaumcraft.registerObjectTagSafe(EnvironmentalAccumulatorConfig._instance, new AspectList().add(Aspect.MAGIC, 10).add(Aspect.ENTROPY, 5).add(Aspect.EXCHANGE, 4).add(Aspect.MECHANISM, 3).add(Aspect.WEATHER, 10));
        Thaumcraft.registerObjectTagSafe(SpiritPortalConfig._instance, new AspectList().add(Aspect.MAGIC, 10).add(Aspect.TRAVEL, 10).add(Aspect.UNDEAD, 10));
        Thaumcraft.registerObjectTagSafe(DarkBloodBrickConfig._instance, new AspectList().add(Aspect.CRYSTAL, 10).add(Aspect.DARKNESS, 10).add(new AspectList(new ItemStack(DarkPowerGemConfig._instance.getItemInstance()))));
        Thaumcraft.registerObjectTagSafe(BroomConfig._instance, new AspectList().add(Aspect.MOTION, 4).add(Aspect.MAGIC, 2).add(Aspect.FLIGHT, 6).add(Aspect.TRAVEL, 2));
        Thaumcraft.registerObjectTagSafe(BlookConfig._instance, new AspectList().add(bloodLists.copy()).add(Aspect.MIND, 1));
        Thaumcraft.registerObjectTagSafe(InvertedPotentiaConfig._instance, 1, new AspectList().add(Aspect.DARKNESS, 2).add(Aspect.ENERGY, 4));
        Thaumcraft.registerObjectTagSafe(CorruptedTearConfig._instance, new AspectList().add(Aspect.DEATH, 4).add(Aspect.SOUL, 4).add(Aspect.ENTROPY, 4).add(Aspect.EXCHANGE, 8).add(Aspect.TRAVEL, 2).add(Aspect.MAGIC, 4));
        for (int i = 0; i < 3; ++i) {
            Thaumcraft.registerObjectTagSafe(PromiseAcceptorConfig._instance, i, new AspectList().add(Aspect.METAL, 10).add(Aspect.MECHANISM, 10));
        }
        Thaumcraft.registerObjectTagSafe(BloodWaxedCoalConfig._instance, new AspectList().add(Aspect.FIRE, 4).add(Aspect.ENERGY, 4).add(bloodLists.copy()));
        Thaumcraft.registerObjectTagSafe(BloodPotashConfig._instance, new AspectList().add(Aspect.SENSES, 2).add(bloodLists.copy()));
        Thaumcraft.registerObjectTagSafe(EnderTearConfig._instance, new AspectList().add(Aspect.TRAVEL, 8).add(Aspect.MAGIC, 8).add(Aspect.ELDRITCH, 4));
        Thaumcraft.registerObjectTagSafe(BloodOrbConfig._instance, 1, new AspectList().add(Aspect.ORDER, 1).add(bloodLists.copy()));
        Thaumcraft.registerObjectTagSafe(OriginsOfDarknessConfig._instance, new AspectList().add(Aspect.MIND, 4).add(Aspect.DARKNESS, 4));
        ThaumcraftApi.registerObjectTag((String)DarkSpikeConfig._instance.getOreDictionaryId(), (AspectList)new AspectList().add(Aspect.METAL, 2).add(Aspect.DARKNESS, 2).add(Aspect.DEATH, 1));
        Thaumcraft.registerObjectTagSafe(ObscuredGlassConfig._instance, new AspectList().add(Aspect.DARKNESS, 4).add(Aspect.LIGHT, 4));
        Thaumcraft.registerObjectTagSafe(BurningGemStoneConfig._instance, new AspectList().add(Aspect.CRYSTAL, 10).add(Aspect.DARKNESS, 10).add(Aspect.FIRE, 4).add(Aspect.SOUL, 2));
        Thaumcraft.registerObjectTagSafe(GemStoneTorchConfig._instance, new AspectList().add(Aspect.CRYSTAL, 2).add(Aspect.DARKNESS, 2).add(Aspect.FIRE, 2).add(Aspect.LIGHT, 2).add(Aspect.SOUL, 1));
        Thaumcraft.registerObjectTagSafe(PotentiaSphereConfig._instance, new AspectList().add(Aspect.SLIME, 2).add(Aspect.MAGIC, 4).add(Aspect.CRYSTAL, 2).add(Aspect.LIGHT, 2).add(Aspect.MECHANISM, 1));
    }

    private static void registerEntityTagSafe(MobConfig mobConfig, AspectList aspects, ThaumcraftApi.EntityTagsNBT ... nbt) {
        if (mobConfig != null) {
            ThaumcraftApi.registerEntityTag((String)mobConfig.getNamedId(), (AspectList)aspects, (ThaumcraftApi.EntityTagsNBT[])nbt);
        }
    }

    private static void registerObjectTagSafe(ItemConfig itemConfig, AspectList aspects) {
        if (itemConfig != null) {
            ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(itemConfig.getItemInstance()), (AspectList)aspects);
        }
    }

    private static void registerObjectTagSafe(ItemConfig itemConfig, int meta, AspectList aspects) {
        if (itemConfig != null) {
            ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(itemConfig.getItemInstance(), 1, meta), (AspectList)aspects);
        }
    }

    private static void registerObjectTagSafe(BlockConfig blockConfig, AspectList aspects) {
        if (blockConfig != null) {
            ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(blockConfig.getBlockInstance()), (AspectList)aspects);
        }
    }
}

