/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import evilcraft.core.algorithm.SingleCache;
import evilcraft.network.CodecField;
import evilcraft.network.PacketBase;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;

public abstract class PacketCodec
extends PacketBase {
    private static Map<Class<?>, ICodecAction> codecActions = Maps.newHashMap();
    private SingleCache<Void, List<Field>> fieldCache = new SingleCache<Void, List<Field>>(new SingleCache.ICacheUpdater<Void, List<Field>>(){

        @Override
        public List<Field> getNewValue(Void key) {
            Field[] fields = PacketCodec.this.getClass().getDeclaredFields();
            Arrays.sort(fields, new Comparator<Field>(){

                @Override
                public int compare(Field o1, Field o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            LinkedList fieldList = Lists.newLinkedList();
            for (Field field : fields) {
                if (!field.isAnnotationPresent(CodecField.class)) continue;
                fieldList.add(field);
            }
            return fieldList;
        }

        @Override
        public boolean isKeyEqual(Void cacheKey, Void newKey) {
            return true;
        }
    });

    protected static ICodecAction getAction(Class<?> clazz) {
        ICodecAction action;
        if (ClassUtils.isPrimitiveWrapper(clazz)) {
            clazz = ClassUtils.wrapperToPrimitive(clazz);
        }
        if ((action = codecActions.get(clazz)) == null) {
            System.err.println("No ICodecAction was found for " + clazz + ". You should add one in PacketCodec.");
        }
        return action;
    }

    private void loopCodecFields(ICodecRunnable runnable) {
        for (Field field : this.fieldCache.get(null)) {
            Class<?> clazz = field.getType();
            ICodecAction action = PacketCodec.getAction(clazz);
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            runnable.run(field, action);
            field.setAccessible(accessible);
        }
    }

    @Override
    public void encode(final ByteArrayDataOutput output) {
        this.loopCodecFields(new ICodecRunnable(){

            @Override
            public void run(Field field, ICodecAction action) {
                Object object = null;
                try {
                    object = field.get(PacketCodec.this);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                action.encode(object, output);
            }
        });
    }

    @Override
    public void decode(final ByteArrayDataInput input) {
        this.loopCodecFields(new ICodecRunnable(){

            @Override
            public void run(Field field, ICodecAction action) {
                Object object = action.decode(input);
                try {
                    field.set(PacketCodec.this, object);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    static {
        codecActions.put(String.class, new ICodecAction(){

            @Override
            public void encode(Object object, ByteArrayDataOutput output) {
                output.writeUTF((String)object);
            }

            @Override
            public Object decode(ByteArrayDataInput input) {
                return input.readUTF();
            }
        });
        codecActions.put(Double.TYPE, new ICodecAction(){

            @Override
            public void encode(Object object, ByteArrayDataOutput output) {
                output.writeDouble(((Double)object).doubleValue());
            }

            @Override
            public Object decode(ByteArrayDataInput input) {
                return input.readDouble();
            }
        });
        codecActions.put(Integer.TYPE, new ICodecAction(){

            @Override
            public void encode(Object object, ByteArrayDataOutput output) {
                output.writeInt(((Integer)object).intValue());
            }

            @Override
            public Object decode(ByteArrayDataInput input) {
                return input.readInt();
            }
        });
        codecActions.put(Boolean.TYPE, new ICodecAction(){

            @Override
            public void encode(Object object, ByteArrayDataOutput output) {
                output.writeBoolean(((Boolean)object).booleanValue());
            }

            @Override
            public Object decode(ByteArrayDataInput input) {
                return input.readBoolean();
            }
        });
        codecActions.put(Float.TYPE, new ICodecAction(){

            @Override
            public void encode(Object object, ByteArrayDataOutput output) {
                output.writeFloat(((Float)object).floatValue());
            }

            @Override
            public Object decode(ByteArrayDataInput input) {
                return Float.valueOf(input.readFloat());
            }
        });
        codecActions.put(Map.class, new ICodecAction(){

            @Override
            public void encode(Object object, ByteArrayDataOutput output) {
                Map map = (Map)object;
                output.writeInt(map.size());
                Set entries = map.entrySet();
                ICodecAction keyAction = null;
                ICodecAction valueAction = null;
                for (Map.Entry entry : entries) {
                    if (keyAction == null) {
                        keyAction = PacketCodec.getAction(entry.getKey().getClass());
                        output.writeUTF(entry.getKey().getClass().getName());
                    }
                    if (valueAction == null) {
                        valueAction = PacketCodec.getAction(entry.getValue().getClass());
                        output.writeUTF(entry.getValue().getClass().getName());
                    }
                    keyAction.encode(entry.getKey(), output);
                    valueAction.encode(entry.getValue(), output);
                }
            }

            @Override
            public Object decode(ByteArrayDataInput input) {
                HashMap map = Maps.newHashMap();
                int size = input.readInt();
                if (size == 0) {
                    return map;
                }
                try {
                    ICodecAction keyAction = PacketCodec.getAction(Class.forName(input.readUTF()));
                    ICodecAction valueAction = PacketCodec.getAction(Class.forName(input.readUTF()));
                    for (int i = 0; i < size; ++i) {
                        Object key = keyAction.decode(input);
                        Object value = valueAction.decode(input);
                        map.put(key, value);
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                return map;
            }
        });
    }

    private static interface ICodecRunnable {
        public void run(Field var1, ICodecAction var2);
    }

    private static interface ICodecAction {
        public void encode(Object var1, ByteArrayDataOutput var2);

        public Object decode(ByteArrayDataInput var1);
    }
}

