/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.network;

import com.google.common.collect.Maps;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.core.helper.Helpers;
import evilcraft.network.PacketBase;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.AttributeKey;
import java.util.EnumMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.world.World;

@ChannelHandler.Sharable
public final class PacketHandler {
    private static Codec CODEC;
    private static final EnumMap<Side, FMLEmbeddedChannel> CHANNELS;

    private PacketHandler() {
    }

    public static void init() {
        if (!CHANNELS.isEmpty()) {
            return;
        }
        CODEC = new Codec();
        CHANNELS.putAll(NetworkRegistry.INSTANCE.newChannel("evilcraft", new ChannelHandler[]{CODEC, new HandlerServer()}));
        if (FMLCommonHandler.instance().getSide().isClient()) {
            FMLEmbeddedChannel channel = CHANNELS.get(Side.CLIENT);
            String codecName = channel.findChannelHandlerNameForType(Codec.class);
            channel.pipeline().addAfter(codecName, "ClientHandler", (ChannelHandler)new HandlerClient());
        }
    }

    public static void register(Class<? extends PacketBase> packetType) {
        CODEC.addDiscriminator(Helpers.getNewId(Helpers.IDType.PACKET), packetType);
    }

    public static FMLEmbeddedChannel getClientChannel() {
        return CHANNELS.get(Side.CLIENT);
    }

    public static FMLEmbeddedChannel getServerChannel() {
        return CHANNELS.get(Side.SERVER);
    }

    public static void sendToServer(PacketBase packet) {
        PacketHandler.getClientChannel().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        PacketHandler.getClientChannel().writeAndFlush((Object)packet);
    }

    public static void sendToPlayer(PacketBase packet, EntityPlayer player) {
        PacketHandler.getServerChannel().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        PacketHandler.getServerChannel().attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        PacketHandler.getServerChannel().writeAndFlush((Object)packet);
    }

    public static void sendToAllAround(PacketBase packet, NetworkRegistry.TargetPoint point) {
        PacketHandler.getServerChannel().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        PacketHandler.getServerChannel().attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        PacketHandler.getServerChannel().writeAndFlush((Object)packet);
    }

    public static void sendToDimension(PacketBase packet, int dimension) {
        PacketHandler.getServerChannel().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        PacketHandler.getServerChannel().attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimension);
        PacketHandler.getServerChannel().writeAndFlush((Object)packet);
    }

    public static void sendToAll(PacketBase packet) {
        PacketHandler.getServerChannel().attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        PacketHandler.getServerChannel().writeAndFlush((Object)packet);
    }

    public static Packet toMcPacket(PacketBase packet) {
        return CHANNELS.get(FMLCommonHandler.instance().getEffectiveSide()).generatePacketFrom((Object)packet);
    }

    static {
        CHANNELS = Maps.newEnumMap(Side.class);
    }

    @ChannelHandler.Sharable
    private static final class HandlerServer
    extends SimpleChannelInboundHandler<PacketBase> {
        private HandlerServer() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, PacketBase packet) throws Exception {
            if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                return;
            }
            EntityPlayerMP player = ((NetHandlerPlayServer)ctx.channel().attr((AttributeKey)NetworkRegistry.NET_HANDLER).get()).field_147369_b;
            packet.actionServer(player.field_70170_p, player);
        }
    }

    @ChannelHandler.Sharable
    @SideOnly(value=Side.CLIENT)
    private static final class HandlerClient
    extends SimpleChannelInboundHandler<PacketBase> {
        private HandlerClient() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, PacketBase packet) throws Exception {
            Minecraft mc = Minecraft.func_71410_x();
            packet.actionClient((World)mc.field_71441_e, (EntityPlayer)mc.field_71439_g);
        }
    }

    private static final class Codec
    extends FMLIndexedMessageToMessageCodec<PacketBase> {
        private Codec() {
        }

        public void encodeInto(ChannelHandlerContext ctx, PacketBase packet, ByteBuf target) throws Exception {
            ByteArrayDataOutput output = ByteStreams.newDataOutput();
            packet.encode(output);
            target.writeBytes(output.toByteArray());
        }

        public void decodeInto(ChannelHandlerContext ctx, ByteBuf source, PacketBase packet) {
            ByteArrayDataInput input = ByteStreams.newDataInput((byte[])source.array());
            input.skipBytes(1);
            packet.decode(input);
        }
    }
}

