/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.network.packet;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.api.ILocation;
import evilcraft.client.particle.EntityBloodBrickFX;
import evilcraft.core.helper.LocationHelpers;
import evilcraft.network.CodecField;
import evilcraft.network.PacketCodec;
import evilcraft.network.PacketHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class DetectionListenerPacket
extends PacketCodec {
    private static final int RANGE = 100;
    @CodecField
    private int x = 0;
    @CodecField
    private int y = 0;
    @CodecField
    private int z = 0;
    @CodecField
    private boolean activation = true;

    public DetectionListenerPacket() {
    }

    public DetectionListenerPacket(int x, int y, int z, boolean activation) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.activation = activation;
    }

    public DetectionListenerPacket(ILocation location, boolean activation) {
        this.x = location.getCoordinates()[0];
        this.y = location.getCoordinates()[1];
        this.z = location.getCoordinates()[2];
        this.activation = activation;
    }

    @SideOnly(value=Side.CLIENT)
    private void showActivatedParticle(World world, int x, int y, int z, ForgeDirection side) {
        EntityBloodBrickFX burst = new EntityBloodBrickFX(world, x, y, z, side);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)burst);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void actionClient(World world, EntityPlayer player) {
        if (this.activation) {
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                this.showActivatedParticle(world, this.x, this.y, this.z, side);
            }
        }
    }

    @Override
    public void actionServer(World world, EntityPlayerMP player) {
        PacketHandler.sendToAllAround(new DetectionListenerPacket(this.x, this.y, this.z, this.activation), LocationHelpers.createTargetPointFromEntityPosition((Entity)player, 100));
    }
}

