/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.network.packet;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.EvilCraft;
import evilcraft.api.ILocation;
import evilcraft.network.CodecField;
import evilcraft.network.PacketCodec;
import evilcraft.network.PacketHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;

public class SoundPacket
extends PacketCodec {
    private static final int RANGE = 15;
    @CodecField
    private double x = 0.0;
    @CodecField
    private double y = 0.0;
    @CodecField
    private double z = 0.0;
    @CodecField
    private String mod = "";
    @CodecField
    private String sound = "";
    @CodecField
    private float volume = 0.0f;
    @CodecField
    private float frequency = 0.0f;

    public SoundPacket() {
    }

    public SoundPacket(double x, double y, double z, String sound, float volume, float frequency) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.sound = sound;
        this.volume = volume;
        this.frequency = frequency;
    }

    public SoundPacket(double x, double y, double z, String sound, float volume, float frequency, String mod) {
        this(x, y, z, sound, volume, frequency);
        this.mod = mod;
    }

    public SoundPacket(ILocation location, String sound, float volume, float frequency) {
        this(location.getCoordinates()[0], location.getCoordinates()[1], location.getCoordinates()[2], sound, volume, frequency);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void actionClient(World world, EntityPlayer player) {
        EvilCraft.proxy.playSound(this.x, this.y, this.z, this.sound, this.volume, this.frequency, this.mod);
    }

    @Override
    public void actionServer(World world, EntityPlayerMP player) {
        PacketHandler.sendToAllAround(new SoundPacket(this.x, this.y, this.z, this.sound, this.volume, this.frequency, this.mod), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, this.x, this.y, this.z, 15.0));
    }
}

