/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.network.packet;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import evilcraft.core.fluid.WorldSharedTankCache;
import evilcraft.network.CodecField;
import evilcraft.network.PacketCodec;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class UpdateWorldSharedTankClientCachePacket
extends PacketCodec {
    @CodecField
    private String tankID = null;
    @CodecField
    private int fluidId = 0;
    @CodecField
    private int fluidAmount = 0;

    public UpdateWorldSharedTankClientCachePacket() {
    }

    public UpdateWorldSharedTankClientCachePacket(String tankID, FluidStack fluidStack) {
        this.tankID = tankID;
        if (fluidStack == null) {
            this.fluidId = -1;
            this.fluidAmount = -1;
        } else {
            this.fluidId = fluidStack.getFluidID();
            this.fluidAmount = fluidStack.amount;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void actionClient(World world, EntityPlayer player) {
        FluidStack fluidStack = null;
        if (this.fluidAmount >= 0 && this.fluidId >= 0) {
            fluidStack = new FluidStack(this.fluidId, this.fluidAmount);
        }
        WorldSharedTankCache.getInstance().setTankContent(this.tankID, fluidStack);
    }

    @Override
    public void actionServer(World world, EntityPlayerMP player) {
    }
}

