/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.tileentity;

import evilcraft.core.tileentity.EvilCraftTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEternalWaterBlock
extends EvilCraftTileEntity
implements IFluidHandler {
    public static final FluidStack WATER = new FluidStack(FluidRegistry.WATER, 1000);

    @Override
    protected void updateTileEntity() {
        if (!this.func_145831_w().field_72995_K) {
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
                if (!(tile instanceof IFluidHandler)) continue;
                IFluidHandler handler = (IFluidHandler)tile;
                FluidStack fluidStack = new FluidStack(FluidRegistry.WATER, 1000);
                handler.fill(direction.getOpposite(), fluidStack, true);
            }
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || resource.getFluid() != FluidRegistry.WATER) {
            return null;
        }
        return this.drain(from, 1000, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return new FluidStack(FluidRegistry.WATER, maxDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo(WATER.copy(), 1000)};
    }
}

