/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.tileentity;

import com.google.common.collect.Lists;
import evilcraft.Configs;
import evilcraft.api.ILocation;
import evilcraft.block.BoxOfEternalClosure;
import evilcraft.block.BoxOfEternalClosureConfig;
import evilcraft.block.DarkBloodBrick;
import evilcraft.block.SpiritFurnace;
import evilcraft.core.algorithm.Size;
import evilcraft.core.algorithm.Sizes;
import evilcraft.core.block.AllowedBlock;
import evilcraft.core.block.CubeDetector;
import evilcraft.core.block.HollowCubeDetector;
import evilcraft.core.fluid.BloodFluidConverter;
import evilcraft.core.fluid.ImplicitFluidConversionTank;
import evilcraft.core.fluid.SingleUseTank;
import evilcraft.core.helper.LocationHelpers;
import evilcraft.core.inventory.slot.SlotFluidContainer;
import evilcraft.core.tileentity.NBTPersist;
import evilcraft.core.tileentity.tickaction.ITickAction;
import evilcraft.core.tileentity.tickaction.TickComponent;
import evilcraft.core.tileentity.upgrade.IUpgradeSensitiveEvent;
import evilcraft.core.tileentity.upgrade.UpgradeBehaviour;
import evilcraft.core.tileentity.upgrade.Upgrades;
import evilcraft.core.world.FakeWorldItemDelegator;
import evilcraft.fluid.Blood;
import evilcraft.network.PacketHandler;
import evilcraft.network.packet.DetectionListenerPacket;
import evilcraft.tileentity.TileWorking;
import evilcraft.tileentity.tickaction.EmptyFluidContainerInTankTickAction;
import evilcraft.tileentity.tickaction.EmptyItemBucketInTankTickAction;
import evilcraft.tileentity.tickaction.spiritfurnace.BoxCookTickAction;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.apache.commons.lang3.mutable.MutableDouble;

public class TileSpiritFurnace
extends TileWorking<TileSpiritFurnace, MutableDouble>
implements FakeWorldItemDelegator.IItemDropListener {
    public static final int SLOT_CONTAINER = 0;
    public static final int SLOT_BOX = 1;
    public static final int[] SLOTS_DROP = new int[]{2, 3, 4, 5};
    public static final int SLOTS = 2 + SLOTS_DROP.length;
    public static String TANKNAME = "spiritFurnaceTank";
    public static final int LIQUID_PER_SLOT = 10000;
    public static final int TICKS_PER_LIQUID = 2;
    public static final Fluid ACCEPTED_FLUID = Blood.getInstance();
    public static CubeDetector detector = new HollowCubeDetector(new AllowedBlock[]{new AllowedBlock(DarkBloodBrick.getInstance()), new AllowedBlock((Block)SpiritFurnace.getInstance()).setMaxOccurences(1)}, Lists.newArrayList((Object[])new Block[]{SpiritFurnace.getInstance(), DarkBloodBrick.getInstance()})).setMinimumSize(new Size(2, 2, 2));
    private static final Map<Class<?>, ITickAction<TileSpiritFurnace>> BOX_COOK_TICK_ACTIONS = new LinkedHashMap();
    private static final Map<Class<?>, ITickAction<TileSpiritFurnace>> EMPTY_IN_TANK_TICK_ACTIONS;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_SPEED;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_BLOODUSAGE;
    @NBTPersist
    private Size size = Size.NULL_SIZE.copy();
    @NBTPersist
    private Boolean forceHalt = false;
    @NBTPersist
    private Boolean caughtError = false;
    private int cookTicker = this.addTicker(new TickComponent<TileSpiritFurnace, ITickAction<TileSpiritFurnace>>(this, BOX_COOK_TICK_ACTIONS, 1));
    private EntityLiving boxEntityCache = null;

    public TileSpiritFurnace() {
        super(SLOTS, SpiritFurnace.getInstance().func_149732_F(), 10000, TANKNAME, ACCEPTED_FLUID);
        this.addTicker(new TickComponent<TileSpiritFurnace, ITickAction<TileSpiritFurnace>>(this, EMPTY_IN_TANK_TICK_ACTIONS, 0, false));
        LinkedList<Integer> inSlots = new LinkedList<Integer>();
        inSlots.add(1);
        LinkedList<Integer> inSlotsTank = new LinkedList<Integer>();
        inSlotsTank.add(0);
        LinkedList<Integer> outSlots = new LinkedList<Integer>();
        for (int slot : SLOTS_DROP) {
            outSlots.add(slot);
        }
        this.addSlotsToSide(ForgeDirection.EAST, inSlotsTank);
        this.addSlotsToSide(ForgeDirection.UP, inSlots);
        this.addSlotsToSide(ForgeDirection.DOWN, outSlots);
        this.addSlotsToSide(ForgeDirection.SOUTH, outSlots);
        this.addSlotsToSide(ForgeDirection.WEST, outSlots);
        this.upgradeBehaviour.put(UPGRADE_SPEED, new UpgradeBehaviour<TileSpiritFurnace, MutableDouble>(1.0){

            @Override
            public void applyUpgrade(TileSpiritFurnace upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableDouble> event) {
                double val;
                if (event.getType() == UPGRADEEVENT_SPEED) {
                    val = event.getObject().getValue();
                    event.getObject().setValue(val /= 1.0 + (double)upgradeLevel / this.valueFactor);
                }
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    val = event.getObject().getValue();
                    event.getObject().setValue(val *= 1.0 + (double)upgradeLevel / this.valueFactor);
                }
            }
        });
        this.upgradeBehaviour.put(UPGRADE_EFFICIENCY, new UpgradeBehaviour<TileSpiritFurnace, MutableDouble>(2.0){

            @Override
            public void applyUpgrade(TileSpiritFurnace upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableDouble> event) {
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    double val = event.getObject().getValue();
                    event.getObject().setValue(val /= 1.0 + (double)upgradeLevel / this.valueFactor);
                }
            }
        });
    }

    @Override
    protected SingleUseTank newTank(String tankName, int tankSize) {
        return new ImplicitFluidConversionTank(tankName, tankSize, this, BloodFluidConverter.getInstance());
    }

    @Override
    protected int getWorkTicker() {
        return this.cookTicker;
    }

    public EntityLiving getEntity() {
        String id;
        ItemStack boxStack = this.getInventory().func_70301_a(this.getConsumeSlot());
        if (boxStack != null && boxStack.func_77973_b() == TileSpiritFurnace.getAllowedCookItem() && (id = BoxOfEternalClosure.getInstance().getSpiritName(boxStack)) != null) {
            if (this.boxEntityCache != null && id.equals(EntityList.func_75621_b((Entity)this.boxEntityCache))) {
                return this.boxEntityCache;
            }
            Class entityClass = (Class)EntityList.field_75625_b.get(id);
            if (entityClass != null) {
                EntityLiving entity;
                FakeWorldItemDelegator world = FakeWorldItemDelegator.getInstance();
                this.boxEntityCache = entity = (EntityLiving)EntityList.func_75620_a((String)id, (World)world);
                return entity;
            }
        }
        return null;
    }

    public String getPlayerId() {
        ItemStack boxStack = this.getInventory().func_70301_a(this.getConsumeSlot());
        if (boxStack != null && boxStack.func_77973_b() == TileSpiritFurnace.getAllowedCookItem()) {
            return BoxOfEternalClosure.getInstance().getPlayerId(boxStack);
        }
        return "";
    }

    public String getPlayerName() {
        ItemStack boxStack = this.getInventory().func_70301_a(this.getConsumeSlot());
        if (boxStack != null && boxStack.func_77973_b() == TileSpiritFurnace.getAllowedCookItem()) {
            return BoxOfEternalClosure.getInstance().getPlayerName(boxStack);
        }
        return "";
    }

    public boolean isPlayer() {
        return !this.getPlayerId().isEmpty();
    }

    public Size getEntitySize() {
        EntityLiving entity = this.getEntity();
        if (entity == null) {
            return Size.NULL_SIZE;
        }
        return Sizes.getEntitySize((Entity)entity);
    }

    public boolean isSizeValidForEntity() {
        EntityLiving entity = this.getEntity();
        if (entity == null) {
            return false;
        }
        Size requiredSize = this.getEntitySize();
        return this.getInnerSize().compareTo(requiredSize) >= 0;
    }

    @Override
    public boolean canWork() {
        Size size = this.getSize();
        return size.compareTo(detector.getMinimumSize()) >= 0;
    }

    public static boolean canWork(World world, ILocation location) {
        TileEntity tile = LocationHelpers.getTile((IBlockAccess)world, location);
        if (tile != null) {
            return ((TileSpiritFurnace)tile).canWork();
        }
        return false;
    }

    public static Item getAllowedCookItem() {
        Item allowedItem = Items.field_151034_e;
        if (Configs.isEnabled(BoxOfEternalClosureConfig.class)) {
            allowedItem = Item.func_150898_a((Block)BoxOfEternalClosure.getInstance());
        }
        return allowedItem;
    }

    public static void detectStructure(World world, ILocation location, Size size, boolean valid) {
        int newMeta = valid ? 1 : 0;
        boolean change = LocationHelpers.getBlockMeta(world, location) != newMeta;
        LocationHelpers.setBlockMetadata(world, location, newMeta, 2);
        if (change) {
            int[] c = location.getCoordinates();
            PacketHandler.sendToAllAround(new DetectionListenerPacket(location, valid), LocationHelpers.createTargetPointFromLocation(world, location, 50));
        }
    }

    @Override
    public boolean canConsume(ItemStack itemStack) {
        return itemStack != null && TileSpiritFurnace.getAllowedCookItem() == itemStack.func_77973_b();
    }

    public int getConsumeSlot() {
        return 1;
    }

    public int[] getProduceSlots() {
        return SLOTS_DROP;
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        if (slot == 1) {
            return this.canConsume(itemStack);
        }
        if (slot == 0) {
            return SlotFluidContainer.checkIsItemValid(itemStack, this.getTank());
        }
        return false;
    }

    public Size getSize() {
        return this.size;
    }

    public Size getInnerSize() {
        return (Size)this.getSize().subtract(new Size(1, 1, 1));
    }

    public void setSize(Size size) {
        this.size = size;
        this.sendUpdate();
    }

    @Override
    public void onItemDrop(ItemStack itemStack) {
        boolean placed = false;
        int[] slots = this.getProduceSlots();
        for (int i = 0; !placed && i < slots.length; ++i) {
            ItemStack produceStack = this.getInventory().func_70301_a(slots[i]);
            if (produceStack == null) {
                this.getInventory().func_70299_a(slots[i], itemStack);
                placed = true;
                continue;
            }
            if (produceStack.func_77973_b() != itemStack.func_77973_b() || produceStack.func_77976_d() < produceStack.field_77994_a + itemStack.field_77994_a) continue;
            produceStack.field_77994_a += itemStack.field_77994_a;
            placed = true;
        }
        this.forceHalt = !placed;
    }

    @Override
    public void resetWork(boolean hardReset) {
        this.forceHalt = false;
        this.caughtError = false;
        super.resetWork(hardReset);
    }

    public boolean isForceHalt() {
        return this.forceHalt;
    }

    public boolean isCaughtError() {
        return this.caughtError;
    }

    public void caughtError() {
        this.caughtError = true;
    }

    static {
        BOX_COOK_TICK_ACTIONS.put(BoxOfEternalClosure.class, new BoxCookTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS = new LinkedHashMap();
        EMPTY_IN_TANK_TICK_ACTIONS.put(IFluidContainerItem.class, new EmptyFluidContainerInTankTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS.put(Item.class, new EmptyItemBucketInTankTickAction());
        UPGRADEEVENT_SPEED = Upgrades.newUpgradeEventType();
        UPGRADEEVENT_BLOODUSAGE = Upgrades.newUpgradeEventType();
    }
}

