/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.tileentity;

import evilcraft.Configs;
import evilcraft.block.BoxOfEternalClosure;
import evilcraft.block.BoxOfEternalClosureConfig;
import evilcraft.block.SpiritReanimator;
import evilcraft.core.fluid.BloodFluidConverter;
import evilcraft.core.fluid.ImplicitFluidConversionTank;
import evilcraft.core.fluid.SingleUseTank;
import evilcraft.core.inventory.slot.SlotFluidContainer;
import evilcraft.core.tileentity.NBTPersist;
import evilcraft.core.tileentity.tickaction.ITickAction;
import evilcraft.core.tileentity.tickaction.TickComponent;
import evilcraft.core.tileentity.upgrade.IUpgradeSensitiveEvent;
import evilcraft.core.tileentity.upgrade.UpgradeBehaviour;
import evilcraft.core.tileentity.upgrade.Upgrades;
import evilcraft.fluid.Blood;
import evilcraft.tileentity.TileWorking;
import evilcraft.tileentity.tickaction.EmptyFluidContainerInTankTickAction;
import evilcraft.tileentity.tickaction.EmptyItemBucketInTankTickAction;
import evilcraft.tileentity.tickaction.spiritreanimator.ReanimateTickAction;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.apache.commons.lang3.mutable.MutableDouble;

public class TileSpiritReanimator
extends TileWorking<TileSpiritReanimator, MutableDouble> {
    public static final int SLOT_CONTAINER = 0;
    public static final int SLOT_BOX = 1;
    public static final int SLOT_EGG = 2;
    public static final int SLOTS_OUTPUT = 3;
    public static final int SLOTS = 4;
    public static String TANKNAME = "spiritReanimatorTank";
    public static final int LIQUID_PER_SLOT = 10000;
    public static final int TICKS_PER_LIQUID = 2;
    public static final Fluid ACCEPTED_FLUID = Blood.getInstance();
    private static final Map<Class<?>, ITickAction<TileSpiritReanimator>> REANIMATE_COOK_TICK_ACTIONS = new LinkedHashMap();
    private static final Map<Class<?>, ITickAction<TileSpiritReanimator>> EMPTY_IN_TANK_TICK_ACTIONS;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_SPEED;
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_BLOODUSAGE;
    private int reanimateTicker = this.addTicker(new TickComponent<TileSpiritReanimator, ITickAction<TileSpiritReanimator>>(this, REANIMATE_COOK_TICK_ACTIONS, 1));
    @NBTPersist
    private Boolean caughtError = false;

    public TileSpiritReanimator() {
        super(4, SpiritReanimator.getInstance().func_149732_F(), 10000, TANKNAME, ACCEPTED_FLUID);
        this.addTicker(new TickComponent<TileSpiritReanimator, ITickAction<TileSpiritReanimator>>(this, EMPTY_IN_TANK_TICK_ACTIONS, 0, false));
        LinkedList<Integer> inSlots = new LinkedList<Integer>();
        inSlots.add(1);
        inSlots.add(2);
        LinkedList<Integer> inSlotsTank = new LinkedList<Integer>();
        inSlotsTank.add(0);
        LinkedList<Integer> outSlots = new LinkedList<Integer>();
        outSlots.add(3);
        this.addSlotsToSide(ForgeDirection.EAST, inSlotsTank);
        this.addSlotsToSide(ForgeDirection.UP, inSlots);
        this.addSlotsToSide(ForgeDirection.DOWN, outSlots);
        this.addSlotsToSide(ForgeDirection.SOUTH, outSlots);
        this.addSlotsToSide(ForgeDirection.WEST, outSlots);
        this.upgradeBehaviour.put(UPGRADE_SPEED, new UpgradeBehaviour<TileSpiritReanimator, MutableDouble>(1.0){

            @Override
            public void applyUpgrade(TileSpiritReanimator upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableDouble> event) {
                double val;
                if (event.getType() == UPGRADEEVENT_SPEED) {
                    val = event.getObject().getValue();
                    event.getObject().setValue(val /= 1.0 + (double)upgradeLevel / this.valueFactor);
                }
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    val = event.getObject().getValue();
                    event.getObject().setValue(val *= 1.0 + (double)upgradeLevel / this.valueFactor);
                }
            }
        });
        this.upgradeBehaviour.put(UPGRADE_EFFICIENCY, new UpgradeBehaviour<TileSpiritReanimator, MutableDouble>(2.0){

            @Override
            public void applyUpgrade(TileSpiritReanimator upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableDouble> event) {
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    double val = event.getObject().getValue();
                    event.getObject().setValue(val /= 1.0 + (double)upgradeLevel / this.valueFactor);
                }
            }
        });
    }

    @Override
    protected SingleUseTank newTank(String tankName, int tankSize) {
        return new ImplicitFluidConversionTank(tankName, tankSize, this, BloodFluidConverter.getInstance());
    }

    @Override
    protected int getWorkTicker() {
        return this.reanimateTicker;
    }

    public int getEntityID() {
        ItemStack boxStack = this.getInventory().func_70301_a(this.getConsumeSlot());
        if (boxStack != null && boxStack.func_77973_b() == TileSpiritReanimator.getAllowedCookItem()) {
            return BoxOfEternalClosure.getInstance().getSpiritID(boxStack);
        }
        return -1;
    }

    public static Item getAllowedCookItem() {
        Item allowedItem = Items.field_151034_e;
        if (Configs.isEnabled(BoxOfEternalClosureConfig.class)) {
            allowedItem = Item.func_150898_a((Block)BoxOfEternalClosure.getInstance());
        }
        return allowedItem;
    }

    @Override
    public boolean canConsume(ItemStack itemStack) {
        return itemStack != null && TileSpiritReanimator.getAllowedCookItem() == itemStack.func_77973_b();
    }

    public int getConsumeSlot() {
        return 1;
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        if (slot == 1) {
            return this.canConsume(itemStack);
        }
        if (slot == 2) {
            return itemStack.func_77973_b() == Items.field_151110_aK;
        }
        if (slot == 0) {
            return SlotFluidContainer.checkIsItemValid(itemStack, this.getTank());
        }
        return false;
    }

    @Override
    public boolean canWork() {
        ItemStack eggStack = this.func_70301_a(2);
        ItemStack outputStack = this.func_70301_a(3);
        return eggStack != null && this.getEntityID() != -1 && EntityList.field_75627_a.get(this.getEntityID()) != null && (outputStack == null || outputStack.func_77976_d() > outputStack.field_77994_a && outputStack.func_77960_j() == this.getEntityID());
    }

    @Override
    public void onStateChanged() {
        this.sendUpdate();
    }

    static {
        REANIMATE_COOK_TICK_ACTIONS.put(BoxOfEternalClosure.class, new ReanimateTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS = new LinkedHashMap();
        EMPTY_IN_TANK_TICK_ACTIONS.put(IFluidContainerItem.class, new EmptyFluidContainerInTankTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS.put(Item.class, new EmptyItemBucketInTankTickAction());
        UPGRADEEVENT_SPEED = Upgrades.newUpgradeEventType();
        UPGRADEEVENT_BLOODUSAGE = Upgrades.newUpgradeEventType();
    }
}

