/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.tileentity.tickaction;

import evilcraft.core.tileentity.InventoryTileEntity;
import evilcraft.core.tileentity.TankInventoryTileEntity;
import evilcraft.core.tileentity.TickingTankInventoryTileEntity;
import evilcraft.tileentity.tickaction.EmptyInTankTickAction;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class EmptyFluidContainerInTankTickAction<T extends TickingTankInventoryTileEntity<T>>
extends EmptyInTankTickAction<T> {
    @Override
    public void onTick(T tile, ItemStack itemStack, int slot, int tick) {
        ItemStack containerStack = ((InventoryTileEntity)((Object)tile)).getInventory().func_70301_a(slot);
        IFluidContainerItem container = (IFluidContainerItem)containerStack.func_77973_b();
        if (container.getFluid(containerStack) != null) {
            FluidStack fluidStack = container.getFluid(containerStack);
            fluidStack.amount = Math.min(MB_PER_TICK, fluidStack.amount);
            int filled = ((TankInventoryTileEntity)((Object)tile)).getTank().fill(fluidStack, true);
            container.drain(containerStack, filled, true);
        }
    }

    @Override
    public float getRequiredTicks(T tile, int slot, int tick) {
        return EmptyFluidContainerInTankTickAction.getRequiredTicks(tile, ((InventoryTileEntity)((Object)tile)).getInventory().func_70301_a(slot));
    }

    public static int getRequiredTicks(TankInventoryTileEntity tile, ItemStack itemStack) {
        IFluidContainerItem container = (IFluidContainerItem)itemStack.func_77973_b();
        int amount = 0;
        if (container.getFluid(itemStack) != null) {
            amount = container.getFluid((ItemStack)itemStack).amount;
        }
        int capacity = Math.min(container.getCapacity(itemStack), tile.getTank().getFluidAmount());
        return (capacity - amount) / MB_PER_TICK;
    }

    @Override
    public boolean canTick(T tile, ItemStack itemStack, int slot, int tick) {
        if (itemStack.field_77994_a > 1) {
            return false;
        }
        boolean emptyContainer = false;
        ItemStack containerStack = ((InventoryTileEntity)((Object)tile)).getInventory().func_70301_a(slot);
        IFluidContainerItem container = (IFluidContainerItem)containerStack.func_77973_b();
        if (container.getFluid(containerStack) != null) {
            FluidStack fluidStack = container.getFluid(containerStack);
            if (fluidStack.amount <= 0) {
                emptyContainer = true;
            }
        } else {
            emptyContainer = true;
        }
        return super.canTick(tile, itemStack, slot, tick) && !emptyContainer;
    }
}

