/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.tileentity.tickaction.bloodinfuser;

import evilcraft.api.recipes.custom.IRecipe;
import evilcraft.core.recipe.custom.DurationXpRecipeProperties;
import evilcraft.core.recipe.custom.ItemFluidStackAndTierRecipeComponent;
import evilcraft.core.recipe.custom.ItemStackRecipeComponent;
import evilcraft.core.tileentity.upgrade.UpgradeSensitiveEvent;
import evilcraft.core.tileentity.upgrade.Upgrades;
import evilcraft.tileentity.TileBloodInfuser;
import evilcraft.tileentity.tickaction.bloodinfuser.BloodInfuserTickAction;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableInt;

public class InfuseItemTickAction
extends BloodInfuserTickAction {
    @Override
    public boolean canTick(TileBloodInfuser tile, ItemStack itemStack, int slot, int tick) {
        return super.canTick(tile, itemStack, slot, tick) && tile.getTank().getFluidAmount() >= this.getRequiredFluidAmount(tile, this.getRecipe(tile));
    }

    @Override
    public void onTick(TileBloodInfuser tile, ItemStack itemStack, int slot, int tick) {
        IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> recipe = this.getRecipe(tile);
        if (tick >= this.getRequiredTicks(tile, recipe) && recipe != null && this.addToProduceSlot(tile, recipe.getOutput().getItemStack().func_77946_l())) {
            tile.getInventory().func_70298_a(tile.getConsumeSlot(), 1);
            tile.getTank().drain(this.getRequiredFluidAmount(tile, recipe), true);
        }
    }

    protected int getRequiredFluidAmount(TileBloodInfuser tile, IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> recipe) {
        MutableInt amount = new MutableInt(recipe.getInput().getFluidStack().amount);
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableInt>(amount, TileBloodInfuser.UPGRADEEVENT_BLOODUSAGE));
        return Math.max(1, amount.getValue());
    }

    private IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> getRecipe(TileBloodInfuser tile) {
        return tile.getRecipe(this.getInfuseStack(tile));
    }

    @Override
    public int getUnmodifiedRequiredTicks(TileBloodInfuser tile, int slot) {
        return this.getUnmodifiedRequiredTicks(tile, this.getRecipe(tile));
    }

    private int getUnmodifiedRequiredTicks(TileBloodInfuser tile, IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> recipe) {
        return recipe.getProperties().getDuration();
    }

    private int getRequiredTicks(TileBloodInfuser tile, IRecipe<ItemFluidStackAndTierRecipeComponent, ItemStackRecipeComponent, DurationXpRecipeProperties> recipe) {
        MutableInt duration = new MutableInt(this.getUnmodifiedRequiredTicks(tile, recipe));
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableInt>(duration, TileBloodInfuser.UPGRADEEVENT_SPEED));
        return duration.getValue();
    }

    @Override
    public ItemStack willProduceItem(TileBloodInfuser tile) {
        return this.getRecipe(tile).getOutput().getItemStack();
    }
}

