/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.tileentity.tickaction.purifier;

import evilcraft.api.tileentity.purifier.IPurifierAction;
import evilcraft.tileentity.TilePurifier;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class CollectPotionPurifyAction
implements IPurifierAction {
    public static final Item ALLOWED_ITEM = Items.field_151069_bo;
    private static final int PURIFY_DURATION = 60;

    @Override
    public boolean isItemValidForMainSlot(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean isItemValidForAdditionalSlot(ItemStack itemStack) {
        return itemStack != null && itemStack.func_77973_b() == ALLOWED_ITEM;
    }

    @Override
    public boolean canWork(TilePurifier tile) {
        if (tile.getPurifyItem() == null && tile.getAdditionalItem() != null && tile.getAdditionalItem().func_77973_b() == ALLOWED_ITEM && tile.getBucketsFloored() == tile.getMaxBuckets()) {
            int x = tile.field_145851_c;
            int y = tile.field_145848_d;
            int z = tile.field_145849_e;
            List entities = tile.func_145831_w().func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 2), (double)(z + 1)));
            for (EntityLivingBase entity : entities) {
                for (PotionEffect potionEffect : entity.func_70651_bq()) {
                    if (potionEffect.func_82720_e()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean work(TilePurifier tile) {
        World world = tile.func_145831_w();
        int tick = tile.getTick();
        if (tile.getPurifyItem() == null && tile.getAdditionalItem() != null && tile.getAdditionalItem().func_77973_b() == ALLOWED_ITEM && tile.getBucketsFloored() == tile.getMaxBuckets()) {
            int x = tile.field_145851_c;
            int y = tile.field_145848_d;
            int z = tile.field_145849_e;
            List entities = tile.func_145831_w().func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 2), (double)(z + 1)));
            for (EntityLivingBase entity : entities) {
                if (entity.func_70651_bq().isEmpty()) continue;
                if (tick >= 60 && !world.field_72995_K) {
                    for (PotionEffect potionEffect : entity.func_70651_bq()) {
                        if (potionEffect.func_82720_e()) continue;
                        entity.func_82170_o(potionEffect.func_76456_a());
                        ItemStack itemStack = new ItemStack((Item)Items.field_151068_bn);
                        NBTTagCompound tag = new NBTTagCompound();
                        NBTTagList tagList = new NBTTagList();
                        NBTTagCompound potionTag = new NBTTagCompound();
                        itemStack.func_77982_d(tag);
                        potionEffect.func_82719_a(potionTag);
                        tagList.func_74742_a((NBTBase)potionTag);
                        tag.func_74782_a("CustomPotionEffects", (NBTBase)tagList);
                        itemStack.func_77964_b(8229);
                        tile.setBuckets(0, 0);
                        tile.setAdditionalItem(itemStack);
                        return true;
                    }
                }
                if (!world.field_72995_K) continue;
                tile.showEffect();
            }
        }
        return false;
    }
}

