/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.tileentity.tickaction.purifier;

import com.google.common.collect.Lists;
import evilcraft.api.tileentity.purifier.IPurifierAction;
import evilcraft.api.tileentity.purifier.IPurifierActionRegistry;
import evilcraft.tileentity.TilePurifier;
import evilcraft.tileentity.tickaction.purifier.CollectPotionPurifyAction;
import evilcraft.tileentity.tickaction.purifier.DisenchantPurifyAction;
import evilcraft.tileentity.tickaction.purifier.ToolBadEnchantPurifyAction;
import java.util.List;
import net.minecraft.item.ItemStack;

public class PurifierActionRegistry
implements IPurifierActionRegistry {
    private List<IPurifierAction> registry = Lists.newArrayList();

    public PurifierActionRegistry() {
        this.register(new ToolBadEnchantPurifyAction());
        this.register(new DisenchantPurifyAction());
        this.register(new CollectPotionPurifyAction());
    }

    @Override
    public void register(IPurifierAction purifyAction) {
        this.registry.add(purifyAction);
    }

    @Override
    public boolean isItemValidForMainSlot(ItemStack itemStack) {
        for (IPurifierAction purifyAction : this.registry) {
            if (!purifyAction.isItemValidForMainSlot(itemStack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isItemValidForAdditionalSlot(ItemStack itemStack) {
        for (IPurifierAction purifyAction : this.registry) {
            if (!purifyAction.isItemValidForAdditionalSlot(itemStack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int canWork(TilePurifier tile) {
        for (int i = 0; i < this.registry.size(); ++i) {
            IPurifierAction purifyAction = this.registry.get(i);
            if (!purifyAction.canWork(tile)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean work(int actionId, TilePurifier tile) {
        if (actionId < this.registry.size()) {
            return this.registry.get(actionId).work(tile);
        }
        return true;
    }
}

