/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.tileentity.tickaction.purifier;

import evilcraft.api.tileentity.purifier.IPurifierAction;
import evilcraft.core.config.configurable.ConfigurableEnchantment;
import evilcraft.core.helper.EnchantmentHelpers;
import evilcraft.tileentity.TilePurifier;
import evilcraft.tileentity.tickaction.bloodchest.DamageableItemRepairAction;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ToolBadEnchantPurifyAction
implements IPurifierAction {
    private static final int PURIFY_DURATION = 60;

    @Override
    public boolean isItemValidForMainSlot(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean isItemValidForAdditionalSlot(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean canWork(TilePurifier tile) {
        Iterator iterator;
        if (tile.getPurifyItem() != null && tile.getBucketsFloored() > 0 && (iterator = DamageableItemRepairAction.BAD_ENCHANTS.iterator()).hasNext()) {
            ConfigurableEnchantment enchant = (ConfigurableEnchantment)iterator.next();
            int enchantmentListID = EnchantmentHelpers.doesEnchantApply(tile.getPurifyItem(), enchant.field_77352_x);
            return enchantmentListID >= 0;
        }
        return false;
    }

    @Override
    public boolean work(TilePurifier tile) {
        boolean done = false;
        ItemStack purifyItem = tile.getPurifyItem();
        World world = tile.func_145831_w();
        int tick = tile.getTick();
        for (ConfigurableEnchantment enchant : DamageableItemRepairAction.BAD_ENCHANTS) {
            int enchantmentListID;
            if (done || (enchantmentListID = EnchantmentHelpers.doesEnchantApply(purifyItem, enchant.field_77352_x)) <= -1) continue;
            if (tick >= 60) {
                if (!world.field_72995_K) {
                    int level = EnchantmentHelpers.getEnchantmentLevel(purifyItem, enchantmentListID);
                    EnchantmentHelpers.setEnchantmentLevel(purifyItem, enchantmentListID, level - 1);
                }
                tile.setBuckets(tile.getBucketsFloored() - 1, tile.getBucketsRest());
                done = true;
            }
            if (!world.field_72995_K) continue;
            tile.showEffect();
        }
        return done;
    }
}

