/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.tileentity.tickaction.sanguinaryenvironmentalaccumulator;

import evilcraft.api.recipes.custom.IRecipe;
import evilcraft.block.SanguinaryEnvironmentalAccumulatorConfig;
import evilcraft.core.helper.InventoryHelpers;
import evilcraft.core.recipe.custom.EnvironmentalAccumulatorRecipeComponent;
import evilcraft.core.recipe.custom.EnvironmentalAccumulatorRecipeProperties;
import evilcraft.core.tileentity.tickaction.ITickAction;
import evilcraft.core.tileentity.upgrade.UpgradeSensitiveEvent;
import evilcraft.core.tileentity.upgrade.Upgrades;
import evilcraft.tileentity.TileSanguinaryEnvironmentalAccumulator;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import org.apache.commons.lang3.mutable.MutableInt;

public class AccumulateItemTickAction
implements ITickAction<TileSanguinaryEnvironmentalAccumulator> {
    @Override
    public boolean canTick(TileSanguinaryEnvironmentalAccumulator tile, ItemStack itemStack, int slot, int tick) {
        boolean precondition = false;
        if (tile.func_70301_a(0) != null && tile.canConsume(tile.func_70301_a(0))) {
            ItemStack production = tile.getInventory().func_70301_a(tile.getProduceSlot());
            ItemStack willProduce = this.willProduceItem(tile);
            if (production == null) {
                precondition = true;
            } else if (willProduce != null && production.func_77973_b() == this.willProduceItem(tile).func_77973_b() && production.func_77960_j() == this.willProduceItem(tile).func_77960_j() && production.field_77994_a + willProduce.field_77994_a <= production.func_77976_d()) {
                precondition = true;
            }
        }
        return precondition && tile.canWork() && tile.getVirtualTank().getFluidAmount() >= this.getRequiredFluidAmount(tile, this.getRecipe(tile));
    }

    @Override
    public void onTick(TileSanguinaryEnvironmentalAccumulator tile, ItemStack itemStack, int slot, int tick) {
        IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties> recipe = this.getRecipe(tile);
        if (tick >= this.getRequiredTicks(tile, recipe) && recipe != null && this.addToProduceSlot(tile, recipe.getProperties().getResultOverride().getResult((IBlockAccess)tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, recipe.getOutput().getConditionalItemStack(itemStack)))) {
            tile.getInventory().func_70298_a(tile.getConsumeSlot(), 1);
            tile.getVirtualTank().drain(this.getRequiredFluidAmount(tile, recipe), true);
        }
    }

    @Override
    public final float getRequiredTicks(TileSanguinaryEnvironmentalAccumulator tile, int slot, int tick) {
        MutableInt duration = new MutableInt(this.getUnmodifiedRequiredTicks(tile, slot));
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableInt>(duration, TileSanguinaryEnvironmentalAccumulator.UPGRADEEVENT_SPEED));
        return duration.getValue().intValue();
    }

    public static int getUsage(EnvironmentalAccumulatorRecipeProperties properties) {
        return properties.getCooldownTime() * SanguinaryEnvironmentalAccumulatorConfig.baseUsage;
    }

    protected int getRequiredFluidAmount(TileSanguinaryEnvironmentalAccumulator tile, IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties> recipe) {
        MutableInt amount = new MutableInt(AccumulateItemTickAction.getUsage(recipe.getProperties()));
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableInt>(amount, TileSanguinaryEnvironmentalAccumulator.UPGRADEEVENT_BLOODUSAGE));
        return Math.max(1, amount.getValue());
    }

    private IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties> getRecipe(TileSanguinaryEnvironmentalAccumulator tile) {
        return tile.getRecipe(tile.func_70301_a(0));
    }

    protected int getUnmodifiedRequiredTicks(TileSanguinaryEnvironmentalAccumulator tile, int slot) {
        return this.getUnmodifiedRequiredTicks(tile, this.getRecipe(tile));
    }

    private int getUnmodifiedRequiredTicks(TileSanguinaryEnvironmentalAccumulator tile, IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties> recipe) {
        return recipe.getProperties().getDuration();
    }

    private int getRequiredTicks(TileSanguinaryEnvironmentalAccumulator tile, IRecipe<EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties> recipe) {
        MutableInt duration = new MutableInt(this.getUnmodifiedRequiredTicks(tile, recipe));
        Upgrades.sendEvent(tile, new UpgradeSensitiveEvent<MutableInt>(duration, TileSanguinaryEnvironmentalAccumulator.UPGRADEEVENT_SPEED));
        return duration.getValue();
    }

    protected ItemStack willProduceItem(TileSanguinaryEnvironmentalAccumulator tile) {
        return this.getRecipe(tile).getOutput().getConditionalItemStack(tile.func_70301_a(0));
    }

    public boolean addToProduceSlot(TileSanguinaryEnvironmentalAccumulator tile, ItemStack itemStack) {
        return InventoryHelpers.addToSlot(tile.getInventory(), tile.getProduceSlot(), itemStack);
    }
}

