/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.world.gen.nbt;

import com.google.common.collect.Sets;
import evilcraft.core.helper.MinecraftHelpers;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldSavedData;
import org.apache.commons.lang3.tuple.Pair;

public class DarkTempleData
extends WorldSavedData {
    private Set<Pair<Integer, Integer>> failedLocations;

    public DarkTempleData(String mapName) {
        super(mapName);
        this.initStructureLocations();
    }

    private void initStructureLocations() {
        this.failedLocations = Sets.newHashSet();
    }

    public void addFailedLocation(int chunkX, int chunkZ) {
        this.failedLocations.add((Pair<Integer, Integer>)Pair.of((Object)chunkX, (Object)chunkZ));
        this.func_76186_a(true);
    }

    public boolean isFailed(int chunkX, int chunkZ) {
        return this.failedLocations.contains(Pair.of((Object)chunkX, (Object)chunkZ));
    }

    public void func_76184_a(NBTTagCompound compound) {
        if (!compound.func_74764_b("failedLocations")) {
            return;
        }
        this.initStructureLocations();
        NBTTagList list = compound.func_150295_c("failedLocations", MinecraftHelpers.NBTTag_Types.NBTTagCompound.ordinal());
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound posTag = list.func_150305_b(i);
            this.failedLocations.add((Pair<Integer, Integer>)Pair.of((Object)posTag.func_74762_e("x"), (Object)posTag.func_74762_e("z")));
        }
    }

    public void func_76187_b(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (Pair<Integer, Integer> pos : this.failedLocations) {
            NBTTagCompound posTag = new NBTTagCompound();
            posTag.func_74768_a("x", ((Integer)pos.getLeft()).intValue());
            posTag.func_74768_a("z", ((Integer)pos.getRight()).intValue());
            list.func_74742_a((NBTBase)posTag);
        }
        compound.func_74782_a("failedLocations", (NBTBase)list);
    }
}

