/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.world.gen.structure;

import evilcraft.GeneralConfig;
import evilcraft.api.ILocation;
import evilcraft.block.EnvironmentalAccumulator;
import evilcraft.core.helper.DirectionHelpers;
import evilcraft.core.helper.StairSlabMetadataHelper;
import evilcraft.world.gen.structure.QuarterSymmetricalStructure;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.Direction;
import net.minecraft.util.Facing;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;

public class DarkTempleStructure
extends QuarterSymmetricalStructure {
    private static final int STRUCTURE_HEIGHT = 9;
    private static final int[] CORNER_INC = new int[]{-1, 1};
    private static DarkTempleStructure _instance = null;

    public static DarkTempleStructure getInstance() {
        if (_instance == null) {
            _instance = new DarkTempleStructure();
        }
        return _instance;
    }

    private DarkTempleStructure() {
        super(6, 6);
    }

    private int findGround(World world, int x, int z, int yMin, int yMax) {
        if (yMin <= yMax) {
            for (int height = yMax; height >= yMin; --height) {
                while (height >= yMin && (world.func_147437_c(x, height, z) || !world.func_147437_c(x, height + 1, z))) {
                    --height;
                }
                if (height < yMin || !this.isValidSpot(world, x, height, z)) continue;
                return height;
            }
        }
        return -1;
    }

    private boolean canPlaceStructure(World world, int x, int y, int z) {
        for (int xr = x - 3; xr <= x + 3; ++xr) {
            for (int yr = y; yr <= y + 9; ++yr) {
                for (int zr = z - 3; zr <= z + 3; ++zr) {
                    if (!this.isSolidBlock(world, xr, yr, zr)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isValidSpot(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return this.isSolidBlock(block) || block.isReplaceable((IBlockAccess)world, x, y, z);
    }

    private boolean isSolidBlock(World world, int x, int y, int z) {
        return this.isSolidBlock(world.func_147439_a(x, y, z));
    }

    private boolean isSolidBlock(Block block) {
        Material material = block.func_149688_o();
        return material.func_76220_a() && material.func_76218_k();
    }

    private int getMaxPillarHeightAt(World world, int x, int y, int z) {
        int max = 0;
        int[] nArray = CORNER_INC;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer incX = nArray[i];
            int[] nArray2 = CORNER_INC;
            int n2 = nArray2.length;
            for (int j = 0; j < n2; ++j) {
                Integer incZ = nArray2[j];
                max = Math.max(max, this.getPillarHeightForCornerAt(world, x, y, z, incX, incZ));
            }
        }
        return max;
    }

    private int getPillarHeightForCornerAt(World world, int x, int y, int z, int incX, int incZ) {
        int xx = x + 4 * incX;
        int zz = z + 4 * incZ;
        int res = 0;
        while (!this.isSolidBlock(world, xx, y, zz)) {
            --y;
            ++res;
        }
        return res;
    }

    @Override
    protected void generateLayers() {
        QuarterSymmetricalStructure.BlockWrapper us = new QuarterSymmetricalStructure.BlockWrapper(this, (Block)Blocks.field_150333_U, StairSlabMetadataHelper.getSlabMetadata(StairSlabMetadataHelper.SlabType.STONE, true));
        QuarterSymmetricalStructure.BlockWrapper rs = new QuarterSymmetricalStructure.BlockWrapper(this, (Block)Blocks.field_150333_U);
        QuarterSymmetricalStructure.BlockWrapper ds = new QuarterSymmetricalStructure.BlockWrapper(this, (Block)Blocks.field_150334_T);
        QuarterSymmetricalStructure.BlockWrapper cb = new QuarterSymmetricalStructure.BlockWrapper(this, Blocks.field_150417_aV, StairSlabMetadataHelper.getStoneBrickMetadata(StairSlabMetadataHelper.StoneBrickType.CHISELED));
        QuarterSymmetricalStructure.BlockWrapper sb = new QuarterSymmetricalStructure.BlockWrapper(this, Blocks.field_150417_aV);
        QuarterSymmetricalStructure.BlockWrapper cs = new QuarterSymmetricalStructure.BlockWrapper(this, (Block)Blocks.field_150333_U, StairSlabMetadataHelper.getSlabMetadata(StairSlabMetadataHelper.SlabType.COBBLESTONE, false));
        QuarterSymmetricalStructure.BlockWrapper co = new QuarterSymmetricalStructure.BlockWrapper(this, Blocks.field_150347_e);
        QuarterSymmetricalStructure.BlockWrapper wa = new QuarterSymmetricalStructure.BlockWrapper(this, Blocks.field_150355_j);
        QuarterSymmetricalStructure.BlockWrapper fe = new QuarterSymmetricalStructure.BlockWrapper(this, Blocks.field_150422_aJ);
        QuarterSymmetricalStructure.BlockWrapper to = new QuarterSymmetricalStructure.BlockWrapper(this, Blocks.field_150478_aa);
        QuarterSymmetricalStructure.BlockWrapper cw = new QuarterSymmetricalStructure.BlockWrapper(this, Blocks.field_150463_bK);
        QuarterSymmetricalStructure.BlockWrapper lc = new QuarterSymmetricalStructure.BlockWrapper(this, (Block)Blocks.field_150486_ae, 0, 0.15f);
        lc.action = new QuarterSymmetricalStructure.IBlockAction(){

            @Override
            public void run(World world, ILocation location) {
                Random rand = new Random();
                int[] c = location.getCoordinates();
                world.func_72921_c(c[0], c[1], c[2], 1 + rand.nextInt(4), 2);
                TileEntityChest tile = (TileEntityChest)world.func_147438_o(c[0], c[1], c[2]);
                if (tile != null) {
                    ChestGenHooks info = ChestGenHooks.getInfo((String)"dungeonChest");
                    WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])info.getItems(rand), (IInventory)tile, (int)info.getCount(rand));
                }
            }
        };
        QuarterSymmetricalStructure.BlockWrapper vi = new QuarterSymmetricalStructure.BlockWrapper(this, Blocks.field_150395_bd, 0, 0.3f);
        vi.action = new QuarterSymmetricalStructure.IBlockAction(){

            @Override
            public void run(World world, ILocation location) {
                int[] c = location.getCoordinates();
                for (int side = 2; side < 6; ++side) {
                    if (!Blocks.field_150395_bd.func_149707_d(world, c[0], c[1], c[2], side)) continue;
                    world.func_147465_d(c[0], c[1], c[2], Blocks.field_150395_bd, 1 << Direction.field_71579_d[Facing.field_71588_a[side]], 2);
                }
            }
        };
        QuarterSymmetricalStructure.BlockWrapper ea = new QuarterSymmetricalStructure.BlockWrapper(this, (Block)EnvironmentalAccumulator.getInstance());
        Object o = null;
        this.addLayer(1, new QuarterSymmetricalStructure.BlockWrapper[]{o, o, o, o, vi, o, o, o, o, us, ds, vi, us, us, us, us, us, o, us, us, us, us, o, o, us, us, us, us, o, o, us, us, us, us, o, o});
        this.addLayer(2, new QuarterSymmetricalStructure.BlockWrapper[]{o, o, o, vi, vi, o, o, o, o, cb, cb, vi, sb, sb, sb, sb, cb, vi, ds, co, wa, sb, o, o, co, co, co, sb, o, o, co, co, ds, sb, o, o});
        this.addLayer(3, new QuarterSymmetricalStructure.BlockWrapper[]{o, o, o, o, vi, o, o, o, o, lc, sb, vi, o, o, o, fe, lc, o, rs, o, o, o, o, o, cs, rs, o, o, o, o, ea, cs, rs, o, o, o});
        this.addLayer(4, new QuarterSymmetricalStructure.BlockWrapper[]{o, o, o, o, vi, o, o, o, o, vi, cb, vi, o, o, o, to, vi, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o});
        this.addLayer(5, new QuarterSymmetricalStructure.BlockWrapper[]{us, o, o, o, cw, o, o, o, o, o, sb, cw, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, us});
        this.addLayer(6, new QuarterSymmetricalStructure.BlockWrapper[]{cb, ds, rs, rs, rs, o, co, co, co, co, co, rs, co, co, co, co, co, rs, co, co, co, co, co, rs, co, co, co, co, co, ds, o, co, co, co, co, cb});
        this.addLayer(7, new QuarterSymmetricalStructure.BlockWrapper[]{rs, o, o, o, o, o, cw, o, o, o, o, o, cs, cs, cs, o, o, o, co, co, cs, cs, o, o, co, co, co, cs, o, o, o, co, co, cs, cw, rs});
        this.addLayer(8, new QuarterSymmetricalStructure.BlockWrapper[]{o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, cs, cw, o, o, o, o, o, cs, o, o, o, o});
        this.addLayer(9, new QuarterSymmetricalStructure.BlockWrapper[]{o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, o, to, o, o, o, o, o, o, o, o, o, o});
    }

    @Override
    protected void postBuildCorner(World world, int x, int y, int z, int incX, int incZ) {
        super.postBuildCorner(world, x, y, z, incX, incZ);
        int metadata1 = StairSlabMetadataHelper.getStairMetadata(DirectionHelpers.getForgeDirectionFromXSign(incX), true);
        int metadata2 = StairSlabMetadataHelper.getStairMetadata(DirectionHelpers.getForgeDirectionFromZSing(incZ), true);
        world.func_147465_d(x + 3 * incX, y + 5, z + 4 * incZ, Blocks.field_150446_ar, metadata1, 2);
        world.func_147465_d(x + 4 * incX, y + 5, z + 3 * incZ, Blocks.field_150446_ar, metadata2, 2);
        int xx = x + 4 * incX;
        int zz = z + 4 * incZ;
        int pillarHeight = this.getPillarHeightForCornerAt(world, x, y, z, incX, incZ);
        for (int yOffset = 0; yOffset < pillarHeight; ++yOffset) {
            world.func_147465_d(xx, y - yOffset, zz, Blocks.field_150347_e, 0, 2);
        }
    }

    @Override
    public boolean generate(World world, Random random, int x, int y, int z) {
        int groundHeight = this.findGround(world, x, z, DarkTempleStructure.getMinBuildHeight(), DarkTempleStructure.getMaxBuildHeight());
        while (groundHeight != -1) {
            if (this.canPlaceStructure(world, x, groundHeight + 1, z)) {
                if (this.getMaxPillarHeightAt(world, x, y, z) > GeneralConfig.darkTempleMaxPillarLength) {
                    return false;
                }
                super.generate(world, random, x, groundHeight, z);
                return true;
            }
            groundHeight = this.findGround(world, x, z, DarkTempleStructure.getMinBuildHeight(), groundHeight - 1);
        }
        return false;
    }

    private static int getMinBuildHeight() {
        return GeneralConfig.darkTempleMinHeight;
    }

    private static int getMaxBuildHeight() {
        return GeneralConfig.darkTempleMaxHeight - 9;
    }
}

