/*
 * Decompiled with CFR 0.152.
 */
package evilcraft.world.gen.structure;

import evilcraft.api.ILocation;
import evilcraft.core.algorithm.Location;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public abstract class QuarterSymmetricalStructure {
    private List<Integer> layerHeights = new ArrayList<Integer>();
    private List<BlockWrapper[]> layers = new ArrayList<BlockWrapper[]>();
    protected int quarterWidth;
    protected int quarterHeight;

    public QuarterSymmetricalStructure(int quarterWidth, int quarterHeight) {
        this.quarterWidth = quarterWidth;
        this.quarterHeight = quarterHeight;
        this.generateLayers();
    }

    protected abstract void generateLayers();

    protected void addLayer(int height, BlockWrapper[] layer) {
        this.layerHeights.add(height);
        this.layers.add(layer);
    }

    protected void buildCorner(World world, int x, int y, int z, int incX, int incZ) {
        Random r = new Random();
        for (int i = 0; i < this.layerHeights.size(); ++i) {
            int start;
            int layerHeight = this.layerHeights.get(i);
            BlockWrapper[] layer = this.layers.get(i);
            for (int zr = start = incX == incZ ? 0 : 1; zr < this.quarterHeight; ++zr) {
                for (int xr = start; xr < this.quarterWidth; ++xr) {
                    BlockWrapper wrapper = layer[(this.quarterWidth - xr - 1) * this.quarterHeight + zr];
                    if (wrapper == null || !(wrapper.chance >= r.nextFloat())) continue;
                    world.func_147465_d(x + xr * incX, y + layerHeight, z + zr * incZ, wrapper.block, wrapper.metadata, 2);
                    if (wrapper.action == null) continue;
                    wrapper.action.run(world, new Location(x + xr * incX, y + layerHeight, z + zr * incZ));
                }
            }
        }
        this.postBuildCorner(world, x, y, z, incX, incZ);
    }

    protected void postBuildCorner(World world, int x, int y, int z, int incX, int incZ) {
        for (int i = 0; i < this.layerHeights.size(); ++i) {
            int start;
            int layerHeight = this.layerHeights.get(i);
            BlockWrapper[] layer = this.layers.get(i);
            for (int zr = start = incX == incZ ? 0 : 1; zr < this.quarterHeight; ++zr) {
                for (int xr = start; xr < this.quarterWidth; ++xr) {
                    BlockWrapper wrapper = layer[(this.quarterWidth - xr - 1) * this.quarterHeight + zr];
                    if (wrapper == null || wrapper.action == null || world.func_147439_a(x + xr * incX, y + layerHeight, z + zr * incZ) != wrapper.block) continue;
                    wrapper.action.run(world, new Location(x + xr * incX, y + layerHeight, z + zr * incZ));
                }
            }
        }
    }

    public boolean generate(World world, Random random, int x, int y, int z) {
        this.buildCorner(world, x, y, z, 1, 1);
        this.buildCorner(world, x, y, z, -1, 1);
        this.buildCorner(world, x, y, z, 1, -1);
        this.buildCorner(world, x, y, z, -1, -1);
        return true;
    }

    public static interface IBlockAction {
        public void run(World var1, ILocation var2);
    }

    public class BlockWrapper {
        public Block block;
        public int metadata;
        public float chance = 1.0f;
        public IBlockAction action = null;

        public BlockWrapper(Block block) {
            this(block, 0);
        }

        public BlockWrapper(Block block, int metadata) {
            this.block = block;
            this.metadata = metadata;
        }

        public BlockWrapper(Block block, int metadata, float chance) {
            this.block = block;
            this.metadata = metadata;
            this.chance = chance;
        }
    }
}

