/*
 * Decompiled with CFR 0.152.
 */
package universalteam.flatbedrock.world;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameData;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import universalteam.flatbedrock.custom.CustomDimensionManager;

public class WorldGenFlatBedrock
implements IWorldGenerator {
    public static WorldGenFlatBedrock instance = new WorldGenFlatBedrock();
    protected Map<Integer, CustomDimensionManager.DimensionEntry> dimensions = Maps.newHashMap(CustomDimensionManager.getDimensions());

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (this.canGenerate(world, chunkX, chunkZ)) {
            this.generateWorld(world, chunkX, chunkZ);
        }
    }

    public boolean canGenerate(World world, int chunkX, int chunkZ) {
        return world.field_73011_w.field_76577_b != WorldType.field_77138_c;
    }

    public void generateWorld(World world, int chunkX, int chunkZ) {
        int id = world.field_73011_w.field_76574_g;
        if (this.dimensions.containsKey(id)) {
            CustomDimensionManager.DimensionEntry dimension = this.dimensions.get(id);
            if (dimension.genBottom) {
                this.generateBottom(world, chunkX, chunkZ, (Block)GameData.getBlockRegistry().func_82594_a(dimension.fillBlock));
            }
            if (dimension.genTop) {
                this.generateTop(world, chunkX, chunkZ, (Block)GameData.getBlockRegistry().func_82594_a(dimension.fillBlock));
            }
        }
    }

    public void retroGenerateWorld(World world, int chunkX, int chunkZ) {
        int id = world.field_73011_w.field_76574_g;
        if (this.dimensions.containsKey(id)) {
            CustomDimensionManager.DimensionEntry dimension = this.dimensions.get(id);
            if (dimension.retroGenBottom) {
                this.generateBottom(world, chunkX, chunkZ, (Block)GameData.getBlockRegistry().func_82594_a(dimension.fillBlock));
            }
            if (dimension.retroGenTop) {
                this.generateTop(world, chunkX, chunkZ, (Block)GameData.getBlockRegistry().func_82594_a(dimension.fillBlock));
            }
        }
    }

    public void generateTop(World world, int chunkX, int chunkZ, Block block) {
        for (int blockX = 0; blockX < 16; ++blockX) {
            for (int blockZ = 0; blockZ < 16; ++blockZ) {
                for (int blockY = 126; blockY > 121; --blockY) {
                    if (world.func_147439_a(chunkX * 16 + blockX, blockY, chunkZ * 16 + blockZ) != Blocks.field_150357_h) continue;
                    world.func_147465_d(chunkX * 16 + blockX, blockY, chunkZ * 16 + blockZ, block, 0, 2);
                }
            }
        }
    }

    public void generateBottom(World world, int chunkX, int chunkZ, Block block) {
        for (int blockX = 0; blockX < 16; ++blockX) {
            for (int blockZ = 0; blockZ < 16; ++blockZ) {
                for (int blockY = 5; blockY > 0; --blockY) {
                    if (world.func_147439_a(chunkX * 16 + blockX, blockY, chunkZ * 16 + blockZ) != Blocks.field_150357_h) continue;
                    world.func_147465_d(chunkX * 16 + blockX, blockY, chunkZ * 16 + blockZ, block, 0, 2);
                }
            }
        }
    }
}

