/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui;

import betterquesting.api.client.gui.misc.IVolatileScreen;
import betterquesting.api.storage.BQ_Settings;
import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.client.gui.IScene;
import betterquesting.api2.client.gui.misc.ComparatorGuiDepth;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.popups.PopChoice;
import betterquesting.api2.client.gui.themes.presets.PresetIcon;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.client.BQ_Keybindings;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiContainerCanvas
extends GuiContainer
implements IScene {
    private final List<IGuiPanel> guiPanels = new CopyOnWriteArrayList<IGuiPanel>();
    private final GuiRectangle rootTransform = new GuiRectangle(0, 0, 0, 0, 0);
    private final GuiTransform transform = new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(16, 16, 16, 16), 0);
    private boolean enabled = true;
    private boolean useMargins = true;
    private boolean useDefaultBG = false;
    private boolean isVolatile = false;
    public final GuiScreen parent;
    private IGuiPanel popup = null;
    private boolean[] mBtnState = new boolean[3];

    public GuiContainerCanvas(GuiScreen parent, Container container) {
        super(container);
        this.parent = parent;
    }

    @Override
    public void openPopup(@Nonnull IGuiPanel panel) {
        this.popup = panel;
    }

    @Override
    public void closePopup() {
        this.popup = null;
    }

    @Override
    public IGuiRect getTransform() {
        return this.transform;
    }

    @Override
    @Nonnull
    public List<IGuiPanel> getChildren() {
        return this.guiPanels;
    }

    public GuiContainerCanvas useMargins(boolean enable) {
        this.useMargins = enable;
        return this;
    }

    public GuiContainerCanvas useDefaultBG(boolean enable) {
        this.useDefaultBG = enable;
        return this;
    }

    public GuiContainerCanvas setVolatile(boolean state) {
        this.isVolatile = state;
        return this;
    }

    public final void func_73866_w_() {
        super.func_73866_w_();
        int marginX = 16;
        int marginY = 16;
        if (BQ_Settings.guiWidth > 0) {
            marginX = Math.max(16, (this.field_146294_l - BQ_Settings.guiWidth) / 2);
        }
        if (BQ_Settings.guiHeight > 0) {
            marginY = Math.max(16, (this.field_146295_m - BQ_Settings.guiHeight) / 2);
        }
        this.field_147003_i = marginX;
        this.field_147009_r = marginY;
        this.field_146999_f = this.field_146294_l - marginX * 2;
        this.field_147000_g = this.field_146295_m - marginY * 2;
        this.initPanel();
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    public void initPanel() {
        this.rootTransform.w = this.field_146294_l;
        this.rootTransform.h = this.field_146295_m;
        this.transform.setParent(this.rootTransform);
        if (this.useMargins) {
            int marginX = BQ_Settings.guiWidth <= 0 ? 16 : Math.max(16, (this.field_146294_l - BQ_Settings.guiWidth) / 2);
            int marginY = BQ_Settings.guiHeight <= 0 ? 16 : Math.max(16, (this.field_146295_m - BQ_Settings.guiHeight) / 2);
            this.transform.getPadding().setPadding(marginX, marginY, marginX, marginY);
        } else {
            this.transform.getPadding().setPadding(0, 0, 0, 0);
        }
        this.guiPanels.clear();
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    protected void func_146976_a(float partialTick, int mx, int my) {
        if (this.useDefaultBG) {
            this.func_146276_q_();
        }
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2929);
        this.drawPanel(mx, my, partialTick);
        List<String> tt = this.getTooltip(mx, my);
        if (tt != null && tt.size() > 0) {
            this.drawHoveringText(tt, mx, my, this.field_146289_q);
        }
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    @Deprecated
    public void func_146284_a(GuiButton button) {
    }

    public void func_146274_d() {
        super.func_146274_d();
        int i = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int j = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int k = Mouse.getEventButton();
        int SDX = (int)(-Math.signum(Mouse.getEventDWheel()));
        boolean flag = Mouse.getEventButtonState();
        if (k >= 0 && k < 3 && this.mBtnState[k] != flag) {
            if (flag) {
                this.onMouseClick(i, j, k);
            } else {
                this.onMouseRelease(i, j, k);
            }
            this.mBtnState[k] = flag;
        }
        if (SDX != 0) {
            this.onMouseScroll(i, j, SDX);
        }
    }

    public void func_73869_a(char c, int keyCode) {
        if (keyCode == 1) {
            if (this.isVolatile || this instanceof IVolatileScreen) {
                this.openPopup(new PopChoice(QuestTranslation.translate("betterquesting.gui.closing_warning", new Object[0]) + "\n\n" + QuestTranslation.translate("betterquesting.gui.closing_confirm", new Object[0]), PresetIcon.ICON_NOTICE.getTexture(), this::confirmClose, QuestTranslation.translate("gui.yes", new Object[0]), QuestTranslation.translate("gui.no", new Object[0])));
            } else {
                this.field_146297_k.func_147108_a(null);
                if (this.field_146297_k.field_71462_r == null) {
                    this.field_146297_k.func_71381_h();
                }
            }
            return;
        }
        this.onKeyTyped(c, keyCode);
    }

    @Override
    public void drawPanel(int mx, int my, float partialTick) {
        for (IGuiPanel entry : this.guiPanels) {
            if (!entry.isEnabled()) continue;
            entry.drawPanel(mx, my, partialTick);
        }
        if (this.popup != null && this.popup.isEnabled()) {
            this.popup.drawPanel(mx, my, partialTick);
        }
    }

    @Override
    public boolean onMouseClick(int mx, int my, int click) {
        boolean used = false;
        if (this.popup != null && this.popup.isEnabled()) {
            this.popup.onMouseClick(mx, my, click);
            return true;
        }
        ListIterator<IGuiPanel> pnIter = this.guiPanels.listIterator(this.guiPanels.size());
        while (pnIter.hasPrevious()) {
            IGuiPanel entry = pnIter.previous();
            if (!entry.isEnabled() || !entry.onMouseClick(mx, my, click)) continue;
            used = true;
            break;
        }
        return used;
    }

    @Override
    public boolean onMouseRelease(int mx, int my, int click) {
        boolean used = false;
        if (this.popup != null && this.popup.isEnabled()) {
            this.popup.onMouseRelease(mx, my, click);
            return true;
        }
        ListIterator<IGuiPanel> pnIter = this.guiPanels.listIterator(this.guiPanels.size());
        while (pnIter.hasPrevious()) {
            IGuiPanel entry = pnIter.previous();
            if (!entry.isEnabled() || !entry.onMouseRelease(mx, my, click)) continue;
            used = true;
            break;
        }
        return used;
    }

    @Override
    public boolean onMouseScroll(int mx, int my, int scroll) {
        boolean used = false;
        if (this.popup != null && this.popup.isEnabled()) {
            this.popup.onMouseScroll(mx, my, scroll);
            return true;
        }
        ListIterator<IGuiPanel> pnIter = this.guiPanels.listIterator(this.guiPanels.size());
        while (pnIter.hasPrevious()) {
            IGuiPanel entry = pnIter.previous();
            if (!entry.isEnabled() || !entry.onMouseScroll(mx, my, scroll)) continue;
            used = true;
            break;
        }
        return used;
    }

    @Override
    public boolean onKeyTyped(char c, int keycode) {
        if (!this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d) {
            return false;
        }
        boolean used = false;
        if (this.popup != null && this.popup.isEnabled()) {
            this.popup.onKeyTyped(c, keycode);
            return true;
        }
        ListIterator<IGuiPanel> pnIter = this.guiPanels.listIterator(this.guiPanels.size());
        while (pnIter.hasPrevious()) {
            IGuiPanel entry = pnIter.previous();
            if (!entry.isEnabled() || !entry.onKeyTyped(c, keycode)) continue;
            used = true;
            break;
        }
        if (!(used || BQ_Keybindings.openQuests.func_151463_i() != keycode && this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i() != keycode)) {
            if (this.isVolatile || this instanceof IVolatileScreen) {
                this.openPopup(new PopChoice(QuestTranslation.translate("betterquesting.gui.closing_warning", new Object[0]) + "\n\n" + QuestTranslation.translate("betterquesting.gui.closing_confirm", new Object[0]), PresetIcon.ICON_NOTICE.getTexture(), this::confirmClose, QuestTranslation.translate("gui.yes", new Object[0]), QuestTranslation.translate("gui.no", new Object[0])));
            } else {
                this.field_146297_k.func_147108_a(null);
                if (this.field_146297_k.field_71462_r == null) {
                    this.field_146297_k.func_71381_h();
                }
            }
        }
        return used;
    }

    @Override
    public List<String> getTooltip(int mx, int my) {
        List<String> tt;
        ListIterator<IGuiPanel> pnIter = this.guiPanels.listIterator(this.guiPanels.size());
        if (this.popup != null && this.popup.isEnabled() && (tt = this.popup.getTooltip(mx, my)) != null) {
            return tt;
        }
        while (pnIter.hasPrevious()) {
            IGuiPanel entry = pnIter.previous();
            if (!entry.isEnabled() || (tt = entry.getTooltip(mx, my)) == null || tt.size() <= 0) continue;
            return tt;
        }
        return null;
    }

    @Override
    public void addPanel(IGuiPanel panel) {
        if (panel == null || this.guiPanels.contains(panel)) {
            return;
        }
        this.guiPanels.add(panel);
        this.guiPanels.sort(ComparatorGuiDepth.INSTANCE);
        panel.getTransform().setParent(this.getTransform());
        panel.initPanel();
    }

    @Override
    public boolean removePanel(IGuiPanel panel) {
        return this.guiPanels.remove(panel);
    }

    @Override
    public void resetCanvas() {
        this.guiPanels.clear();
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146285_a(ItemStack stack, int x, int y) {
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        RenderUtils.drawHoveringText(stack, this.getItemToolTip(stack), x, y, this.field_146294_l, this.field_146295_m, -1, font == null ? this.field_146289_q : font);
    }

    private List<String> getItemToolTip(ItemStack stack) {
        List list = stack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x);
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                list.set(i, stack.func_77953_t().field_77937_e + (String)list.get(i));
                continue;
            }
            list.set(i, EnumChatFormatting.GRAY + (String)list.get(i));
        }
        return list;
    }

    protected void drawHoveringText(List textLines, int x, int y, FontRenderer font) {
        RenderUtils.drawHoveringText(textLines, x, y, this.field_146294_l, this.field_146295_m, -1, font);
    }

    public void confirmClose(int id) {
        if (id == 0) {
            this.field_146297_k.func_147108_a(null);
            if (this.field_146297_k.field_71462_r == null) {
                this.field_146297_k.func_71381_h();
            }
        }
    }
}

