/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network.handlers;

import betterquesting.api.network.QuestingPacket;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api2.utils.Tuple2;
import betterquesting.core.BetterQuesting;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeRegistry;
import betterquesting.questing.QuestDatabase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class NetQuestAction {
    private static final ResourceLocation ID_NAME = new ResourceLocation("betterquesting:quest_action");

    public static void registerHandler() {
        PacketTypeRegistry.INSTANCE.registerServerHandler(ID_NAME, NetQuestAction::onServer);
    }

    @SideOnly(value=Side.CLIENT)
    public static void requestClaim(@Nonnull Collection<UUID> questIDs) {
        if (questIDs.isEmpty()) {
            return;
        }
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74768_a("action", 0);
        payload.func_74782_a("questIDs", (NBTBase)NBTConverter.UuidValueType.QUEST.writeIds(questIDs));
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(ID_NAME, payload));
    }

    @SideOnly(value=Side.CLIENT)
    public static void requestDetect(@Nonnull Collection<UUID> questIDs) {
        if (questIDs.isEmpty()) {
            return;
        }
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74768_a("action", 1);
        payload.func_74782_a("questIDs", (NBTBase)NBTConverter.UuidValueType.QUEST.writeIds(questIDs));
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(ID_NAME, payload));
    }

    private static void onServer(Tuple2<NBTTagCompound, EntityPlayerMP> message) {
        int action = !message.func_76341_a().func_150297_b("action", 99) ? -1 : message.func_76341_a().func_74762_e("action");
        Supplier<List> getQuestIDs = () -> NBTConverter.UuidValueType.QUEST.readIds((NBTTagCompound)message.func_76341_a(), "questIDs");
        switch (action) {
            case 0: {
                NetQuestAction.claimQuest(getQuestIDs.get(), message.func_76340_b());
                break;
            }
            case 1: {
                NetQuestAction.detectQuest(getQuestIDs.get(), message.func_76340_b());
                break;
            }
            default: {
                BetterQuesting.logger.log(Level.ERROR, "Invalid quest user action '" + action + "'. Full payload:\n" + message.func_76341_a().toString());
            }
        }
    }

    public static void claimQuest(Collection<UUID> questIDs, EntityPlayerMP player) {
        QuestDatabase.INSTANCE.getAll(questIDs).filter(q -> q.canClaim((EntityPlayer)player)).forEach(q -> q.claimReward((EntityPlayer)player));
    }

    public static void detectQuest(Collection<UUID> questIDs, EntityPlayerMP player) {
        QuestDatabase.INSTANCE.filterKeys(questIDs).values().forEach(q -> q.detect(player));
    }
}

