/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing.rewards;

import betterquesting.api.placeholders.rewards.FactoryRewardPlaceholder;
import betterquesting.api.placeholders.rewards.RewardPlaceholder;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api2.registry.IFactory;
import betterquesting.api2.registry.IFactoryData;
import betterquesting.api2.registry.IRegistry;
import betterquesting.core.BetterQuesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class RewardRegistry
implements IRegistry<IFactoryData<IReward, NBTTagCompound>, IReward> {
    public static final RewardRegistry INSTANCE = new RewardRegistry();
    private final HashMap<ResourceLocation, IFactoryData<IReward, NBTTagCompound>> rewardRegistry = new HashMap();

    @Override
    public void register(IFactoryData<IReward, NBTTagCompound> factory) {
        if (factory == null) {
            throw new NullPointerException("Tried to register null reward");
        }
        if (factory.getRegistryName() == null) {
            throw new IllegalArgumentException("Tried to register a reward with a null name: " + factory.getClass());
        }
        if (this.rewardRegistry.containsKey(factory.getRegistryName()) || this.rewardRegistry.containsValue(factory)) {
            throw new IllegalArgumentException("Cannot register dupliate reward type: " + factory.getRegistryName());
        }
        this.rewardRegistry.put(factory.getRegistryName(), factory);
    }

    @Override
    public IFactoryData<IReward, NBTTagCompound> getFactory(ResourceLocation registryName) {
        return this.rewardRegistry.get(registryName);
    }

    @Override
    public List<IFactoryData<IReward, NBTTagCompound>> getAll() {
        return new ArrayList<IFactoryData<IReward, NBTTagCompound>>(this.rewardRegistry.values());
    }

    @Override
    public IReward createNew(ResourceLocation registryName) {
        try {
            IFactory<RewardPlaceholder> factory = FactoryRewardPlaceholder.INSTANCE.getRegistryName().equals((Object)registryName) ? FactoryRewardPlaceholder.INSTANCE : this.getFactory(registryName);
            if (factory == null) {
                BetterQuesting.logger.log(Level.ERROR, "Tried to load missing reward type '" + registryName + "'! Are you missing an expansion pack?");
                return null;
            }
            return factory.createNew();
        }
        catch (Exception e) {
            BetterQuesting.logger.log(Level.ERROR, "Unable to instatiate reward: " + registryName, (Throwable)e);
            return null;
        }
    }
}

