/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.client.gui.tasks;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api2.client.gui.controls.io.ValueFuncIO;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasMinimum;
import betterquesting.api2.client.gui.panels.bars.PanelHBarFill;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.utils.QuestTranslation;
import bq_standard.tasks.TaskVaultBalance;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;

public class PanelTaskVaultBalance
extends CanvasMinimum {
    private final TaskVaultBalance task;
    private final IGuiRect initialRect;

    public PanelTaskVaultBalance(IGuiRect rect, TaskVaultBalance task) {
        super(rect);
        this.task = task;
        this.initialRect = rect;
    }

    @Override
    public void initPanel() {
        super.initPanel();
        int width = this.initialRect.getWidth();
        float balance = this.task.getUsersProgress(QuestingAPI.getQuestingUUID((EntityPlayer)Minecraft.func_71410_x().field_71439_g)).floatValue();
        float balancePercent = balance / this.task.amount;
        String consume = (this.task.consume ? EnumChatFormatting.RED : EnumChatFormatting.GREEN) + QuestTranslation.translate(this.task.consume ? "gui.yes" : "gui.no", new Object[0]);
        this.addPanel(new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, 0, 0, width, 16, 0), QuestTranslation.translate("bq_standard.btn.consume", consume)).setColor(PresetColor.TEXT_MAIN.getColor()));
        String actionType = QuestTranslation.translate(this.task.consume ? "bq_standard.gui.vaultbalance.deposit" : "bq_standard.gui.vaultbalance.have", new Object[0]);
        this.addPanel(new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, 0, 12, width, 16, 0), String.format("%s: \u00a7a$%.1f", actionType, Float.valueOf(this.task.amount))).setColor(PresetColor.TEXT_MAIN.getColor()));
        int barWidth = Math.min(160, width - 4);
        PanelHBarFill fillBar = new PanelHBarFill(new GuiTransform(GuiAlign.TOP_LEFT, (width - barWidth) / 2, 24, barWidth, 14, 0));
        fillBar.setFillColor(new GuiColorStatic(-16724993));
        fillBar.setFillDriver(new ValueFuncIO<Float>(() -> Float.valueOf(balancePercent)));
        this.addPanel(fillBar);
        this.addPanel(new PanelTextBox(new GuiTransform(GuiAlign.TOP_LEFT, 0, 27, width, 10, -1), String.format("%.1f $", Float.valueOf(balance))).setAlignment(1));
        this.recalcSizes();
    }
}

