/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib3.file;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.util.JsonException;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import software.bernie.geckolib3.GeckoLib;
import software.bernie.geckolib3.core.builder.Animation;
import software.bernie.geckolib3.file.AnimationFile;
import software.bernie.geckolib3.util.json.JsonAnimationUtils;
import software.bernie.libs.eliotlash.molang.MolangParser;

public class AnimationFileLoader {
    public AnimationFile loadAllAnimations(MolangParser parser, ResourceLocation location, IResourceManager manager) {
        AnimationFile animationFile = new AnimationFile();
        JsonObject jsonRepresentation = this.loadFile(location, manager);
        Set<Map.Entry<String, JsonElement>> entrySet = JsonAnimationUtils.getAnimations(jsonRepresentation);
        for (Map.Entry<String, JsonElement> entry : entrySet) {
            String animationName = entry.getKey();
            try {
                Animation animation = JsonAnimationUtils.deserializeJsonToAnimation(JsonAnimationUtils.getAnimation(jsonRepresentation, animationName), parser);
                animationFile.putAnimation(animationName, animation);
            }
            catch (JsonException e) {
                GeckoLib.LOGGER.error("Could not load animation: {}", new Object[]{animationName, e});
                throw new RuntimeException(e);
            }
        }
        return animationFile;
    }

    private JsonObject loadFile(ResourceLocation location, IResourceManager manager) {
        String content = AnimationFileLoader.getResourceAsString(location, manager);
        Gson GSON = new Gson();
        return this.fromJson(GSON, new StringReader(content), JsonObject.class);
    }

    private <G> G fromJson(Gson gson, Reader reader, Class<G> type) {
        try {
            JsonReader jsonreader = new JsonReader(reader);
            jsonreader.setLenient(false);
            return (G)gson.getAdapter(TypeToken.get(type)).read(jsonreader);
        }
        catch (IOException ioexception) {
            throw new JsonParseException((Throwable)ioexception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getResourceAsString(ResourceLocation location, IResourceManager manager) {
        try (InputStream inputStream = manager.func_110536_a(location).func_110527_b();){
            String string = IOUtils.toString((InputStream)inputStream);
            return string;
        }
        catch (Exception e) {
            String message = "Couldn't load " + location;
            GeckoLib.LOGGER.error(message, (Throwable)e);
            throw new RuntimeException(new FileNotFoundException(location.toString()));
        }
    }
}

