/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib3.renderers.geo;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.util.Color;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;

public abstract class GeoBlockRenderer<T extends TileEntity>
extends TileEntitySpecialRenderer
implements IGeoRenderer<T> {
    private final AnimatedGeoModel<T> modelProvider;

    public GeoBlockRenderer(AnimatedGeoModel<T> modelProvider) {
        this.modelProvider = modelProvider;
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float partialTicks) {
        this.render(tile, x, y, z, partialTicks);
    }

    public void render(T tile, double x, double y, double z, float partialTicks) {
        GeoModel model = this.modelProvider.getModel(this.modelProvider.getModelLocation(tile));
        if (model == null) {
            return;
        }
        this.modelProvider.setLivingAnimations(tile, this.getUniqueID(tile));
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glTranslated((double)0.5, (double)0.0, (double)0.5);
        this.rotateBlock(this.getFacing(tile));
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.getTextureLocation(tile));
        Color renderColor = this.getRenderColor(tile, partialTicks);
        this.render(model, tile, partialTicks, (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
        GL11.glPopMatrix();
    }

    @Override
    public AnimatedGeoModel<T> getGeoModelProvider() {
        return this.modelProvider;
    }

    protected void rotateBlock(EnumFacing facing) {
        switch (facing) {
            case SOUTH: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case NORTH: {
                break;
            }
            case EAST: {
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case UP: {
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case DOWN: {
                GL11.glRotatef((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
            }
        }
    }

    private EnumFacing getFacing(T tile) {
        return EnumFacing.NORTH;
    }

    @Override
    public ResourceLocation getTextureLocation(T instance) {
        return this.modelProvider.getTextureLocation(instance);
    }

    static {
        AnimationController.addModelFetcher(object -> {
            TileEntity tile;
            TileEntitySpecialRenderer renderer;
            if (object instanceof TileEntity && (renderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(tile = (TileEntity)object)) instanceof GeoBlockRenderer) {
                return ((GeoBlockRenderer)renderer).getGeoModelProvider();
            }
            return null;
        });
    }
}

