/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib3.renderers.geo;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimatableModel;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.util.Color;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;
import software.bernie.libs.eliotlash.mclib.utils.Interpolations;

public abstract class GeoReplacedEntityRenderer<T extends IAnimatable>
extends Render
implements IGeoRenderer {
    private final AnimatedGeoModel<T> modelProvider;
    private final T animatable;
    private IAnimatable currentAnimatable;
    private static final Map<Class<? extends IAnimatable>, GeoReplacedEntityRenderer<?>> renderers = new ConcurrentHashMap();

    protected GeoReplacedEntityRenderer(AnimatedGeoModel<T> modelProvider, T animatable) {
        this.modelProvider = modelProvider;
        this.animatable = animatable;
        this.func_76976_a(RenderManager.field_78727_a);
    }

    public Integer getUniqueID(Object animatable) {
        return ((Entity)animatable).func_145782_y();
    }

    public static void registerReplacedEntity(Class<? extends IAnimatable> itemClass, GeoReplacedEntityRenderer<?> renderer) {
        renderers.put(itemClass, renderer);
    }

    public static GeoReplacedEntityRenderer<?> getRenderer(Class<? extends IAnimatable> item) {
        return renderers.get(item);
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float entityYaw, float partialTicks) {
        EntityLiving living = (EntityLiving)entity;
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        boolean shouldSit = entity.field_70154_o != null && entity.field_70154_o.shouldRiderSit();
        EntityModelData entityModelData = new EntityModelData();
        entityModelData.isSitting = shouldSit;
        entityModelData.isChild = living.func_70631_g_();
        float f = Interpolations.lerpYaw(living.field_70760_ar, living.field_70761_aq, partialTicks);
        float f1 = Interpolations.lerpYaw(living.field_70758_at, living.field_70759_as, partialTicks);
        float netHeadYaw = f1 - f;
        if (shouldSit && entity.field_70154_o instanceof EntityLivingBase) {
            EntityLivingBase livingentity = (EntityLivingBase)entity.field_70154_o;
            f = Interpolations.lerpYaw(livingentity.field_70760_ar, livingentity.field_70761_aq, partialTicks);
            netHeadYaw = f1 - f;
            float f3 = MathHelper.func_76142_g((float)netHeadYaw);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            netHeadYaw = f1 - f;
        }
        float headPitch = Interpolations.lerp(entity.field_70127_C, entity.field_70125_A, partialTicks);
        float f7 = this.handleRotationFloat((EntityLivingBase)living, partialTicks);
        this.applyRotations((EntityLivingBase)living, f7, f, partialTicks);
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        if (!shouldSit && entity.func_70089_S()) {
            limbSwingAmount = Interpolations.lerp(living.field_70722_aY, living.field_70721_aZ, partialTicks);
            limbSwing = living.field_70754_ba - living.field_70721_aZ * (1.0f - partialTicks);
            if (living.func_70631_g_()) {
                limbSwing *= 3.0f;
            }
            if (limbSwingAmount > 1.0f) {
                limbSwingAmount = 1.0f;
            }
        }
        entityModelData.headPitch = -headPitch;
        entityModelData.netHeadYaw = -netHeadYaw;
        AnimationEvent<T> predicate = new AnimationEvent<T>(this.animatable, limbSwing, limbSwingAmount, partialTicks, !(limbSwingAmount > -0.15f) || !(limbSwingAmount < 0.15f), Collections.singletonList(entityModelData));
        GeoModel model = this.modelProvider.getModel(this.modelProvider.getModelLocation(this.animatable));
        if (model == null) {
            GL11.glPopMatrix();
            return;
        }
        if (this.modelProvider instanceof IAnimatableModel) {
            this.modelProvider.setLivingAnimations(this.animatable, this.getUniqueID(entity), (AnimationEvent)predicate);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.01f, (float)0.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.func_110775_a(entity));
        Color renderColor = this.getRenderColor(entity, partialTicks);
        this.render(model, entity, partialTicks, (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    protected void preRenderCallback(EntityLivingBase entitylivingbaseIn, float partialTickTime) {
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return this.getTextureLocation(this.currentAnimatable);
    }

    public AnimatedGeoModel getGeoModelProvider() {
        return this.modelProvider;
    }

    protected void applyRotations(EntityLivingBase entityLiving, float ageInTicks, float rotationYaw, float partialTicks) {
        String s;
        if (!entityLiving.func_70608_bn()) {
            GL11.glRotatef((float)(180.0f - rotationYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (entityLiving.field_70725_aQ > 0) {
            float f = ((float)entityLiving.field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = MathHelper.func_76129_c((float)f)) > 1.0f) {
                f = 1.0f;
            }
            GL11.glRotatef((float)(f * this.getDeathMaxRotation(entityLiving)), (float)0.0f, (float)0.0f, (float)1.0f);
        } else if (!(!((EntityLiving)entityLiving).func_94056_bM() && !(entityLiving instanceof EntityPlayer) || !(s = EnumChatFormatting.func_110646_a((String)entityLiving.func_70005_c_())).equals("Dinnerbone") && !s.equals("Grumm") || entityLiving instanceof EntityPlayer && ((EntityPlayer)entityLiving).func_82238_cc())) {
            GL11.glTranslatef((float)0.0f, (float)(entityLiving.field_70131_O + 0.1f), (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    protected boolean isVisible(EntityLivingBase livingEntityIn) {
        return !livingEntityIn.func_82150_aj();
    }

    private static float getFacingAngle(EnumFacing facingIn) {
        switch (facingIn) {
            case SOUTH: {
                return 90.0f;
            }
            case NORTH: {
                return 270.0f;
            }
            case EAST: {
                return 180.0f;
            }
        }
        return 0.0f;
    }

    protected float getDeathMaxRotation(EntityLivingBase entityLivingBaseIn) {
        return 90.0f;
    }

    protected float getSwingProgress(EntityLivingBase livingBase, float partialTickTime) {
        return livingBase.func_70678_g(partialTickTime);
    }

    protected float handleRotationFloat(EntityLivingBase livingBase, float partialTicks) {
        return (float)livingBase.field_70173_aa + partialTicks;
    }

    public ResourceLocation getTextureLocation(Object instance) {
        return this.modelProvider.getTextureLocation(this.animatable);
    }

    static {
        AnimationController.addModelFetcher(object -> {
            GeoReplacedEntityRenderer<?> renderer = renderers.get(object.getClass());
            return renderer == null ? null : renderer.getGeoModelProvider();
        });
    }
}

