/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib3.util;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.world.storage.GeckoLibIdTracker;

public class GeckoLibUtil {
    private static final String GECKO_LIB_ID_NBT = "GeckoLibID";

    public static int getIDFromStack(ItemStack stack) {
        if (GeckoLibUtil.stackHasIDTag(stack)) {
            return stack.func_77978_p().func_74762_e(GECKO_LIB_ID_NBT);
        }
        String regName = GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b()).name;
        return Objects.hash(regName, stack.func_77978_p(), stack.field_77994_a);
    }

    public static void writeIDToStack(ItemStack stack, WorldServer world) {
        if (!GeckoLibUtil.stackHasIDTag(stack)) {
            int id = GeckoLibIdTracker.get((World)world).getNextId(GeckoLibIdTracker.Type.ITEM);
            stack.func_77983_a(GECKO_LIB_ID_NBT, (NBTBase)new NBTTagInt(id));
        }
    }

    public static int guaranteeIDForStack(ItemStack stack, WorldServer world) {
        if (!GeckoLibUtil.stackHasIDTag(stack)) {
            int id = GeckoLibIdTracker.get((World)world).getNextId(GeckoLibIdTracker.Type.ITEM);
            stack.func_77983_a(GECKO_LIB_ID_NBT, (NBTBase)new NBTTagInt(id));
            return id;
        }
        return stack.func_77978_p().func_74762_e(GECKO_LIB_ID_NBT);
    }

    public static void removeIDFromStack(ItemStack stack) {
        if (GeckoLibUtil.stackHasIDTag(stack)) {
            stack.func_77978_p().func_82580_o(GECKO_LIB_ID_NBT);
        }
    }

    public static boolean stackHasIDTag(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_150297_b(GECKO_LIB_ID_NBT, 3);
    }

    public static AnimationController getControllerForStack(AnimationFactory factory, ItemStack stack, String controllerName) {
        return GeckoLibUtil.getControllerForID(factory, GeckoLibUtil.getIDFromStack(stack), controllerName);
    }

    public static AnimationController getControllerForID(AnimationFactory factory, Integer id, String controllerName) {
        return factory.getOrCreateAnimationData(id).getAnimationControllers().get(controllerName);
    }
}

