/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.libs.eliotlash.molang;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import software.bernie.libs.eliotlash.mclib.math.Constant;
import software.bernie.libs.eliotlash.mclib.math.IValue;
import software.bernie.libs.eliotlash.mclib.math.MathBuilder;
import software.bernie.libs.eliotlash.mclib.math.Variable;
import software.bernie.libs.eliotlash.molang.MolangException;
import software.bernie.libs.eliotlash.molang.expressions.MolangAssignment;
import software.bernie.libs.eliotlash.molang.expressions.MolangExpression;
import software.bernie.libs.eliotlash.molang.expressions.MolangMultiStatement;
import software.bernie.libs.eliotlash.molang.expressions.MolangValue;
import software.bernie.libs.eliotlash.molang.functions.CosDegrees;
import software.bernie.libs.eliotlash.molang.functions.SinDegrees;

public class MolangParser
extends MathBuilder {
    public static final MolangExpression ZERO = new MolangValue(null, new Constant(0.0));
    public static final MolangExpression ONE = new MolangValue(null, new Constant(1.0));
    public static final String RETURN = "return ";
    private MolangMultiStatement currentStatement;

    public MolangParser() {
        this.functions.put("cos", CosDegrees.class);
        this.functions.put("sin", SinDegrees.class);
        this.remap("abs", "math.abs");
        this.remap("ceil", "math.ceil");
        this.remap("clamp", "math.clamp");
        this.remap("cos", "math.cos");
        this.remap("exp", "math.exp");
        this.remap("floor", "math.floor");
        this.remap("lerp", "math.lerp");
        this.remap("lerprotate", "math.lerprotate");
        this.remap("ln", "math.ln");
        this.remap("max", "math.max");
        this.remap("min", "math.min");
        this.remap("mod", "math.mod");
        this.remap("pow", "math.pow");
        this.remap("random", "math.random");
        this.remap("round", "math.round");
        this.remap("sin", "math.sin");
        this.remap("sqrt", "math.sqrt");
        this.remap("trunc", "math.trunc");
    }

    public void remap(String old, String newName) {
        this.functions.put(newName, this.functions.remove(old));
    }

    public void setValue(String name, double value) {
        Variable variable = this.getVariable(name);
        if (variable != null) {
            variable.set(value);
        }
    }

    @Override
    protected Variable getVariable(String name) {
        Variable variable;
        Variable variable2 = variable = this.currentStatement == null ? null : this.currentStatement.locals.get(name);
        if (variable == null) {
            variable = super.getVariable(name);
        }
        if (variable == null) {
            variable = new Variable(name, 0.0);
            this.register(variable);
        }
        return variable;
    }

    public MolangExpression parseJson(JsonElement element) throws MolangException {
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isString()) {
                try {
                    return new MolangValue(this, new Constant(Float.parseFloat(primitive.getAsString())));
                }
                catch (Exception exception) {
                    return this.parseExpression(primitive.getAsString());
                }
            }
            return new MolangValue(this, new Constant(primitive.getAsDouble()));
        }
        return ZERO;
    }

    public MolangExpression parseExpression(String expression) throws MolangException {
        MolangMultiStatement result;
        ArrayList<String> lines = new ArrayList<String>();
        for (String split : expression.toLowerCase().trim().split(";")) {
            if (split.trim().isEmpty()) continue;
            lines.add(split);
        }
        if (lines.size() == 0) {
            throw new MolangException("Molang expression cannot be blank!");
        }
        this.currentStatement = result = new MolangMultiStatement(this);
        try {
            for (String line : lines) {
                result.expressions.add(this.parseOneLine(line));
            }
        }
        catch (Exception e) {
            this.currentStatement = null;
            throw e;
        }
        this.currentStatement = null;
        return result;
    }

    protected MolangExpression parseOneLine(String expression) throws MolangException {
        if ((expression = expression.trim()).startsWith(RETURN)) {
            try {
                return new MolangValue(this, this.parse(expression.substring(RETURN.length()))).addReturn();
            }
            catch (Exception e) {
                throw new MolangException("Couldn't parse return '" + expression + "' expression!");
            }
        }
        try {
            List<Object> symbols = this.breakdownChars(this.breakdown(expression));
            if (symbols.size() >= 3 && symbols.get(0) instanceof String && this.isVariable(symbols.get(0)) && symbols.get(1).equals("=")) {
                String name = (String)symbols.get(0);
                symbols = symbols.subList(2, symbols.size());
                Variable variable = null;
                if (!this.variables.containsKey(name) && !this.currentStatement.locals.containsKey(name)) {
                    variable = new Variable(name, 0.0);
                    this.currentStatement.locals.put(name, variable);
                } else {
                    variable = this.getVariable(name);
                }
                return new MolangAssignment(this, variable, this.parseSymbolsMolang(symbols));
            }
            return new MolangValue(this, this.parseSymbolsMolang(symbols));
        }
        catch (Exception e) {
            throw new MolangException("Couldn't parse '" + expression + "' expression!");
        }
    }

    private IValue parseSymbolsMolang(List<Object> symbols) throws MolangException {
        try {
            return this.parseSymbols(symbols);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MolangException("Couldn't parse an expression!");
        }
    }

    @Override
    protected boolean isOperator(String s) {
        return super.isOperator(s) || s.equals("=");
    }
}

