/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.api.message.element;

import chylex.hee.api.message.MessageRunner;
import chylex.hee.api.message.element.IntArrayValue;
import chylex.hee.api.message.element.IntValue;
import chylex.hee.api.message.element.ItemStackValue;
import chylex.hee.api.message.element.NbtValue;
import chylex.hee.api.message.element.StringValue;
import chylex.hee.api.message.element.base.Optional;
import chylex.hee.api.message.element.base.PreconditionComposite;
import chylex.hee.system.util.ItemPattern;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ItemPatternValue
extends PreconditionComposite<ItemPattern> {
    public static final ItemPatternValue any() {
        return new ItemPatternValue();
    }

    private ItemPatternValue() {
        this.addCondition("id", StringValue.any());
        this.addCondition("damage", Optional.of(IntArrayValue.condition(IntValue.range(0, Short.MAX_VALUE)), ArrayUtils.EMPTY_INT_ARRAY));
        this.addCondition("tag", Optional.of(NbtValue.any(), new NBTTagCompound()));
    }

    @Override
    public ItemPattern getValue(MessageRunner runner) {
        Pair<String, String> name = ItemStackValue.parseItemName(runner.getString("id"));
        return new ItemPattern().setItemName((String)name.getLeft(), (String)name.getRight()).setDamageValues(runner.getIntArray("damage")).setNBT((NBTTagCompound)runner.getValue("tag"));
    }
}

