/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.block;

import chylex.hee.HardcoreEnderExpansion;
import chylex.hee.entity.block.EntityBlockFallingDragonEgg;
import chylex.hee.entity.block.EntityBlockTempleDragonEgg;
import chylex.hee.entity.fx.FXType;
import chylex.hee.packets.AbstractPacket;
import chylex.hee.packets.PacketPipeline;
import chylex.hee.packets.client.C20Effect;
import chylex.hee.packets.client.C22EffectLine;
import chylex.hee.system.savedata.WorldDataHandler;
import chylex.hee.system.savedata.types.DragonSavefile;
import chylex.hee.system.util.BlockPosM;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDragonEgg;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class BlockDragonEggCustom
extends BlockDragonEgg {
    public BlockDragonEggCustom() {
        this.func_149722_s().func_149752_b(2000.0f).func_149672_a(Block.field_149769_e).func_149715_a(0.125f).func_149663_c("dragonEgg").func_149658_d("dragon_egg");
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        this.fallIfPossible(world, x, y, z);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        if (x == 9 && z == 6 && y == 249 && world.field_73011_w.field_76574_g == 1 && !world.field_72995_K) {
            DragonSavefile save = (DragonSavefile)WorldDataHandler.get(DragonSavefile.class);
            Set<UUID> playersInTemple = save.getPlayersInTemple();
            if (!playersInTemple.isEmpty()) {
                save.setPreventTempleDestruction(true);
                world.func_72838_d((Entity)new EntityBlockTempleDragonEgg(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5));
            }
        } else {
            super.func_149726_b(world, x, y, z);
        }
    }

    private void fallIfPossible(World world, int x, int y, int z) {
        if (BlockFalling.func_149831_e((World)world, (int)x, (int)(y - 1), (int)z) && y >= 0) {
            int checkRange = 32;
            if (!BlockFalling.field_149832_M && world.func_72904_c(x - checkRange, y - checkRange, z - checkRange, x + checkRange, y + checkRange, z + checkRange)) {
                world.func_72838_d((Entity)new EntityBlockFallingDragonEgg(world, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f));
            } else {
                BlockPosM.tmp(x, y, z).setAir(world);
                while (BlockFalling.func_149831_e((World)world, (int)x, (int)(y - 1), (int)z) && y > 0) {
                    --y;
                }
                if (y > 0) {
                    BlockPosM.tmp(x, y, z).setBlock(world, (Block)this, 0, 2);
                }
            }
        }
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        if (player != null && player.func_70093_af() && player.func_70694_bm() != null && player.func_70694_bm().func_77975_n() == EnumAction.block) {
            BlockPosM.tmp(x, y, z).setAir(world);
            this.func_149642_a(world, x, y, z, new ItemStack(Blocks.field_150380_bt));
        } else {
            BlockDragonEggCustom.teleportNearby(world, x, y, z);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        BlockDragonEggCustom.teleportNearby(world, x, y, z);
        return true;
    }

    public void func_149690_a(World world, int x, int y, int z, int meta, float chance, int fortune) {
        BlockDragonEggCustom.teleportNearby(world, x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        BlockDragonEggCustom.teleportNearby(world, x, y, z);
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        return null;
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    public static boolean teleportNearby(World world, int x, int y, int z) {
        if (BlockPosM.tmp(x, y, z).getBlock((IBlockAccess)world) == Blocks.field_150380_bt && !world.field_72995_K) {
            BlockPosM tmpPos = BlockPosM.tmp();
            for (int attempt = 0; attempt < 1000; ++attempt) {
                tmpPos.set(x + world.field_73012_v.nextInt(31) - 15, y + world.field_73012_v.nextInt(15) - 7, z + world.field_73012_v.nextInt(31) - 15);
                if (tmpPos.getMaterial((IBlockAccess)world) != Material.field_151579_a) continue;
                tmpPos.setBlock(world, Blocks.field_150380_bt, tmpPos.getMetadata((IBlockAccess)world), 2);
                PacketPipeline.sendToAllAround(world.field_73011_w.field_76574_g, x, y, z, 64.0, new C22EffectLine(FXType.Line.DRAGON_EGG_TELEPORT, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, (double)tmpPos.x + 0.5, (double)tmpPos.y + 0.5, (double)tmpPos.z + 0.5));
                tmpPos.set(x, y, z).setAir(world);
                return true;
            }
        }
        return false;
    }

    public static boolean teleportEntityToPortal(Entity eggEntity) {
        DragonSavefile file = (DragonSavefile)WorldDataHandler.get(DragonSavefile.class);
        if (file.isDragonDead()) {
            BlockPosM coords = file.getPortalEggLocation();
            WorldServer endWorld = MinecraftServer.func_71276_C().func_71218_a(1);
            if (endWorld == null) {
                HardcoreEnderExpansion.notifications.report("Could not teleport Dragon Egg to the End, world is null.");
            } else if (coords.getBlock((IBlockAccess)endWorld) != Blocks.field_150380_bt) {
                coords.setBlock((World)endWorld, Blocks.field_150380_bt);
                PacketPipeline.sendToAllAround(eggEntity, 64.0, (AbstractPacket)new C20Effect(FXType.Basic.DRAGON_EGG_RESET, eggEntity));
                PacketPipeline.sendToAllAround(endWorld.field_73011_w.field_76574_g, (double)coords.x + 0.5, (double)coords.y + 0.5, (double)coords.z + 0.5, 64.0, new C20Effect(FXType.Basic.DRAGON_EGG_RESET, (double)coords.x + 0.5, (double)coords.y + 0.5, (double)coords.z + 0.5));
                return true;
            }
        }
        return false;
    }
}

