/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity.fx;

import chylex.hee.HardcoreEnderExpansion;
import chylex.hee.block.BlockSpookyLeaves;
import chylex.hee.block.BlockSpookyLog;
import chylex.hee.entity.fx.FXType;
import chylex.hee.entity.item.EntityItemInstabilityOrb;
import chylex.hee.init.BlockList;
import chylex.hee.mechanics.misc.HomelandEndermen;
import chylex.hee.system.util.MathUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public final class FXHandler {
    private static final Random rand = new Random();

    public static void handleBasic(World world, EntityClientPlayerMP player, FXType.Basic fx, double x, double y, double z) {
        switch (fx) {
            case ESSENCE_ALTAR_SMOKE: {
                for (int a = 0; a < 15; ++a) {
                    world.func_72869_a("largesmoke", x + FXHandler.randCenter(0.5), y + 0.6 + rand.nextDouble() * 0.25, z + FXHandler.randCenter(0.5), 0.0, 0.15, 0.0);
                }
                break;
            }
            case LASER_BEAM_DESTROY: {
                String[] particles = new String[]{"largesmoke", "portal", "flame"};
                for (int a = 0; a < 10; ++a) {
                    for (String pt : particles) {
                        world.func_72869_a(pt, x + FXHandler.randCenter(0.5), y + FXHandler.randCenter(0.5), z + FXHandler.randCenter(0.5), 0.0, 0.0, 0.0);
                    }
                }
                break;
            }
            case SPOOKY_LOG_DECAY: {
                ((BlockSpookyLog)BlockList.spooky_log).addDestroyEffectsCustom(world, (int)x, (int)y, (int)z);
                break;
            }
            case SPOOKY_LEAVES_DECAY: {
                ((BlockSpookyLeaves)BlockList.spooky_leaves).addDestroyEffectsCustom(world, (int)x, (int)y, (int)z);
                break;
            }
            case DUNGEON_PUZZLE_BURN: {
                for (int a = 0; a < 6; ++a) {
                    world.func_72869_a("flame", x + FXHandler.randCenter(0.3), y + 0.6 * rand.nextDouble(), z + FXHandler.randCenter(0.3), 0.0, 0.04, 0.0);
                }
                world.func_72908_a(x, y, z, "random.fizz", 0.6f, 2.6f + (rand.nextFloat() - rand.nextFloat()) * 0.8f);
                break;
            }
            case DRAGON_EGG_RESET: {
                for (int a = 0; a < 40; ++a) {
                    world.func_72869_a("smoke", x + FXHandler.randCenter(0.8), y + FXHandler.randCenter(0.8), z + FXHandler.randCenter(0.8), FXHandler.randCenter(0.01), FXHandler.randCenter(0.01), FXHandler.randCenter(0.01));
                    world.func_72869_a("portal", x + FXHandler.randCenter(0.8), y + FXHandler.randCenter(0.8) - 0.5, z + FXHandler.randCenter(0.8), FXHandler.randCenter(2.0), FXHandler.randCenter(2.0), FXHandler.randCenter(2.0));
                }
                world.func_72980_b(x, y, z, "mob.endermen.portal", 1.2f, world.field_73012_v.nextFloat() * 0.05f + 0.85f, false);
                break;
            }
            case GEM_LINK: {
                for (int a = 0; a < 25; ++a) {
                    HardcoreEnderExpansion.fx.portalOrbiting(world, x + 0.5, y + 0.38 + rand.nextDouble() * 0.6, z + 0.5, rand.nextDouble() * 0.045 + 0.015);
                }
                world.func_72980_b(x + 0.5, y + 1.0, z + 0.5, "hardcoreenderexpansion:environment.gem.link", 1.0f, rand.nextFloat() * 0.02f + 0.64f, false);
                break;
            }
            case GEM_TELEPORT_TO: {
                for (int a = 0; a < 25; ++a) {
                    HardcoreEnderExpansion.fx.portalOrbiting(world, x, y + 0.1 + rand.nextDouble() * 1.2, z, rand.nextDouble() * 0.045 + 0.015);
                }
                world.func_72980_b(x, y + 1.63, z, "mob.endermen.portal", 1.2f, world.field_73012_v.nextFloat() * 0.05f + 0.85f, false);
                break;
            }
            case ENDER_PEARL_FREEZE: {
                for (double xx = x - 5.0; xx <= x + 5.0; xx += 1.0) {
                    for (double yy = y - 5.0; yy <= y + 5.0; yy += 1.0) {
                        for (double zz = z - 5.0; zz <= z + 5.0; zz += 1.0) {
                            if (MathUtil.distance(xx - x, yy - y, zz - z) > 5.0) continue;
                            for (int i = 0; i < 2; ++i) {
                                world.func_72869_a("snowballpoof", xx + rand.nextDouble() - 0.5, yy, zz + rand.nextDouble() - 0.5, 0.0, 0.0, 0.0);
                            }
                        }
                    }
                }
                world.func_72980_b(x, y, z, "hardcoreenderexpansion:environment.random.freeze", 1.0f, rand.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case IGNEOUS_ROCK_MELT: {
                for (int a = 0; a < 40; ++a) {
                    HardcoreEnderExpansion.fx.flame(player.field_70170_p, x + FXHandler.randCenter(1.25), y + FXHandler.randCenter(1.25), z + FXHandler.randCenter(1.25), 12 + rand.nextInt(9));
                }
                break;
            }
            case ENDERMAN_BLOODLUST_TRANSFORMATION: {
                for (int a = 0; a < 20; ++a) {
                    world.func_72869_a("largesmoke", x + FXHandler.randCenter(0.3), y + rand.nextDouble() * 2.8, z + FXHandler.randCenter(0.3), 0.0, 0.0, 0.0);
                }
                break;
            }
            case LOUSE_ARMOR_HIT: {
                for (int a = 0; a < 10; ++a) {
                    world.func_72869_a("magicCrit", x + FXHandler.randCenter(0.4), y + rand.nextDouble() * 0.45, z + FXHandler.randCenter(0.4), FXHandler.randCenter(0.2), FXHandler.randCenter(0.2), FXHandler.randCenter(0.2));
                }
                break;
            }
            case HOMELAND_ENDERMAN_TP_OVERWORLD: {
                int a;
                for (a = 0; a < 50; ++a) {
                    HardcoreEnderExpansion.fx.omnipresent("portal", world, x + FXHandler.randCenter(1.0), y + rand.nextDouble() * 2.9, z + FXHandler.randCenter(1.0), FXHandler.randCenter(0.1), FXHandler.randCenter(0.05), FXHandler.randCenter(0.1));
                }
                for (a = 120 + rand.nextInt(30); a > 0; --a) {
                    HardcoreEnderExpansion.fx.omnipresent("portal", world, x + FXHandler.randCenter(1.0), y + rand.nextDouble() * rand.nextDouble() * 60.0, z + FXHandler.randCenter(1.0), FXHandler.randCenter(0.1), FXHandler.randCenter(0.05), FXHandler.randCenter(0.1));
                }
                world.func_72980_b(x, y + 1.0, z, "mob.endermen.portal", 1.0f, 1.0f, false);
                break;
            }
            case FIRE_FIEND_FLAME_ATTACK: {
                for (int a = 0; a < 20; ++a) {
                    HardcoreEnderExpansion.fx.flame(world, x + FXHandler.randCenter(0.9), y + rand.nextDouble() * 1.8, z + FXHandler.randCenter(0.9), 10);
                }
                world.func_72980_b(x, y, z, "random.fizz", 2.0f, 2.2f + (rand.nextFloat() - rand.nextFloat()) * 0.8f, true);
                break;
            }
        }
    }

    public static void handleEntity(World world, EntityClientPlayerMP player, FXType.Entity fx, double x, double y, double z, float width, float height) {
        width *= 0.75f;
        switch (fx) {
            case CHARM_CRITICAL: {
                for (int a = 0; a < 12; ++a) {
                    world.func_72869_a("crit", x + FXHandler.randCenter(width), y + rand.nextDouble() * (double)height, z + FXHandler.randCenter(width), FXHandler.randCenter(0.2), FXHandler.randCenter(0.2), FXHandler.randCenter(0.2));
                }
                break;
            }
            case CHARM_WITCH: {
                for (int a = 0; a < 18; ++a) {
                    world.func_72869_a("witchMagic", x + FXHandler.randCenter(width), y + rand.nextDouble() * (double)height, z + FXHandler.randCenter(width), FXHandler.randCenter(0.1), FXHandler.randCenter(0.1), FXHandler.randCenter(0.1));
                }
                break;
            }
            case CHARM_BLOCK_EFFECT: {
                for (int a = 0; a < 10; ++a) {
                    world.func_72869_a("magicCrit", x + FXHandler.randCenter(width), y + rand.nextDouble() * (double)height * 1.4, z + FXHandler.randCenter(width), FXHandler.randCenter(0.2), FXHandler.randCenter(0.2), FXHandler.randCenter(0.2));
                }
                break;
            }
            case CHARM_LAST_RESORT: {
                int a;
                for (a = 0; a < 35; ++a) {
                    world.func_72869_a("smoke", x + FXHandler.randCenter((double)width * 1.25), y + rand.nextDouble() * (double)height, z + FXHandler.randCenter((double)width * 1.25), FXHandler.randCenter(0.1), FXHandler.randCenter(0.1), FXHandler.randCenter(0.1));
                }
                for (a = 0; a < 75; ++a) {
                    HardcoreEnderExpansion.fx.portalBig(world, x + FXHandler.randCenter((double)width * 1.25), y + rand.nextDouble() * (double)height, z + FXHandler.randCenter((double)width * 1.25), FXHandler.randCenter(0.1), FXHandler.randCenter(0.1), FXHandler.randCenter(0.1), 0.72f + rand.nextFloat() * 0.2f);
                }
                world.func_72980_b(x, y + 0.1, z, "mob.endermen.portal", 1.1f, 1.0f + rand.nextFloat() * 0.1f, false);
                break;
            }
            case GEM_TELEPORT_FROM: {
                for (int a = 0; a < 20; ++a) {
                    world.func_72869_a("largesmoke", x + FXHandler.randCenter((double)width * 1.2), y + rand.nextDouble() * (double)height * 0.9, z + FXHandler.randCenter((double)width * 1.2), 0.0, 0.04, 0.0);
                }
                world.func_72980_b(x, y + 1.0, z, "mob.endermen.portal", 1.2f, rand.nextFloat() * 0.05f + 0.85f, false);
                break;
            }
            case ORB_TRANSFORMATION: {
                for (int a = 0; a < 18; ++a) {
                    world.func_72869_a("largesmoke", x + FXHandler.randCenter(width), y + 0.1 + rand.nextDouble() * (double)height, z + FXHandler.randCenter(width), 0.0, 0.0, 0.0);
                }
                world.func_72980_b(x, y, z, "hardcoreenderexpansion:block.random.transform", 1.4f, 1.0f + rand.nextFloat() * 0.2f, false);
                break;
            }
            case ORB_EXPLOSION: {
                EntityItemInstabilityOrb.ExplosionOrb explosion = new EntityItemInstabilityOrb.ExplosionOrb(world, null, x, y, z, height);
                explosion.func_77278_a();
                explosion.func_77279_a(true);
                break;
            }
            case LOUSE_REGEN: {
                for (int a = 0; a < 6; ++a) {
                    HardcoreEnderExpansion.fx.aura(world, x + FXHandler.randCenter(width), y + rand.nextDouble() * (double)height, z + FXHandler.randCenter(width), 0.0f, 0.7f, 0.0f, 14 + rand.nextInt(10));
                }
                break;
            }
            case HOMELAND_ENDERMAN_RECRUIT: {
                int a;
                for (a = 0; a < 25; ++a) {
                    HardcoreEnderExpansion.fx.omnipresent("smoke", world, x + FXHandler.randCenter(width), y + rand.nextDouble() * (double)height, z + FXHandler.randCenter(width), FXHandler.randCenter(0.05), FXHandler.randCenter(0.05), FXHandler.randCenter(0.05));
                }
                for (a = 0; a < 8; ++a) {
                    HardcoreEnderExpansion.fx.omnipresent("largesmoke", world, x + FXHandler.randCenter(width), y + rand.nextDouble() * (double)height, z + FXHandler.randCenter(width), FXHandler.randCenter(0.05), FXHandler.randCenter(0.05), FXHandler.randCenter(0.05));
                }
                break;
            }
            case BABY_ENDERMAN_GROW: {
                int a;
                for (a = 0; a < 20; ++a) {
                    HardcoreEnderExpansion.fx.omnipresent("smoke", world, x + FXHandler.randCenter(width), y + rand.nextDouble() * (double)height, z + FXHandler.randCenter(width), FXHandler.randCenter(0.05), FXHandler.randCenter(0.05), FXHandler.randCenter(0.05));
                }
                for (a = 0; a < 20; ++a) {
                    HardcoreEnderExpansion.fx.omnipresent("portal", world, x + FXHandler.randCenter(width), y + rand.nextDouble() * (double)height, z + FXHandler.randCenter(width), FXHandler.randCenter(0.1), FXHandler.randCenter(0.1), FXHandler.randCenter(0.1));
                }
                break;
            }
            case ENDER_GUARDIAN_DASH: {
                for (int a = 0; a < 50; ++a) {
                    HardcoreEnderExpansion.fx.portalBig(world, x + FXHandler.randCenter(width), y + rand.nextDouble() * (double)height, z + FXHandler.randCenter(width), FXHandler.randCenter(0.3), FXHandler.randCenter(0.3), FXHandler.randCenter(0.3), 0.5f + rand.nextFloat() * 0.4f);
                }
                break;
            }
            case SIMPLE_TELEPORT: 
            case SIMPLE_TELEPORT_NOSOUND: {
                for (int a = 0; a < 30; ++a) {
                    HardcoreEnderExpansion.fx.omnipresent("portal", world, x + FXHandler.randCenter(width), y + rand.nextDouble() * (double)height, z + FXHandler.randCenter(width), FXHandler.randCenter(0.15), FXHandler.randCenter(0.15), FXHandler.randCenter(0.15));
                }
                if (fx == FXType.Entity.SIMPLE_TELEPORT_NOSOUND) break;
                world.func_72980_b(x, y, z, "mob.endermen.portal", 1.0f, 1.0f, false);
                break;
            }
            case SANCTUARY_OVERSEER_SINGLE: {
                for (int a = 0; a < 20; ++a) {
                    HardcoreEnderExpansion.fx.portalBig(world, x + FXHandler.randCenter((double)width * 2.0), y + rand.nextDouble() * (double)height, z + FXHandler.randCenter((double)width * 2.0), FXHandler.randCenter(0.5), FXHandler.randCenter(0.5), FXHandler.randCenter(0.5));
                }
                break;
            }
        }
    }

    public static void handleLine(World world, EntityClientPlayerMP player, FXType.Line fx, double x1, double y1, double z1, double x2, double y2, double z2) {
        Vec3 lineVec = Vec3.func_72443_a((double)(x2 - x1), (double)(y2 - y1), (double)(z2 - z1));
        double len = lineVec.func_72433_c();
        lineVec = lineVec.func_72432_b();
        switch (fx) {
            case CHARM_SLAUGHTER_IMPACT: 
            case CHARM_DAMAGE_REDIRECTION: {
                double addX = lineVec.field_72450_a * 0.5;
                double addY = lineVec.field_72448_b * 0.5;
                double addZ = lineVec.field_72449_c * 0.5;
                float red = 0.0f;
                float green = 0.0f;
                float blue = 0.0f;
                if (fx == FXType.Line.CHARM_SLAUGHTER_IMPACT) {
                    red = 1.0f;
                    green = 0.25f;
                    blue = 0.4f;
                } else if (fx == FXType.Line.CHARM_DAMAGE_REDIRECTION) {
                    red = 0.3f;
                    green = 0.5f;
                    blue = 1.0f;
                }
                int a = 0;
                while ((double)a < len * 2.0) {
                    for (int b = 0; b < 3; ++b) {
                        HardcoreEnderExpansion.fx.magicCrit(world, x1 + FXHandler.randCenter(0.4), y1 + 0.2 + FXHandler.randCenter(0.4), z1 + FXHandler.randCenter(0.4), FXHandler.randCenter(0.1), FXHandler.randCenter(0.1), FXHandler.randCenter(0.1), red, green, blue);
                    }
                    x1 += addX;
                    y1 += addY;
                    z1 += addZ;
                    ++a;
                }
                break;
            }
            case DRAGON_EGG_TELEPORT: {
                int a;
                double addX = lineVec.field_72450_a * 0.25;
                double addY = lineVec.field_72448_b * 0.25;
                double addZ = lineVec.field_72449_c * 0.25;
                for (a = 0; a < 35; ++a) {
                    world.func_72869_a("smoke", x1 + FXHandler.randCenter(0.8), y1 + FXHandler.randCenter(0.8), z1 + FXHandler.randCenter(0.8), FXHandler.randCenter(0.01), FXHandler.randCenter(0.01), FXHandler.randCenter(0.01));
                }
                a = 0;
                while ((double)a < len * 4.0) {
                    for (int b = 0; b < 4; ++b) {
                        HardcoreEnderExpansion.fx.portalBig(world, x1, y1, z1, FXHandler.randCenter(0.01), FXHandler.randCenter(0.01), FXHandler.randCenter(0.01), 0.15f);
                    }
                    x1 += addX;
                    y1 += addY;
                    z1 += addZ;
                    ++a;
                }
                world.func_72980_b(x1, y1, z1, "mob.endermen.portal", 1.2f, 1.0f, false);
                break;
            }
            case SPATIAL_DASH_MOVE: {
                double addX = lineVec.field_72450_a * 0.2;
                double addY = lineVec.field_72448_b * 0.2;
                double addZ = lineVec.field_72449_c * 0.2;
                int a = 0;
                while ((double)a < len * 5.0) {
                    double dist = player.func_70092_e(x1, y1, z1);
                    if (!(dist > 600.0) || !rand.nextBoolean()) {
                        if (dist < 180.0) {
                            HardcoreEnderExpansion.fx.spatialDash(world, x1, y1, z1);
                        }
                        HardcoreEnderExpansion.fx.spatialDash(world, x1, y1, z1);
                        x1 += addX;
                        y1 += addY;
                        z1 += addZ;
                    }
                    ++a;
                }
                break;
            }
            case LOUSE_HEAL_ENTITY: {
                double addX = lineVec.field_72450_a * 0.125;
                double addY = lineVec.field_72448_b * 0.125;
                double addZ = lineVec.field_72449_c * 0.125;
                int a = 0;
                while ((double)a < len * 8.0) {
                    HardcoreEnderExpansion.fx.aura(world, x1 + FXHandler.randCenter(0.1), y1 + FXHandler.randCenter(0.1), z1 + FXHandler.randCenter(0.1), 0.0f, 0.7f, 0.0f, 20 + rand.nextInt(20));
                    x1 += addX;
                    y1 += addY;
                    z1 += addZ;
                    ++a;
                }
                break;
            }
            case ENDERMAN_TELEPORT: 
            case DUNGEON_PUZZLE_TELEPORT: {
                int particleAmt;
                double mp = fx == FXType.Line.DUNGEON_PUZZLE_TELEPORT ? 1.6 : 1.2;
                double height = fx == FXType.Line.DUNGEON_PUZZLE_TELEPORT ? 1.8 : 2.9;
                int n = particleAmt = fx == FXType.Line.DUNGEON_PUZZLE_TELEPORT ? 256 : 128;
                for (int a = 0; a < particleAmt; ++a) {
                    double linePosition = (double)a / ((double)particleAmt - 1.0);
                    double particleX = x1 + (x2 - x1) * linePosition + (rand.nextDouble() - 0.5) * mp;
                    double particleY = y1 + (y2 - y1) * linePosition + rand.nextDouble() * height;
                    double particleZ = z1 + (z2 - z1) * linePosition + (rand.nextDouble() - 0.5) * mp;
                    world.func_72869_a("portal", particleX, particleY, particleZ, (double)((rand.nextFloat() - 0.5f) * 0.2f), (double)((rand.nextFloat() - 0.5f) * 0.2f), (double)((rand.nextFloat() - 0.5f) * 0.2f));
                }
                world.func_72980_b(x1, y1, z1, "mob.endermen.portal", 1.0f, 1.0f, false);
                world.func_72980_b(x2, y2, z2, "mob.endermen.portal", 1.0f, 1.0f, false);
                break;
            }
            case HOMELAND_ENDERMAN_GUARD_CALL: {
                double addX = lineVec.field_72450_a * 0.25;
                double addY = lineVec.field_72448_b * 0.25;
                double addZ = lineVec.field_72449_c * 0.25;
                HomelandEndermen.HomelandRole role = HomelandEndermen.HomelandRole.GUARD;
                int a = 0;
                while ((double)a < len * 4.0) {
                    if (rand.nextBoolean()) {
                        HardcoreEnderExpansion.fx.portalColor(world, x1 + FXHandler.randCenter(0.25), y1 + FXHandler.randCenter(0.25), z1 + FXHandler.randCenter(0.25), FXHandler.randCenter(1.0), -rand.nextDouble(), FXHandler.randCenter(1.0), role.red, role.green, role.blue);
                    }
                    x1 += addX;
                    y1 += addY;
                    z1 += addZ;
                    ++a;
                }
                break;
            }
            case FIRE_FIEND_GOLEM_CALL: {
                double addX = lineVec.field_72450_a * 0.5;
                double addY = lineVec.field_72448_b * 0.5;
                double addZ = lineVec.field_72449_c * 0.5;
                int a = 0;
                while ((double)a < len * 2.0) {
                    if (rand.nextBoolean()) {
                        HardcoreEnderExpansion.fx.flame(world, x1 + FXHandler.randCenter(0.1), y1 + FXHandler.randCenter(0.1), z1 + FXHandler.randCenter(0.1), FXHandler.randCenter(0.1), FXHandler.randCenter(0.1), FXHandler.randCenter(0.1), 12);
                    }
                    x1 += addX;
                    y1 += addY;
                    z1 += addZ;
                    ++a;
                }
                break;
            }
            case SANCTUARY_OVERSEER_FULL: {
                int x = (int)Math.min(x1, x2);
                while ((double)x <= Math.max(x1, x2)) {
                    int y = (int)Math.min(y1, y2);
                    while ((double)y <= Math.max(y1, y2)) {
                        int z = (int)Math.min(z1, z2);
                        while ((double)z <= Math.max(z1, z2)) {
                            HardcoreEnderExpansion.fx.corruptedEnergy(world, x, y, z);
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                break;
            }
        }
    }

    private static double randCenter(double mp) {
        return (rand.nextDouble() - 0.5) * 2.0 * mp;
    }
}

