/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity.mob;

import chylex.hee.entity.GlobalMobData;
import chylex.hee.entity.fx.FXType;
import chylex.hee.init.ItemList;
import chylex.hee.mechanics.causatum.CausatumMeters;
import chylex.hee.mechanics.causatum.CausatumUtils;
import chylex.hee.mechanics.charms.RuneType;
import chylex.hee.packets.AbstractPacket;
import chylex.hee.packets.PacketPipeline;
import chylex.hee.packets.client.C20Effect;
import chylex.hee.packets.client.C21EffectEntity;
import chylex.hee.packets.client.C22EffectLine;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.MathUtil;
import chylex.hee.tileentity.spawner.LouseRavagedSpawnerLogic;
import java.util.List;
import java.util.Set;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class EntityMobLouse
extends EntityMob
implements GlobalMobData.IIgnoreEnderGoo {
    private LouseRavagedSpawnerLogic.LouseSpawnData louseData;
    private float armor;
    private byte armorCapacity;
    private byte armorRegenTimer;
    private byte regenLevel;
    private byte regenTimer;
    private byte healAbility;
    private byte healTimer;
    private byte teleportTimer;

    public EntityMobLouse(World world) {
        super(world);
        this.func_70105_a(1.1f, 0.45f);
    }

    public EntityMobLouse(World world, LouseRavagedSpawnerLogic.LouseSpawnData louseData) {
        this(world);
        this.louseData = louseData;
        this.updateLouseData();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)"");
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.updateLouseData();
    }

    protected boolean func_70650_aV() {
        return false;
    }

    private void updateLouseData() {
        if (this.field_70170_p == null || this.field_70170_p.field_72995_K || this.louseData == null) {
            return;
        }
        int attrHealth = this.louseData.attribute(LouseRavagedSpawnerLogic.LouseSpawnData.EnumLouseAttribute.HEALTH);
        int attrSpeed = this.louseData.attribute(LouseRavagedSpawnerLogic.LouseSpawnData.EnumLouseAttribute.SPEED);
        int attrArmor = this.louseData.attribute(LouseRavagedSpawnerLogic.LouseSpawnData.EnumLouseAttribute.ARMOR);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(14.0 + (attrHealth > 0 ? 10.0 + 8.0 * (double)attrHealth : 0.0));
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.7 + (attrSpeed > 0 ? 0.1 + 0.07 * (double)attrSpeed : 0.0));
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0 + 3.5 * (double)this.louseData.attribute(LouseRavagedSpawnerLogic.LouseSpawnData.EnumLouseAttribute.ATTACK));
        this.func_70606_j(this.func_110138_aP());
        if (attrArmor > 0) {
            this.armorCapacity = (byte)(8 + MathUtil.square(attrArmor) + attrArmor * 5);
            this.armor = this.armorCapacity;
        }
        this.healAbility = (byte)this.louseData.ability(LouseRavagedSpawnerLogic.LouseSpawnData.EnumLouseAbility.HEAL);
        this.regenLevel = (byte)attrHealth;
        this.field_70180_af.func_75692_b(16, (Object)this.louseData.serializeToString());
    }

    protected Entity func_70782_k() {
        return this.field_70170_p.func_72856_b((Entity)this, 12.0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.louseData == null) {
            if (this.field_70170_p.field_72995_K) {
                String data = this.field_70180_af.func_75681_e(16);
                if (!data.isEmpty()) {
                    this.louseData = new LouseRavagedSpawnerLogic.LouseSpawnData(data);
                }
            } else {
                this.louseData = new LouseRavagedSpawnerLogic.LouseSpawnData((byte)this.field_70146_Z.nextInt(3), this.func_70681_au());
                this.updateLouseData();
            }
        }
        if (this.armorCapacity > 0) {
            if (this.armorRegenTimer > 0) {
                this.armorRegenTimer = (byte)(this.armorRegenTimer - 1);
            } else if (this.armor < (float)this.armorCapacity) {
                float f;
                this.armor += 1.0f;
                if (f >= (float)this.armorCapacity) {
                    this.armor = this.armorCapacity;
                } else {
                    this.armorRegenTimer = (byte)(10 - 2 * this.louseData.attribute(LouseRavagedSpawnerLogic.LouseSpawnData.EnumLouseAttribute.ARMOR));
                }
            }
        }
        if (this.teleportTimer > 0) {
            this.teleportTimer = (byte)(this.teleportTimer - 1);
        }
        if (this.regenLevel > 1 && this.func_110143_aJ() < this.func_110138_aP() && (this.regenTimer = (byte)(this.regenTimer + 1)) >= 32 - 8 * this.regenLevel && !this.field_70128_L) {
            this.func_70606_j(this.func_110143_aJ() + 1.0f);
            this.regenTimer = 0;
            PacketPipeline.sendToAllAround((Entity)this, 64.0, (AbstractPacket)new C21EffectEntity(FXType.Entity.LOUSE_REGEN, (Entity)this));
        }
        if (this.healAbility > 0 && (this.healTimer = (byte)(this.healTimer - 1)) <= 0) {
            this.healTimer = (byte)25;
            List list = this.field_70170_p.func_72872_a(EntityLiving.class, this.field_70121_D.func_72314_b(5.0, 1.0, 5.0));
            if (!list.isEmpty()) {
                int amt = list.size();
                for (int attempt = 0; attempt < 15; ++attempt) {
                    EntityLiving entity = (EntityLiving)list.get(this.field_70146_Z.nextInt(amt));
                    if (!(entity.func_110143_aJ() < entity.func_110138_aP()) || entity.field_70128_L) continue;
                    entity.func_70606_j(entity.func_110143_aJ() + 1.0f + (float)(2 * this.healAbility));
                    PacketPipeline.sendToAllAround((Entity)this, 64.0, (AbstractPacket)new C22EffectLine(FXType.Line.LOUSE_HEAL_ENTITY, (Entity)this, (Entity)entity));
                    break;
                }
            }
        }
        if (this.field_70789_a != null && this.field_70789_a.field_70163_u > this.field_70163_u + 1.3 && MathUtil.distance(this.field_70165_t - this.field_70789_a.field_70165_t, this.field_70161_v - this.field_70789_a.field_70161_v) <= 3.0 && ((double)this.func_70032_d(this.field_70789_a) < 8.0 || this.func_70685_l(this.field_70789_a))) {
            this.func_70664_aZ();
        }
    }

    public boolean func_70652_k(Entity entity) {
        float dmgAmount = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        if (entity instanceof EntityLivingBase) {
            dmgAmount += EnchantmentHelper.func_77512_a((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity));
        }
        if (entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), dmgAmount)) {
            int magicDamage;
            int knockback = this.louseData.ability(LouseRavagedSpawnerLogic.LouseSpawnData.EnumLouseAbility.KNOCKBACK);
            if (knockback > 0) {
                entity.func_70024_g((double)(-MathHelper.func_76126_a((float)MathUtil.toRad(this.field_70177_z)) * (float)knockback * 1.25f), 0.1, (double)(MathHelper.func_76134_b((float)MathUtil.toRad(this.field_70177_z)) * (float)knockback * 1.25f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((magicDamage = this.louseData.ability(LouseRavagedSpawnerLogic.LouseSpawnData.EnumLouseAbility.MAGICDMG)) > 0) {
                entity.field_70172_ad = 0;
                entity.func_70097_a(DamageSource.field_76376_m, 1.0f + 2.0f * (float)(magicDamage - 1));
            }
            if (entity instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)entity), (Entity)this);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)entity);
            return true;
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.louseData == null) {
            return false;
        }
        int teleportLevel = this.louseData.attribute(LouseRavagedSpawnerLogic.LouseSpawnData.EnumLouseAttribute.TELEPORT);
        if (teleportLevel > 0 && this.teleportTimer == 0) {
            this.teleport(teleportLevel);
            return false;
        }
        this.healTimer = (byte)45;
        this.armorRegenTimer = (byte)(100 - this.louseData.attribute(LouseRavagedSpawnerLogic.LouseSpawnData.EnumLouseAttribute.ARMOR) * 15);
        if (this.armor > 0.0f && this.field_70172_ad == 0) {
            float f;
            this.field_70789_a = source.func_76346_g();
            this.func_85030_a("random.anvil_land", 0.5f, 1.2f);
            PacketPipeline.sendToAllAround((Entity)this, 64.0, (AbstractPacket)new C20Effect(FXType.Basic.LOUSE_ARMOR_HIT, (Entity)this));
            this.armor -= amount;
            if (f <= 0.0f) {
                this.armor = 0.0f;
            }
            this.field_70738_aO = 10;
            this.field_70737_aN = 10;
            this.field_70172_ad = 10;
            return true;
        }
        if (super.func_70097_a(source, amount)) {
            CausatumUtils.increase(source, CausatumMeters.END_MOB_DAMAGE, amount * 0.25f);
            return true;
        }
        return false;
    }

    private void teleport(int level) {
        this.teleportTimer = (byte)(80 - level * 10);
        if (this.field_70170_p.field_72995_K) {
            for (int a = 0; a < 64; ++a) {
                this.field_70170_p.func_72869_a("portal", this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N, (double)((this.field_70146_Z.nextFloat() - 0.5f) * 0.2f), (double)((this.field_70146_Z.nextFloat() - 0.5f) * 0.2f), (double)((this.field_70146_Z.nextFloat() - 0.5f) * 0.2f));
            }
            return;
        }
        double oldPosX = this.field_70165_t;
        double oldPosY = this.field_70163_u;
        double oldPosZ = this.field_70161_v;
        int maxDist = 3 + level;
        boolean hasTeleported = false;
        BlockPosM tmpPos = BlockPosM.tmp();
        BlockPosM testPos = new BlockPosM();
        block1: for (int attempt = 0; attempt < 32 && !hasTeleported; ++attempt) {
            this.field_70165_t = oldPosX + (double)this.field_70146_Z.nextInt(maxDist) - (double)this.field_70146_Z.nextInt(maxDist);
            this.field_70163_u = oldPosY + 1.0;
            this.field_70161_v = oldPosZ + (double)this.field_70146_Z.nextInt(maxDist) - (double)this.field_70146_Z.nextInt(maxDist);
            if (MathUtil.distance(this.field_70165_t - oldPosX, this.field_70161_v - oldPosZ) < 2.0) continue;
            tmpPos.set((Entity)this);
            for (int py = 0; py < 3; ++py) {
                if (tmpPos.isAir(this.field_70170_p) && !testPos.set(tmpPos).moveDown().isAir(this.field_70170_p)) {
                    this.func_70107_b(this.field_70165_t, this.field_70163_u + 0.1, this.field_70161_v);
                    hasTeleported = true;
                    continue block1;
                }
                tmpPos.y = MathUtil.floor(this.field_70163_u -= 1.0);
            }
        }
        if (!hasTeleported) {
            return;
        }
        for (int a = 0; a < 64; ++a) {
            this.field_70170_p.func_72869_a("portal", oldPosX + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N, oldPosY + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, oldPosZ + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N, (double)((this.field_70146_Z.nextFloat() - 0.5f) * 0.2f), (double)((this.field_70146_Z.nextFloat() - 0.5f) * 0.2f), (double)((this.field_70146_Z.nextFloat() - 0.5f) * 0.2f));
        }
        this.field_70170_p.func_72908_a(oldPosX, oldPosY, oldPosZ, "mob.endermen.portal", 1.0f, 1.0f);
        this.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
    }

    protected void func_70664_aZ() {
        this.field_70181_x = 0.5;
        if (this.func_70644_a(Potion.field_76430_j)) {
            this.field_70181_x += (double)((float)(this.func_70660_b(Potion.field_76430_j).func_76458_c() + 1) * 0.1f);
        }
        this.field_70160_al = true;
        ForgeHooks.onLivingJump((EntityLivingBase)this);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.louseData != null) {
            nbt.func_74782_a("louseData", (NBTBase)this.louseData.writeToNBT(new NBTTagCompound()));
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("louseData")) {
            this.louseData = new LouseRavagedSpawnerLogic.LouseSpawnData(nbt.func_74775_l("louseData"));
        }
        this.updateLouseData();
    }

    protected void func_70600_l(int lootingExtraLuck) {
        int nearbyLice = this.field_70170_p.func_72872_a(EntityMobLouse.class, this.field_70121_D.func_72314_b(4.0, 4.0, 4.0)).size();
        if (this.field_70146_Z.nextInt(1 + (nearbyLice >> 3)) == 0) {
            Set<LouseRavagedSpawnerLogic.LouseSpawnData.EnumLouseAttribute> attributes = this.louseData.getAttributeSet();
            Set<LouseRavagedSpawnerLogic.LouseSpawnData.EnumLouseAbility> abilities = this.louseData.getAbilitySet();
            if (!abilities.isEmpty() && this.field_70146_Z.nextBoolean()) {
                this.func_70099_a(new ItemStack(ItemList.rune, 1, RuneType.VOID.ordinal()), 0.0f);
            } else if (!attributes.isEmpty()) {
                int n = this.field_70146_Z.nextInt(attributes.size());
                for (LouseRavagedSpawnerLogic.LouseSpawnData.EnumLouseAttribute attribute : attributes) {
                    if (--n >= 0) continue;
                    this.func_70099_a(new ItemStack(ItemList.rune, 1, attribute.ordinal()), 0.0f);
                    break;
                }
            }
        }
    }

    protected String func_70621_aR() {
        return "hardcoreenderexpansion:mob.louse.hit";
    }

    protected String func_70673_aS() {
        return "hardcoreenderexpansion:mob.louse.hit";
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    protected boolean func_70814_o() {
        return true;
    }

    public String func_70005_c_() {
        return this.func_94056_bM() ? this.func_94057_bL() : StatCollector.func_74838_a((String)"entity.louse.name");
    }

    public LouseRavagedSpawnerLogic.LouseSpawnData getSpawnData() {
        return this.louseData;
    }
}

