/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.game.creativetab;

import chylex.hee.game.creativetab.ModCreativeTab;
import chylex.hee.init.ModInitHandler;
import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.registry.RegistryDelegate;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class CreativeTabItemList {
    private final ModCreativeTab tab;
    private final List<RegistryDelegate<?>> delegates = new ArrayList();
    private ImmutableList<ItemStack> resolvedItems = ImmutableList.of();

    public CreativeTabItemList(ModCreativeTab tab) {
        this.tab = tab;
    }

    public void add(Object ... objects) {
        for (Object obj : objects) {
            if (obj instanceof Block) {
                this.delegates.add(((Block)obj).delegate);
                continue;
            }
            if (obj instanceof Item) {
                this.delegates.add(((Item)obj).delegate);
                continue;
            }
            throw new IllegalArgumentException("Object is neither a Block nor Item!");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setupClient() {
        ModInitHandler.afterPreInit(this::resolveItems);
    }

    @SideOnly(value=Side.CLIENT)
    private void resolveItems() {
        ArrayList items = new ArrayList(this.delegates.size());
        for (RegistryDelegate<?> delegate : this.delegates) {
            if (delegate.type() == Block.class) {
                Block block = (Block)delegate.get();
                block.func_149647_a((CreativeTabs)this.tab);
                block.func_149666_a(Item.func_150898_a((Block)block), (CreativeTabs)this.tab, items);
                continue;
            }
            if (delegate.type() == Item.class) {
                Item item = (Item)delegate.get();
                item.func_77637_a((CreativeTabs)this.tab);
                item.func_150895_a(item, (CreativeTabs)this.tab, items);
                continue;
            }
            throw new IllegalArgumentException("Delegate contains an invalid object: " + delegate.type());
        }
        this.resolvedItems = ImmutableList.copyOf(items);
    }

    @SideOnly(value=Side.CLIENT)
    public List<ItemStack> getAllItems() {
        return this.resolvedItems;
    }
}

