/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.compendium.objects;

import chylex.hee.init.ItemList;
import chylex.hee.item.ItemSpawnEggs;
import chylex.hee.mechanics.compendium.objects.IKnowledgeObjectInstance;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ObjectMob
implements IKnowledgeObjectInstance<Class<? extends EntityLiving>> {
    private final Class<? extends EntityLiving> mobClass;

    public ObjectMob(Class<? extends EntityLiving> mobClass) {
        this.mobClass = mobClass;
    }

    @Override
    public Class<? extends EntityLiving> getUnderlyingObject() {
        return this.mobClass;
    }

    @Override
    public ItemStack createItemStackToRender() {
        ItemStack is = null;
        String name = "Unknown Mob";
        int spawnEggDamage = ItemSpawnEggs.getDamageForMob(this.mobClass);
        if (spawnEggDamage != -1) {
            is = new ItemStack(ItemList.spawn_eggs, 1, spawnEggDamage);
            name = ItemSpawnEggs.getMobName(this.mobClass);
        } else {
            for (int a = 0; a < 256; ++a) {
                if (EntityList.func_90035_a((int)a) != this.mobClass) continue;
                is = new ItemStack(Items.field_151063_bx, 1, a);
                name = (String)EntityList.field_75626_c.get(this.mobClass);
                break;
            }
        }
        if (is == null) {
            is = new ItemStack(Blocks.field_150357_h);
        }
        NBTTagCompound displayTag = new NBTTagCompound();
        displayTag.func_74778_a("Name", name);
        is.func_77982_d(new NBTTagCompound());
        is.func_77978_p().func_74782_a("display", (NBTBase)displayTag);
        return is;
    }

    @Override
    public boolean checkEquality(Object obj) {
        return obj == this.mobClass || obj.getClass() == this.mobClass;
    }
}

