/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.system.abstractions.entity;

import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;

public final class EntityAttributes {
    public static final IAttribute maxHealth = SharedMonsterAttributes.field_111267_a;
    public static final IAttribute attackDamage = SharedMonsterAttributes.field_111264_e;
    public static final IAttribute movementSpeed = SharedMonsterAttributes.field_111263_d;
    public static final IAttribute followRange = SharedMonsterAttributes.field_111265_b;

    public static void setValue(EntityLivingBase entity, IAttribute attribute, double baseValue) {
        entity.func_110148_a(attribute).func_111128_a(baseValue);
    }

    public static double getValue(EntityLivingBase entity, IAttribute attribute) {
        return entity.func_110148_a(attribute).func_111126_e();
    }

    public static boolean applyModifier(EntityLivingBase entity, IAttribute attribute, AttributeModifier modifier) {
        if (entity.func_110148_a(attribute).func_111127_a(modifier.func_111167_a()) == null) {
            entity.func_110148_a(attribute).func_111121_a(modifier);
            return true;
        }
        return false;
    }

    public static boolean hasModifier(EntityLivingBase entity, IAttribute attribute, AttributeModifier modifier) {
        return entity.func_110148_a(attribute).func_111127_a(modifier.func_111167_a()) != null;
    }

    public static boolean removeModifier(EntityLivingBase entity, IAttribute attribute, AttributeModifier modifier) {
        if (entity.func_110148_a(attribute).func_111127_a(modifier.func_111167_a()) != null) {
            entity.func_110148_a(attribute).func_111124_b(modifier);
            return true;
        }
        return false;
    }

    public static AttributeModifierBuilder createModifier(String name) {
        return new AttributeModifierBuilder(name);
    }

    public static AttributeModifier createModifier(String name, Operation operation, double value) {
        return new AttributeModifierBuilder(name).setValue(operation, value).build();
    }

    private EntityAttributes() {
    }

    public static enum Operation {
        ADD,
        ADD_MULTIPLIED,
        MULTIPLY;

    }

    public static class AttributeModifierBuilder {
        private final String name;
        private Operation operation;
        private double value;
        private boolean isSaved;

        private AttributeModifierBuilder(String name) {
            this.name = "HEE2 - " + name;
        }

        public AttributeModifierBuilder setValue(Operation operation, double value) {
            this.operation = operation;
            this.value = operation == Operation.MULTIPLY ? value - 1.0 : value;
            return this;
        }

        public AttributeModifierBuilder setSaved() {
            this.isSaved = true;
            return this;
        }

        public AttributeModifier build() {
            AttributeModifier modifier = new AttributeModifier(UUID.nameUUIDFromBytes(this.name.getBytes(StandardCharsets.US_ASCII)), this.name, this.value, this.operation.ordinal());
            modifier.func_111168_a(this.isSaved);
            return modifier;
        }
    }
}

