/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.tileentity.spawner;

import chylex.hee.entity.mob.EntityMobAngryEnderman;
import chylex.hee.tileentity.TileEntityCustomSpawner;
import chylex.hee.tileentity.spawner.CustomSpawnerLogic;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TowerEndermanSpawnerLogic
extends CustomSpawnerLogic {
    private final List<PotionEffect> effects = new ArrayList<PotionEffect>();
    private int minY;
    private int maxY;

    public TowerEndermanSpawnerLogic(TileEntityCustomSpawner spawnerTile) {
        super(spawnerTile);
        this.field_98283_g = 85;
        this.field_98293_h = 155;
        this.field_98290_m = (byte)3;
        this.attemptCount = (byte)6;
        this.field_98294_i = (byte)2;
        this.field_98292_k = (byte)3;
        this.minY = this.func_98274_c() - 1;
        this.maxY = this.func_98274_c() + 4;
    }

    public TowerEndermanSpawnerLogic setSpawnEffects(List<PotionEffect> effects) {
        this.effects.clear();
        this.effects.addAll(effects);
        return this;
    }

    public TowerEndermanSpawnerLogic setTestingY(int minY, int maxY) {
        this.minY = minY;
        this.maxY = maxY;
        return this;
    }

    @Override
    protected AxisAlignedBB getSpawnerCheckBB() {
        return AxisAlignedBB.func_72330_a((double)this.func_98275_b(), (double)this.minY, (double)this.func_98266_d(), (double)(this.func_98275_b() + 1), (double)this.maxY, (double)(this.func_98266_d() + 1)).func_72314_b((double)this.field_98290_m * 2.0, 0.5, (double)this.field_98290_m * 2.0);
    }

    @Override
    protected boolean checkSpawnerConditions() {
        return this.func_98271_a().func_72872_a(EntityMobAngryEnderman.class, this.getSpawnerCheckBB().func_72314_b(32.0, 256.0, 32.0)).size() < 32;
    }

    @Override
    protected boolean canMobSpawn(EntityLiving entity) {
        for (int yy = this.minY; yy <= this.maxY; ++yy) {
            entity.func_70012_b(entity.field_70165_t, (double)yy, entity.field_70161_v, entity.field_70177_z, 0.0f);
            if (!entity.func_70601_bi()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void onMobSpawned(EntityLiving entity) {
        for (PotionEffect effect : this.effects) {
            entity.func_70690_d(effect);
        }
    }

    @Override
    protected EntityLiving createMob(World world) {
        EntityMobAngryEnderman enderman = new EntityMobAngryEnderman(world);
        if (world != null) {
            enderman.setCanDespawn(true);
        }
        return enderman;
    }

    public void func_98280_b(NBTTagCompound nbt) {
        super.func_98280_b(nbt);
        NBTTagList nbtEffList = new NBTTagList();
        for (PotionEffect eff : this.effects) {
            nbtEffList.func_74742_a((NBTBase)eff.func_82719_a(new NBTTagCompound()));
        }
        nbt.func_74782_a("spawnEffects", (NBTBase)nbtEffList);
        nbt.func_74768_a("minY", this.minY);
        nbt.func_74768_a("maxY", this.maxY);
    }

    public void func_98270_a(NBTTagCompound nbt) {
        super.func_98270_a(nbt);
        NBTTagList nbtEffList = nbt.func_150295_c("spawnEffects", 10);
        for (int a = 0; a < nbtEffList.func_74745_c(); ++a) {
            this.effects.add(PotionEffect.func_82722_b((NBTTagCompound)nbtEffList.func_150305_b(a)));
        }
        this.minY = nbt.func_74762_e("minY");
        this.maxY = nbt.func_74762_e("maxY");
    }
}

