/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.feature.blobs.generators;

import chylex.hee.system.util.DragonUtil;
import chylex.hee.world.feature.blobs.BlobGenerator;
import chylex.hee.world.feature.util.DecoratorFeatureGenerator;
import chylex.hee.world.util.IRandomAmount;
import java.util.Random;
import net.minecraft.util.Vec3;

public class BlobGeneratorRecursive
extends BlobGenerator {
    private IRandomAmount baseAmountGen = IRandomAmount.exact;
    private IRandomAmount totalAmountGen = IRandomAmount.exact;
    private IRandomAmount recursionAmountGen = IRandomAmount.exact;
    private byte minAmount;
    private byte maxAmount;
    private byte minTotalAmountLimit;
    private byte maxTotalAmountLimit;
    private byte minRecursionAmount;
    private byte maxRecursionAmount;
    private byte maxRecursion;
    private double minRad;
    private double maxRad;
    private double minRecursionChance;
    private double maxRecursionChance;
    private double recursionChanceMp;
    private double minBlobDistMp;
    private double maxBlobDistMp;
    private boolean recursionChanceCached;
    private int tmpBlobsLeft;
    private double tmpRecursionChance;

    public BlobGeneratorRecursive(int weight) {
        super(weight);
    }

    public BlobGeneratorRecursive baseAmount(IRandomAmount baseAmountGen, int minAmount, int maxAmount) {
        this.baseAmountGen = baseAmountGen;
        this.minAmount = (byte)minAmount;
        this.maxAmount = (byte)maxAmount;
        return this;
    }

    public BlobGeneratorRecursive totalAmount(IRandomAmount totalAmountGen, int minTotalAmountLimit, int maxTotalAmountLimit) {
        this.totalAmountGen = totalAmountGen;
        this.minTotalAmountLimit = (byte)minTotalAmountLimit;
        this.maxTotalAmountLimit = (byte)maxTotalAmountLimit;
        return this;
    }

    public BlobGeneratorRecursive recursionAmount(IRandomAmount recursionAmountGen, int minRecursionAmount, int maxRecursionAmount) {
        this.recursionAmountGen = recursionAmountGen;
        this.minRecursionAmount = (byte)minRecursionAmount;
        this.maxRecursionAmount = (byte)maxRecursionAmount;
        return this;
    }

    public BlobGeneratorRecursive rad(double minRad, double maxRad) {
        this.minRad = minRad;
        this.maxRad = maxRad;
        return this;
    }

    public BlobGeneratorRecursive distMp(double minBlobDistMp, double maxBlobDistMp) {
        this.minBlobDistMp = minBlobDistMp;
        this.maxBlobDistMp = maxBlobDistMp;
        return this;
    }

    public BlobGeneratorRecursive recursionChance(double minRecursionChance, double maxRecursionChance, double recursionChanceMp, int maxRecursion) {
        this.minRecursionChance = minRecursionChance;
        this.maxRecursionChance = maxRecursionChance;
        this.recursionChanceMp = recursionChanceMp;
        this.maxRecursion = (byte)maxRecursion;
        return this;
    }

    public BlobGeneratorRecursive cacheRecursionChance() {
        this.recursionChanceCached = true;
        return this;
    }

    @Override
    public void generate(DecoratorFeatureGenerator gen, Random rand) {
        this.tmpBlobsLeft = this.totalAmountGen.generate(rand, this.minTotalAmountLimit, this.maxTotalAmountLimit);
        this.tmpRecursionChance = this.minRecursionChance + rand.nextDouble() * (this.maxRecursionChance - this.minRecursionChance);
        double firstRad = 0.0;
        int amount = this.baseAmountGen.generate(rand, this.minAmount, this.maxAmount);
        for (int a = 0; a < amount; ++a) {
            double rad = this.minRad + rand.nextDouble() * (this.maxRad - this.minRad);
            if (a == 0) {
                firstRad = rad;
            }
            Vec3 vec = a == 0 ? Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0) : DragonUtil.getRandomVector(rand);
            double dist = a == 0 ? 0.0 : firstRad * (this.minBlobDistMp + rand.nextDouble() * (this.maxBlobDistMp - this.minBlobDistMp));
            this.genNewBlob(gen, rand, vec.field_72450_a * dist, vec.field_72448_b * dist, vec.field_72449_c * dist, rad, 0);
        }
    }

    private void genNewBlob(DecoratorFeatureGenerator gen, Random rand, double x, double y, double z, double rad, int recursionLevel) {
        if (this.tmpBlobsLeft < 0 || recursionLevel >= this.maxRecursion) {
            return;
        }
        BlobGeneratorRecursive.genBlob(gen, x, y, z, rad);
        --this.tmpBlobsLeft;
        if (rand.nextDouble() < this.tmpRecursionChance * Math.pow(this.recursionChanceMp, recursionLevel)) {
            int amount = this.recursionAmountGen.generate(rand, this.minRecursionAmount, this.maxRecursionAmount);
            for (int a = 0; a < amount; ++a) {
                Vec3 dir = DragonUtil.getRandomVector(rand);
                double dist = rad * (this.minBlobDistMp + rand.nextDouble() * (this.maxBlobDistMp - this.minBlobDistMp));
                this.genNewBlob(gen, rand, x + dir.field_72450_a * dist, y + dir.field_72448_b * dist, z + dir.field_72449_c * dist, this.minRad + rand.nextDouble() * (this.maxRad - this.minRad), recursionLevel + 1);
            }
        }
        if (!this.recursionChanceCached) {
            this.tmpRecursionChance = this.minRecursionChance + rand.nextDouble() * (this.maxRecursionChance - this.minRecursionChance);
        }
    }
}

