/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.feature.blobs.populators;

import chylex.hee.system.util.BlockPosM;
import chylex.hee.world.feature.blobs.BlobPopulator;
import chylex.hee.world.feature.util.DecoratorFeatureGenerator;
import chylex.hee.world.loot.WeightedLootList;
import chylex.hee.world.structure.util.pregen.ITileEntityGenerator;
import chylex.hee.world.util.IRandomAmount;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;

public class BlobPopulatorChest
extends BlobPopulator
implements ITileEntityGenerator {
    private WeightedLootList lootList;
    private IRandomAmount amountGen = IRandomAmount.exact;
    private int minAmount;
    private int maxAmount;
    private boolean onlyInside;

    public BlobPopulatorChest(int weight) {
        super(weight);
    }

    public BlobPopulatorChest loot(WeightedLootList lootList, IRandomAmount amountGen, int minAmount, int maxAmount) {
        this.lootList = lootList;
        this.amountGen = amountGen;
        this.minAmount = minAmount;
        this.maxAmount = maxAmount;
        return this;
    }

    public BlobPopulatorChest onlyInside() {
        this.onlyInside = true;
        return this;
    }

    @Override
    public void generate(DecoratorFeatureGenerator gen, Random rand) {
        List<BlockPosM> locs = gen.getUsedLocations();
        while (!locs.isEmpty()) {
            BlockPosM loc = locs.remove(rand.nextInt(locs.size()));
            if (gen.getBlock(loc.x, loc.y, loc.z) != Blocks.field_150377_bs || gen.getBlock(loc.x, loc.y + 1, loc.z) != Blocks.field_150350_a || gen.getBlock(loc.x, loc.y + 2, loc.z) != Blocks.field_150350_a || this.onlyInside && gen.getTopBlockY(loc.x, loc.z) < loc.y + 2) continue;
            gen.setBlock(loc.x, loc.y + 1, loc.z, (Block)Blocks.field_150486_ae, rand.nextInt(4));
            gen.setTileEntity(loc.x, loc.y + 1, loc.z, this);
            break;
        }
    }

    @Override
    public void onTileEntityRequested(String key, TileEntity tile, Random rand) {
        TileEntityChest chest = (TileEntityChest)tile;
        int amount = this.amountGen.generate(rand, this.minAmount, this.maxAmount);
        for (int a = 0; a < amount; ++a) {
            chest.func_70299_a(rand.nextInt(chest.func_70302_i_()), this.lootList.generateIS(rand));
        }
    }
}

