/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.sanctuary.data;

import chylex.hee.system.logging.Log;
import chylex.hee.world.util.Direction;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class SanctuaryConquerPointGen {
    private final byte width;
    private final byte depth;
    private final boolean[][] available;
    private final List<byte[]> chosenPoints = new ArrayList<byte[]>();

    SanctuaryConquerPointGen(int width, int depth) {
        this.width = (byte)width;
        this.depth = (byte)depth;
        this.available = new boolean[width][depth];
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < depth; ++z) {
                this.available[x][z] = true;
            }
        }
    }

    boolean tryAddPoint(byte x, byte z) {
        if (!this.available[x][z]) {
            return false;
        }
        this.chosenPoints.add(new byte[]{x, z});
        for (byte px = (byte)(x - 1); px <= x + 1; px = (byte)(px + 1)) {
            for (byte pz = (byte)(z - 1); pz <= z + 1; pz = (byte)(pz + 1)) {
                this.tryBlock(px, pz);
            }
        }
        for (int dir = 0; dir < 4; ++dir) {
            this.tryBlock((byte)(x + Direction.offsetX[dir] * 2), (byte)(z + Direction.offsetZ[dir] * 2));
        }
        return true;
    }

    boolean tryBlock(byte x, byte z) {
        if (x < 0 || z < 0 || x >= this.width || z >= this.depth) {
            return false;
        }
        this.available[x][z] = false;
        return true;
    }

    public List<byte[]> getPoints() {
        return ImmutableList.copyOf(this.chosenPoints);
    }

    public static SanctuaryConquerPointGen generate(Random rand, int width, int depth, int conquerPointAmount) {
        byte[] loc;
        SanctuaryConquerPointGen pts = new SanctuaryConquerPointGen(width, depth);
        ArrayList<byte[]> options = new ArrayList<byte[]>();
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < depth; ++z) {
                options.add(new byte[]{(byte)x, (byte)z});
            }
        }
        while (!(options.isEmpty() || pts.tryAddPoint((loc = (byte[])options.remove(rand.nextInt(options.size())))[0], loc[1]) && pts.chosenPoints.size() >= conquerPointAmount)) {
        }
        if (pts.chosenPoints.size() != conquerPointAmount) {
            Log.warn("Incorrect conquer point amount, expected $0, got $1 ($2)", conquerPointAmount, pts.chosenPoints.size(), pts.chosenPoints);
        }
        return pts;
    }
}

