package ru.vizzi.bp.packet;

import hohserg.elegant.networking.impl.ISerializer;
import hohserg.elegant.networking.impl.SerializerMark;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;

@SerializerMark(
    packetClass = ru.vizzi.bp.packet.PacketSyncReward.class
)
public class PacketSyncRewardSerializer implements ISerializer<PacketSyncReward> {
  public void serialize(PacketSyncReward value, ByteBuf acc) {
    serialize_PacketSyncReward_Generic(value, acc);
  }

  public PacketSyncReward unserialize(ByteBuf buf) {
    return unserialize_PacketSyncReward_Generic(buf);
  }

  void serialize_ArrayList_of_NBTTagCompound_Generic(ArrayList<NBTTagCompound> value, ByteBuf acc) {
    acc.writeInt(value.size());
    for (NBTTagCompound e :value) {
      serialize_NBTTagCompound_Generic(e,acc);
    }
  }

  ArrayList<NBTTagCompound> unserialize_ArrayList_of_NBTTagCompound_Generic(ByteBuf buf) {
    int size = buf.readInt();
    java.util.ArrayList value = new java.util.ArrayList();
    for (int i=0;i<size;i++) {
      NBTTagCompound e = unserialize_NBTTagCompound_Generic(buf);
      value.add(e);
    }
    return value;
  }

  void serialize_PacketSyncReward_Generic(PacketSyncReward value, ByteBuf acc) {
    serialize_PacketSyncReward_Concretic(value, acc);
  }

  PacketSyncReward unserialize_PacketSyncReward_Generic(ByteBuf buf) {
    return unserialize_PacketSyncReward_Concretic(buf);
  }

  void serialize_PacketSyncReward_Concretic(PacketSyncReward value, ByteBuf acc) {
    serialize_ArrayList_of_NBTTagCompound_Generic(value.getNbtTagCompounds(), acc);
  }

  PacketSyncReward unserialize_PacketSyncReward_Concretic(ByteBuf buf) {
    PacketSyncReward value = new PacketSyncReward(unserialize_ArrayList_of_NBTTagCompound_Generic(buf));
    return value;
  }
}
