/*
 * Decompiled with CFR 0.152.
 */
package com.georgirim.mwveddingshop.tile;

import appeng.api.config.Actionable;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkTile;
import appeng.util.item.AEItemStack;
import com.georgirim.mwveddingshop.adapters.KotlinBlock;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import georgi.kotiln.collections.CollectionsKt;
import georgi.kotiln.jvm.internal.Intrinsics;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.justagod.cutter.GradleSide;
import ru.justagod.cutter.GradleSideOnly;

public abstract class AbstractTile
extends AENetworkTile
implements ISidedInventory {
    @Nullable
    private final KotlinBlock block;
    @NotNull
    private ArrayList<ItemStack> items;
    @NotNull
    private final BaseActionSource source;
    private final int GUI_ID;
    @Nullable
    private Integer side;
    @NotNull
    private String ownerName;
    @Nullable
    private UUID ownerUUID;
    private int tradeAmount;

    public AbstractTile(@Nullable KotlinBlock block) {
        this.block = block;
        ItemStack[] itemStackArray = new ItemStack[]{null, null};
        this.items = CollectionsKt.arrayListOf(itemStackArray);
        this.source = (BaseActionSource)new MachineSource((IActionHost)this);
        this.GUI_ID = 1;
        this.ownerName = "";
        this.ownerUUID = UUID.randomUUID();
    }

    @Nullable
    public final KotlinBlock getBlock() {
        return this.block;
    }

    @NotNull
    public final ArrayList<ItemStack> getItems() {
        return this.items;
    }

    public final void setItems(@NotNull ArrayList<ItemStack> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.items = arrayList;
    }

    @NotNull
    public final BaseActionSource getSource() {
        return this.source;
    }

    public AbstractTile() {
        this(null);
    }

    public int getGUI_ID() {
        return this.GUI_ID;
    }

    @Nullable
    public final Integer getSide() {
        if (this.side == null) {
            return 0;
        }
        return this.side;
    }

    protected final void setSide(@Nullable Integer n) {
        this.side = n;
    }

    @NotNull
    public final String getOwnerName() {
        return this.ownerName;
    }

    public final void setOwnerName(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.ownerName = string;
    }

    @Nullable
    public final UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public final void setOwnerUUID(@Nullable UUID uUID) {
        this.ownerUUID = uUID;
    }

    public final int getTradeAmount() {
        return this.tradeAmount;
    }

    public final void setTradeAmount(int n) {
        this.tradeAmount = n;
    }

    public final void onBlockPlacedBy(@NotNull World world, int x, int y, int z, @NotNull EntityLivingBase placer, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(placer, "placer");
        Intrinsics.checkNotNullParameter(stack, "stack");
        if (!(placer instanceof EntityPlayer)) {
            return;
        }
        this.ownerUUID = ((EntityPlayer)placer).func_110124_au();
        String string = ((EntityPlayer)placer).getDisplayName();
        Intrinsics.checkNotNullExpressionValue(string, "getDisplayName(...)");
        this.ownerName = string;
        int direction = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        this.side = direction;
    }

    public boolean onBlockActivated(@NotNull World world, int x, int y, int z, @NotNull EntityPlayer player, int p_149727_6_, float p_149727_7_, float p_149727_8_, float p_149727_9_) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(player, "player");
        return false;
    }

    @NotNull
    public final ArrayList<TileEntityChest> searchContainers() {
        ArrayList<TileEntityChest> tiles = new ArrayList<TileEntityChest>();
        TileEntity tile = null;
        tile = this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
        if (tile instanceof TileEntityChest) {
            tiles.add((TileEntityChest)tile);
        }
        if ((tile = this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e)) instanceof TileEntityChest) {
            tiles.add((TileEntityChest)tile);
        }
        if ((tile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) instanceof TileEntityChest) {
            tiles.add((TileEntityChest)tile);
        }
        if ((tile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) instanceof TileEntityChest) {
            tiles.add((TileEntityChest)tile);
        }
        if ((tile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1)) instanceof TileEntityChest) {
            tiles.add((TileEntityChest)tile);
        }
        if ((tile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)) instanceof TileEntityChest) {
            tiles.add((TileEntityChest)tile);
        }
        return tiles;
    }

    public final boolean addToContainer(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        block0: for (TileEntityChest chest : this.searchContainers()) {
            int n;
            int slot;
            if (chest == null || (slot = 0) > (n = chest.func_70302_i_() - 1)) continue;
            while (true) {
                ItemStack chestStack;
                if ((chestStack = chest.func_70301_a(slot)) == null) {
                    chest.func_70299_a(slot, itemStack);
                    return true;
                }
                if (Intrinsics.areEqual(chestStack.func_77973_b(), itemStack.func_77973_b()) && chestStack.field_77994_a + itemStack.field_77994_a < itemStack.func_77976_d()) {
                    itemStack.field_77994_a = chestStack.field_77994_a + itemStack.field_77994_a;
                    chest.func_70299_a(slot, itemStack);
                    return true;
                }
                if (slot == n) continue block0;
                ++slot;
            }
        }
        return false;
    }

    @GradleSideOnly(value={GradleSide.SERVER})
    @SideOnly(value=Side.SERVER)
    public final boolean addToAE2(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        if (this.getProxy() == null || !this.getProxy().isReady() || !this.getProxy().isPowered() || this.getProxy().getStorage() == null || this.getProxy().getStorage().getItemInventory() == null || this.field_145850_b.field_72995_K) {
            return false;
        }
        this.getProxy().getStorage().getItemInventory().injectItems((IAEStack)AEItemStack.create((ItemStack)itemStack), Actionable.MODULATE, this.source);
        return true;
    }

    @GradleSideOnly(value={GradleSide.SERVER})
    @SideOnly(value=Side.SERVER)
    public final boolean getToAE2(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        if (this.getProxy() == null || !this.getProxy().isReady() || !this.getProxy().isPowered() || this.getProxy().getStorage() == null || this.getProxy().getStorage().getItemInventory() == null || this.field_145850_b.field_72995_K) {
            return false;
        }
        IAEItemStack test = (IAEItemStack)this.getProxy().getStorage().getItemInventory().extractItems((IAEStack)AEItemStack.create((ItemStack)itemStack), Actionable.MODULATE, this.source);
        if (test == null) {
            return false;
        }
        if (test.getStackSize() < (long)itemStack.field_77994_a) {
            this.getProxy().getStorage().getItemInventory().injectItems((IAEStack)test, Actionable.MODULATE, this.source);
            return false;
        }
        return true;
    }

    @GradleSideOnly(value={GradleSide.SERVER})
    @SideOnly(value=Side.SERVER)
    public final boolean getFromContainer(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Iterator<TileEntityChest> iterator2 = this.searchContainers().iterator();
        block0: while (iterator2.hasNext()) {
            int slot = 0;
            TileEntityChest chest = iterator2.next();
            int n = chest.func_70302_i_() - 1;
            if (slot > n) continue;
            while (true) {
                ItemStack chestStack;
                if ((chestStack = chest.func_70301_a(slot)) != null && Intrinsics.areEqual(chestStack.func_77973_b(), itemStack.func_77973_b()) && chestStack.field_77994_a - itemStack.field_77994_a >= 0) {
                    chestStack.field_77994_a -= itemStack.field_77994_a;
                    if (chestStack.field_77994_a == 0) {
                        chestStack = null;
                    }
                    chest.func_70299_a(slot, chestStack);
                    return true;
                }
                if (slot == n) continue block0;
                ++slot;
            }
        }
        return false;
    }

    @NotNull
    public AECableType getCableConnectionType(@Nullable ForgeDirection p0) {
        return AECableType.SMART;
    }

    @NotNull
    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public final void writeToNBT1(@NotNull NBTTagCompound nbtTagCompound) {
        Intrinsics.checkNotNullParameter(nbtTagCompound, "nbtTagCompound");
        this.writeCustomNBT(nbtTagCompound);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public final void readFromNBT1(@NotNull NBTTagCompound nbtTagCompound) {
        Intrinsics.checkNotNullParameter(nbtTagCompound, "nbtTagCompound");
        this.readCustomNBT(nbtTagCompound);
    }

    public void writeCustomNBT(@NotNull NBTTagCompound nbtTagCompound) {
        Intrinsics.checkNotNullParameter(nbtTagCompound, "nbtTagCompound");
        NBTTagList invSlotsTag = new NBTTagList();
        for (ItemStack invSlot : this.items) {
            if (invSlot == null) continue;
            NBTTagCompound invSlotTag = new NBTTagCompound();
            invSlot.func_77955_b(invSlotTag);
            invSlotsTag.func_74742_a((NBTBase)invSlotTag);
        }
        nbtTagCompound.func_74782_a("InvSlots", (NBTBase)invSlotsTag);
        Integer n = this.getSide();
        Intrinsics.checkNotNull(n);
        nbtTagCompound.func_74768_a("side", n.intValue());
        nbtTagCompound.func_74768_a("tradeAmount", this.tradeAmount);
        nbtTagCompound.func_74778_a("ownerUUID", String.valueOf(this.ownerUUID));
        nbtTagCompound.func_74778_a("ownerName", this.ownerName);
    }

    public void readCustomNBT(@NotNull NBTTagCompound nbtTagCompound) {
        Intrinsics.checkNotNullParameter(nbtTagCompound, "nbtTagCompound");
        if (nbtTagCompound.func_74764_b("InvSlots")) {
            NBTTagList nBTTagList = nbtTagCompound.func_150295_c("InvSlots", 10);
            Intrinsics.checkNotNullExpressionValue(nBTTagList, "getTagList(...)");
            NBTTagList nbtTagList = nBTTagList;
            int n = nbtTagList.func_74745_c();
            for (int i = 0; i < n; ++i) {
                ItemStack item = ItemStack.func_77949_a((NBTTagCompound)nbtTagList.func_150305_b(i));
                this.items.set(i, item);
            }
        }
        this.tradeAmount = nbtTagCompound.func_74762_e("tradeAmount");
        this.side = nbtTagCompound.func_74762_e("side");
        try {
            this.ownerUUID = UUID.fromString(nbtTagCompound.func_74779_i("ownerUUID"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String string = nbtTagCompound.func_74779_i("ownerName");
        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
        this.ownerName = string;
    }

    public void onDataPacket(@NotNull NetworkManager net, @NotNull S35PacketUpdateTileEntity pkt) {
        Intrinsics.checkNotNullParameter(net, "net");
        Intrinsics.checkNotNullParameter(pkt, "pkt");
        super.onDataPacket(net, pkt);
        NBTTagCompound nBTTagCompound = pkt.func_148857_g();
        Intrinsics.checkNotNullExpressionValue(nBTTagCompound, "func_148857_g(...)");
        this.readCustomNBT(nBTTagCompound);
    }

    @NotNull
    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeCustomNBT(nbttagcompound);
        return (Packet)new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -999, nbttagcompound);
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    @Nullable
    public ItemStack func_70301_a(int index) {
        return this.items.get(index);
    }

    @NotNull
    public ItemStack func_70298_a(int slot, int amount) {
        if (this.items.get(slot) != null) {
            ItemStack stack = null;
            ItemStack itemStack = this.items.get(slot);
            Intrinsics.checkNotNull(itemStack);
            if (itemStack.field_77994_a <= amount) {
                ItemStack itemStack2 = this.items.get(slot);
                Intrinsics.checkNotNull(itemStack2);
                stack = itemStack2;
                this.items.set(slot, null);
            } else {
                ItemStack itemStack3 = this.items.get(slot);
                Intrinsics.checkNotNull(itemStack3);
                ItemStack itemStack4 = itemStack3.func_77979_a(amount);
                Intrinsics.checkNotNullExpressionValue(itemStack4, "splitStack(...)");
                stack = itemStack4;
                ItemStack itemStack5 = this.items.get(slot);
                Intrinsics.checkNotNull(itemStack5);
                if (itemStack5.field_77994_a <= 0) {
                    this.items.set(slot, null);
                }
            }
            this.func_70296_d();
            return stack;
        }
        Intrinsics.checkNotNull(null, "null cannot be cast to non-null type net.minecraft.item.ItemStack");
        return null;
    }

    @Nullable
    public ItemStack func_70304_b(int index) {
        ItemStack ret = this.func_70301_a(index);
        if (ret != null) {
            Intrinsics.checkNotNull(null);
            this.func_70299_a(index, null);
        }
        return ret;
    }

    public void func_70299_a(int slot, @Nullable ItemStack itemStack) {
        this.items.set(slot, itemStack);
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    @NotNull
    public String func_145825_b() {
        return "test";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        int max = 64;
        for (ItemStack slot : this.items) {
            if (slot == null) continue;
            max = Math.min(max, slot.func_77976_d());
        }
        return max;
    }

    public boolean func_70300_a(@NotNull EntityPlayer entityPlayer) {
        Intrinsics.checkNotNullParameter(entityPlayer, "entityPlayer");
        return !this.func_145837_r() && entityPlayer.func_70011_f((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, @NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        ItemStack invSlot = this.items.get(index);
        return true;
    }
}

